/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.aggregation.AggregationTestUtils;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.util.StructuralTestUtil;
import java.util.HashMap;
import java.util.Map;
import org.testng.annotations.Test;

public class TestMapUnionAggregation {
    private static final Metadata metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testSimpleWithDuplicates() {
        MapType mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR);
        InternalAggregationFunction aggFunc = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"map_union"), TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType})));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)23.0, (Object)"aaa", (Object)33.0, (Object)"bbb", (Object)43.0, (Object)"ccc", (Object)53.0, (Object)"ddd", (Object)13.0, (Object)"eee"), StructuralTestUtil.arrayBlockOf((Type)mapType, StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)23.0, (Object)"aaa", (Object)33.0, (Object)"bbb", (Object)53.0, (Object)"ddd")), StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)43.0, (Object)"ccc", (Object)53.0, (Object)"ddd", (Object)13.0, (Object)"eee"))));
        mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT);
        aggFunc = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"map_union"), TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType})));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)99L, (Object)2.0, (Object)99L, (Object)3.0, (Object)99L, (Object)4.0, (Object)44L), StructuralTestUtil.arrayBlockOf((Type)mapType, StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT, ImmutableMap.of((Object)1.0, (Object)99L, (Object)2.0, (Object)99L, (Object)3.0, (Object)99L)), StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT, ImmutableMap.of((Object)1.0, (Object)44L, (Object)2.0, (Object)44L, (Object)4.0, (Object)44L))));
        mapType = StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BigintType.BIGINT);
        aggFunc = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"map_union"), TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType})));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)false, (Object)12L, (Object)true, (Object)13L), StructuralTestUtil.arrayBlockOf((Type)mapType, StructuralTestUtil.mapBlockOf((Type)BooleanType.BOOLEAN, (Type)BigintType.BIGINT, ImmutableMap.of((Object)false, (Object)12L)), StructuralTestUtil.mapBlockOf((Type)BooleanType.BOOLEAN, (Type)BigintType.BIGINT, ImmutableMap.of((Object)true, (Object)13L, (Object)false, (Object)33L))));
    }

    @Test
    public void testSimpleWithNulls() {
        MapType mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR);
        InternalAggregationFunction aggFunc = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"map_union"), TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType})));
        Map<Object, Object> expected = TestMapUnionAggregation.mapOf(23.0, "aaa", 33.0, null, 43.0, "ccc", 53.0, "ddd");
        AggregationTestUtils.assertAggregation(aggFunc, expected, StructuralTestUtil.arrayBlockOf((Type)mapType, StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR, TestMapUnionAggregation.mapOf(23.0, "aaa", 33.0, null, 53.0, "ddd")), null, StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR, TestMapUnionAggregation.mapOf(43.0, "ccc", 53.0, "ddd"))));
    }

    @Test
    public void testStructural() {
        MapType mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)new ArrayType((Type)VarcharType.VARCHAR));
        InternalAggregationFunction aggFunc = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"map_union"), TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType})));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)3.0, (Object)ImmutableList.of((Object)"e", (Object)"f"), (Object)4.0, (Object)ImmutableList.of((Object)"r", (Object)"s")), StructuralTestUtil.arrayBlockOf((Type)mapType, StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)3.0, (Object)ImmutableList.of((Object)"e", (Object)"f"))), StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)"x", (Object)"y"), (Object)4.0, (Object)ImmutableList.of((Object)"r", (Object)"s"), (Object)3.0, (Object)ImmutableList.of((Object)"w", (Object)"z")))));
        mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR));
        aggFunc = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"map_union"), TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType})));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableMap.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableMap.of((Object)"c", (Object)"d"), (Object)3.0, (Object)ImmutableMap.of((Object)"e", (Object)"f")), StructuralTestUtil.arrayBlockOf((Type)mapType, StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)1.0, (Object)ImmutableMap.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableMap.of((Object)"c", (Object)"d"))), StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)3.0, (Object)ImmutableMap.of((Object)"e", (Object)"f")))));
        mapType = StructuralTestUtil.mapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)DoubleType.DOUBLE);
        aggFunc = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"map_union"), TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType})));
        AggregationTestUtils.assertAggregation(aggFunc, (Object)ImmutableMap.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)1.0, (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)2.0, (Object)ImmutableList.of((Object)"e", (Object)"f"), (Object)3.0), StructuralTestUtil.arrayBlockOf((Type)mapType, StructuralTestUtil.mapBlockOf((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)DoubleType.DOUBLE, ImmutableMap.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)1.0, (Object)ImmutableList.of((Object)"e", (Object)"f"), (Object)3.0)), StructuralTestUtil.mapBlockOf((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)DoubleType.DOUBLE, ImmutableMap.of((Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)2.0))));
    }

    private static Map<Object, Object> mapOf(Object ... entries) {
        Preconditions.checkArgument((entries.length % 2 == 0 ? 1 : 0) != 0);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < entries.length; i += 2) {
            map.put(entries[i], entries[i + 1]);
        }
        return map;
    }
}

