/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.airlift.stats.QuantileDigest;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.operator.aggregation.AggregationTestUtils;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.QuantileDigestParametricType;
import io.prestosql.spi.type.QuantileDigestType;
import io.prestosql.spi.type.SqlVarbinary;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.testng.annotations.Test;

public class TestMergeQuantileDigestFunction
extends AbstractTestAggregationFunction {
    public static final BiFunction<Object, Object, Boolean> QDIGEST_EQUALITY = (actualBinary, expectedBinary) -> {
        if (actualBinary == null && expectedBinary == null) {
            return true;
        }
        Objects.requireNonNull(actualBinary, "actual value was null");
        Objects.requireNonNull(expectedBinary, "expected value was null");
        QuantileDigest actual = new QuantileDigest(Slices.wrappedBuffer((byte[])((SqlVarbinary)actualBinary).getBytes()));
        QuantileDigest expected = new QuantileDigest(Slices.wrappedBuffer((byte[])((SqlVarbinary)expectedBinary).getBytes()));
        return actual.getCount() == expected.getCount() && actual.getMin() == expected.getMin() && actual.getMax() == expected.getMax() && actual.getAlpha() == expected.getAlpha() && actual.getMaxError() == expected.getMaxError();
    };

    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        Type type = this.metadata.getType(new TypeSignature(QuantileDigestParametricType.QDIGEST.getName(), new TypeSignatureParameter[]{TypeSignatureParameter.typeParameter((TypeSignature)DoubleType.DOUBLE.getTypeSignature())}));
        BlockBuilder blockBuilder = type.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            QuantileDigest qdigest = new QuantileDigest(0.0);
            qdigest.add((long)i);
            type.writeSlice(blockBuilder, qdigest.serialize());
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected String getFunctionName() {
        return "merge";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)new QuantileDigestType((Type)DoubleType.DOUBLE));
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        QuantileDigest qdigest = new QuantileDigest(0.0);
        for (int i = start; i < start + length; ++i) {
            qdigest.add((long)i);
        }
        return new SqlVarbinary(qdigest.serialize().getBytes());
    }

    @Override
    @Test
    public void testMultiplePositions() {
        AggregationTestUtils.assertAggregation(this.getFunction(), QDIGEST_EQUALITY, "test multiple positions", new Page(this.getSequenceBlocks(0, 5)), this.getExpectedValue(0, 5));
    }

    @Override
    @Test
    public void testMixedNullAndNonNullPositions() {
        AggregationTestUtils.assertAggregation(this.getFunction(), QDIGEST_EQUALITY, "test mixed null and nonnull position", new Page(TestMergeQuantileDigestFunction.createAlternatingNullsBlock(this.getFunction().getParameterTypes(), this.getSequenceBlocks(0, 10))), this.getExpectedValueIncludingNulls(0, 10, 20));
    }
}

