/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.stats.TDigest;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.SqlVarbinary;
import io.prestosql.spi.type.Type;
import io.prestosql.type.TDigestType;
import java.util.List;

public class TestMergeTDigestAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = TDigestType.TDIGEST.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            TDigest tdigest = new TDigest();
            tdigest.add((double)i);
            TDigestType.TDIGEST.writeObject(blockBuilder, (Object)tdigest);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected String getFunctionName() {
        return "merge";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)TDigestType.TDIGEST);
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        TDigest tdigest = new TDigest();
        for (int i = start; i < start + length; ++i) {
            tdigest.add((double)i);
        }
        return new SqlVarbinary(tdigest.serialize().getBytes());
    }
}

