/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import io.prestosql.operator.aggregation.TypedKeyValueHeap;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.type.BlockTypeOperators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypedKeyValueHeap {
    private static final int INPUT_SIZE = 1000000;
    private static final int OUTPUT_SIZE = 1000;
    private static final BlockTypeOperators TYPE_OPERATOR_FACTORY = new BlockTypeOperators(new TypeOperators());
    private static final BlockTypeOperators.BlockPositionComparison MAX_ELEMENTS_COMPARATOR = TYPE_OPERATOR_FACTORY.getComparisonOperator((Type)BigintType.BIGINT);
    private static final BlockTypeOperators.BlockPositionComparison MIN_ELEMENTS_COMPARATOR = TYPE_OPERATOR_FACTORY.getComparisonOperator((Type)BigintType.BIGINT).reversed();

    @Test
    public void testAscending() {
        TestTypedKeyValueHeap.test(IntStream.range(0, 1000000), IntStream.range(0, 1000000).mapToObj(key -> Integer.toString(key * 2)), MAX_ELEMENTS_COMPARATOR, IntStream.range(999000, 1000000).mapToObj(key -> Integer.toString(key * 2)).iterator());
        TestTypedKeyValueHeap.test(IntStream.range(0, 1000000), IntStream.range(0, 1000000).mapToObj(key -> Integer.toString(key * 2)), MIN_ELEMENTS_COMPARATOR, IntStream.range(0, 1000).map(x -> 999 - x).mapToObj(key -> Integer.toString(key * 2)).iterator());
    }

    @Test
    public void testDescending() {
        TestTypedKeyValueHeap.test(IntStream.range(0, 1000000).map(x -> 999999 - x), IntStream.range(0, 1000000).map(x -> 999999 - x).mapToObj(key -> Integer.toString(key * 2)), MAX_ELEMENTS_COMPARATOR, IntStream.range(999000, 1000000).mapToObj(key -> Integer.toString(key * 2)).iterator());
        TestTypedKeyValueHeap.test(IntStream.range(0, 1000000).map(x -> 999999 - x), IntStream.range(0, 1000000).map(x -> 999999 - x).mapToObj(key -> Integer.toString(key * 2)), MIN_ELEMENTS_COMPARATOR, IntStream.range(0, 1000).map(x -> 999 - x).mapToObj(key -> Integer.toString(key * 2)).iterator());
    }

    @Test
    public void testShuffled() {
        List list = IntStream.range(0, 1000000).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        Collections.shuffle(list);
        TestTypedKeyValueHeap.test(list.stream().mapToInt(Integer::intValue), list.stream().mapToInt(Integer::intValue).mapToObj(key -> Integer.toString(key * 2)), MAX_ELEMENTS_COMPARATOR, IntStream.range(999000, 1000000).mapToObj(key -> Integer.toString(key * 2)).iterator());
        TestTypedKeyValueHeap.test(list.stream().mapToInt(Integer::intValue), list.stream().mapToInt(Integer::intValue).mapToObj(key -> Integer.toString(key * 2)), MIN_ELEMENTS_COMPARATOR, IntStream.range(0, 1000).map(x -> 999 - x).mapToObj(key -> Integer.toString(key * 2)).iterator());
    }

    private static void test(IntStream keyInputStream, Stream<String> valueInputStream, BlockTypeOperators.BlockPositionComparison comparison, Iterator<String> outputIterator) {
        BlockBuilder keysBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, 1000000);
        BlockBuilder valuesBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1000000);
        keyInputStream.forEach(x -> BigintType.BIGINT.writeLong(keysBlockBuilder, (long)x));
        valueInputStream.forEach(x -> VarcharType.VARCHAR.writeString(valuesBlockBuilder, x));
        TypedKeyValueHeap heap = new TypedKeyValueHeap(comparison, (Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, 1000);
        heap.addAll((Block)keysBlockBuilder, (Block)valuesBlockBuilder);
        BlockBuilder resultBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1000);
        heap.popAll(resultBlockBuilder);
        Block resultBlock = resultBlockBuilder.build();
        Assert.assertEquals((int)resultBlock.getPositionCount(), (int)1000);
        for (int i = 0; i < 1000; ++i) {
            Assert.assertEquals((String)VarcharType.VARCHAR.getSlice(resultBlock, i).toStringUtf8(), (String)outputIterator.next());
        }
    }
}

