/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.operator.aggregation.AbstractTestAggregationFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.spi.type.VarcharType;
import java.util.List;

public class TestVarBinaryMinAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = VarbinaryType.VARBINARY.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            VarbinaryType.VARBINARY.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])Ints.toByteArray((int)i)));
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        Slice min = null;
        for (int i = start; i < start + length; ++i) {
            Slice slice = Slices.wrappedBuffer((byte[])Ints.toByteArray((int)i));
            min = min == null ? slice : (Slice)Ordering.natural().min((Object)min, (Object)slice);
        }
        return min.toStringUtf8();
    }

    @Override
    protected String getFunctionName() {
        return "min";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)VarcharType.VARCHAR);
    }
}

