/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.minmaxby;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.aggregation.AggregationTestUtils;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.SqlDecimal;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.type.UnknownType;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMinMaxByAggregation {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();

    @Test
    public void testAllRegistered() {
        Set orderableTypes = (Set)TestMinMaxByAggregation.getTypes().stream().filter(Type::isOrderable).collect(ImmutableSet.toImmutableSet());
        for (Type keyType : orderableTypes) {
            for (Type valueType : TestMinMaxByAggregation.getTypes()) {
                Assert.assertNotNull((Object)METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{valueType, keyType}))));
                Assert.assertNotNull((Object)METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{valueType, keyType}))));
            }
        }
    }

    private static List<Type> getTypes() {
        return new ImmutableList.Builder().addAll((Iterable)METADATA.getTypes()).add((Object)VarcharType.VARCHAR).add((Object)DecimalType.createDecimalType((int)1)).add((Object)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE))).build();
    }

    @Test
    public void testMinUnknown() {
        InternalAggregationFunction unknownKey = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{UnknownType.UNKNOWN, DoubleType.DOUBLE})));
        AggregationTestUtils.assertAggregation(unknownKey, null, BlockAssertions.createBooleansBlock(null, null), BlockAssertions.createDoublesBlock(1.0, 2.0));
        AggregationTestUtils.assertAggregation(unknownKey, null, BlockAssertions.createDoublesBlock(1.0, 2.0), BlockAssertions.createBooleansBlock(null, null));
    }

    @Test
    public void testMaxUnknown() {
        InternalAggregationFunction unknownKey = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{UnknownType.UNKNOWN, DoubleType.DOUBLE})));
        AggregationTestUtils.assertAggregation(unknownKey, null, BlockAssertions.createBooleansBlock(null, null), BlockAssertions.createDoublesBlock(1.0, 2.0));
        AggregationTestUtils.assertAggregation(unknownKey, null, BlockAssertions.createDoublesBlock(1.0, 2.0), BlockAssertions.createBooleansBlock(null, null));
    }

    @Test
    public void testMinNull() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE})));
        AggregationTestUtils.assertAggregation(function, (Object)1.0, BlockAssertions.createDoublesBlock(1.0, null), BlockAssertions.createDoublesBlock(1.0, 2.0));
        AggregationTestUtils.assertAggregation(function, (Object)10.0, BlockAssertions.createDoublesBlock(10.0, 9.0, 8.0, 11.0), BlockAssertions.createDoublesBlock(1.0, null, 2.0, null));
    }

    @Test
    public void testMaxNull() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE})));
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createDoublesBlock(1.0, null), BlockAssertions.createDoublesBlock(1.0, 2.0));
        AggregationTestUtils.assertAggregation(function, (Object)10.0, BlockAssertions.createDoublesBlock(8.0, 9.0, 10.0, 11.0), BlockAssertions.createDoublesBlock(-2.0, null, -1.0, null));
    }

    @Test
    public void testMinDoubleDouble() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE})));
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createDoublesBlock(null, null));
        AggregationTestUtils.assertAggregation(function, (Object)3.0, BlockAssertions.createDoublesBlock(3.0, 2.0, 5.0, 3.0), BlockAssertions.createDoublesBlock(1.0, 1.5, 2.0, 4.0));
    }

    @Test
    public void testMaxDoubleDouble() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE})));
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createDoublesBlock(null, null));
        AggregationTestUtils.assertAggregation(function, (Object)2.0, BlockAssertions.createDoublesBlock(3.0, 2.0, null), BlockAssertions.createDoublesBlock(1.0, 1.5, null));
    }

    @Test
    public void testMinVarcharDouble() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR})));
        AggregationTestUtils.assertAggregation(function, (Object)100.0, BlockAssertions.createDoublesBlock(100.0, 1.0, 50.0, 2.0), BlockAssertions.createStringsBlock("a", "b", "c", "d"));
        AggregationTestUtils.assertAggregation(function, (Object)-1.0, BlockAssertions.createDoublesBlock(100.0, 50.0, 2.0, -1.0), BlockAssertions.createStringsBlock("x", "y", "z", "a"));
    }

    @Test
    public void testMinDoubleVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE})));
        AggregationTestUtils.assertAggregation(function, (Object)"z", BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createDoublesBlock(1.0, 2.0, 2.0, 3.0));
        AggregationTestUtils.assertAggregation(function, (Object)"a", BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0, -1.0));
    }

    @Test
    public void testMaxDoubleVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE})));
        AggregationTestUtils.assertAggregation(function, (Object)"a", BlockAssertions.createStringsBlock("z", "a", null), BlockAssertions.createDoublesBlock(1.0, 2.0, null));
        AggregationTestUtils.assertAggregation(function, (Object)"hi", BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, null, -1.0));
        AggregationTestUtils.assertAggregation(function, (Object)"c", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createDoublesBlock(Double.NaN, 1.0, 2.0));
        AggregationTestUtils.assertAggregation(function, (Object)"c", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createDoublesBlock(1.0, Double.NaN, 2.0));
        AggregationTestUtils.assertAggregation(function, (Object)"b", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createDoublesBlock(1.0, 2.0, Double.NaN));
    }

    @Test
    public void testMinRealVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, RealType.REAL})));
        AggregationTestUtils.assertAggregation(function, (Object)"z", BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)));
        AggregationTestUtils.assertAggregation(function, (Object)"a", BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createBlockOfReals(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(-1.0f)));
        AggregationTestUtils.assertAggregation(function, (Object)"b", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBlockOfReals(Float.valueOf(Float.NaN), Float.valueOf(1.0f), Float.valueOf(2.0f)));
        AggregationTestUtils.assertAggregation(function, (Object)"a", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(Float.NaN), Float.valueOf(2.0f)));
        AggregationTestUtils.assertAggregation(function, (Object)"a", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(Float.NaN)));
    }

    @Test
    public void testMaxRealVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, RealType.REAL})));
        AggregationTestUtils.assertAggregation(function, (Object)"a", BlockAssertions.createStringsBlock("z", "a", null), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), null));
        AggregationTestUtils.assertAggregation(function, (Object)"hi", BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createBlockOfReals(Float.valueOf(0.0f), Float.valueOf(1.0f), null, Float.valueOf(-1.0f)));
        AggregationTestUtils.assertAggregation(function, (Object)"c", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBlockOfReals(Float.valueOf(Float.NaN), Float.valueOf(1.0f), Float.valueOf(2.0f)));
        AggregationTestUtils.assertAggregation(function, (Object)"c", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(Float.NaN), Float.valueOf(2.0f)));
        AggregationTestUtils.assertAggregation(function, (Object)"b", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(Float.NaN)));
    }

    @Test
    public void testMinLongLongArray() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)8L, (Object)9L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)8L, (Object)9L), (Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)6L, (Object)7L), (Object)ImmutableList.of((Object)2L, (Object)3L))), BlockAssertions.createLongsBlock(1L, 2L, 2L, 3L));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)2L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)8L, (Object)9L), (Object)ImmutableList.of((Object)6L, (Object)7L), (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)2L))), BlockAssertions.createLongsBlock(0L, 1L, 2L, -1L));
    }

    @Test
    public void testMinLongArrayLong() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, new ArrayType((Type)BigintType.BIGINT)})));
        AggregationTestUtils.assertAggregation(function, (Object)3L, BlockAssertions.createLongsBlock(1L, 2L, 2L, 3L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)8L, (Object)9L), (Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)6L, (Object)7L), (Object)ImmutableList.of((Object)1L, (Object)1L))));
        AggregationTestUtils.assertAggregation(function, (Object)-1L, BlockAssertions.createLongsBlock(0L, 1L, 2L, -1L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)8L, (Object)9L), (Object)ImmutableList.of((Object)6L, (Object)7L), (Object)ImmutableList.of((Object)-1L, (Object)-3L), (Object)ImmutableList.of((Object)-1L))));
    }

    @Test
    public void testMaxLongArrayLong() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, new ArrayType((Type)BigintType.BIGINT)})));
        AggregationTestUtils.assertAggregation(function, (Object)1L, BlockAssertions.createLongsBlock(1L, 2L, 2L, 3L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)8L, (Object)9L), (Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)6L, (Object)7L), (Object)ImmutableList.of((Object)1L, (Object)1L))));
        AggregationTestUtils.assertAggregation(function, (Object)2L, BlockAssertions.createLongsBlock(0L, 1L, 2L, -1L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)-8L, (Object)9L), (Object)ImmutableList.of((Object)-6L, (Object)7L), (Object)ImmutableList.of((Object)-1L, (Object)-3L), (Object)ImmutableList.of((Object)-1L))));
    }

    @Test
    public void testMaxLongLongArray() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)1L, (Object)2L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), Arrays.asList(1L, 2L), null)), BlockAssertions.createLongsBlock(1L, 2L, null));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)2L, (Object)3L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), Arrays.asList(2L, 3L), null, Arrays.asList(1L, 2L))), BlockAssertions.createLongsBlock(0L, 1L, null, -1L));
    }

    @Test
    public void testMinLongDecimalDecimal() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DecimalType.createDecimalType((int)19, (int)1), DecimalType.createDecimalType((int)19, (int)1)})));
        AggregationTestUtils.assertAggregation(function, (Object)SqlDecimal.of((String)"2.2"), BlockAssertions.createLongDecimalsBlock("1.1", "2.2", "3.3"), BlockAssertions.createLongDecimalsBlock("1.2", "1.0", "2.0"));
    }

    @Test
    public void testMaxLongDecimalDecimal() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DecimalType.createDecimalType((int)19, (int)1), DecimalType.createDecimalType((int)19, (int)1)})));
        AggregationTestUtils.assertAggregation(function, (Object)SqlDecimal.of((String)"3.3"), BlockAssertions.createLongDecimalsBlock("1.1", "2.2", "3.3", "4.4"), BlockAssertions.createLongDecimalsBlock("1.2", "1.0", "2.0", "1.5"));
    }

    @Test
    public void testMinShortDecimalDecimal() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DecimalType.createDecimalType((int)10, (int)1), DecimalType.createDecimalType((int)10, (int)1)})));
        AggregationTestUtils.assertAggregation(function, (Object)SqlDecimal.of((String)"2.2"), BlockAssertions.createShortDecimalsBlock("1.1", "2.2", "3.3"), BlockAssertions.createShortDecimalsBlock("1.2", "1.0", "2.0"));
    }

    @Test
    public void testMaxShortDecimalDecimal() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DecimalType.createDecimalType((int)10, (int)1), DecimalType.createDecimalType((int)10, (int)1)})));
        AggregationTestUtils.assertAggregation(function, (Object)SqlDecimal.of((String)"3.3"), BlockAssertions.createShortDecimalsBlock("1.1", "2.2", "3.3", "4.4"), BlockAssertions.createShortDecimalsBlock("1.2", "1.0", "2.0", "1.5"));
    }

    @Test
    public void testMinBooleanVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, BooleanType.BOOLEAN})));
        AggregationTestUtils.assertAggregation(function, (Object)"b", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBooleansBlock(true, false, true));
    }

    @Test
    public void testMaxBooleanVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, BooleanType.BOOLEAN})));
        AggregationTestUtils.assertAggregation(function, (Object)"c", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createBooleansBlock(false, false, true));
    }

    @Test
    public void testMinIntegerVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, IntegerType.INTEGER})));
        AggregationTestUtils.assertAggregation(function, (Object)"a", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createIntsBlock(1, 2, 3));
    }

    @Test
    public void testMaxIntegerVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, IntegerType.INTEGER})));
        AggregationTestUtils.assertAggregation(function, (Object)"c", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createIntsBlock(1, 2, 3));
    }

    @Test
    public void testMinBooleanLongArray() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), BooleanType.BOOLEAN})));
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, null)), BlockAssertions.createBooleansBlock(true, false, true));
    }

    @Test
    public void testMaxBooleanLongArray() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), BooleanType.BOOLEAN})));
        AggregationTestUtils.assertAggregation(function, Arrays.asList(2L, 2L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createBooleansBlock(false, false, true));
    }

    @Test
    public void testMinLongVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, (Object)"a", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createLongsBlock(1, 2, 3));
    }

    @Test
    public void testMaxLongVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, (Object)"c", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createLongsBlock(1, 2, 3));
    }

    @Test
    public void testMinDoubleLongArray() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), DoubleType.DOUBLE})));
        AggregationTestUtils.assertAggregation(function, Arrays.asList(3L, 4L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0));
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, Arrays.asList(2L, 2L))), BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0));
    }

    @Test
    public void testMaxDoubleLongArray() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), DoubleType.DOUBLE})));
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createDoublesBlock(1.0, 2.0, null));
        AggregationTestUtils.assertAggregation(function, Arrays.asList(2L, 2L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0));
    }

    @Test
    public void testMinSliceLongArray() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), VarcharType.VARCHAR})));
        AggregationTestUtils.assertAggregation(function, Arrays.asList(3L, 4L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createStringsBlock("a", "b", "c"));
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, Arrays.asList(2L, 2L))), BlockAssertions.createStringsBlock("a", "b", "c"));
    }

    @Test
    public void testMaxSliceLongArray() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), VarcharType.VARCHAR})));
        AggregationTestUtils.assertAggregation(function, Arrays.asList(2L, 2L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))), BlockAssertions.createStringsBlock("a", "b", "c"));
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, null)), BlockAssertions.createStringsBlock("a", "b", "c"));
    }

    @Test
    public void testMinLongArrayLongArray() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT)})));
        AggregationTestUtils.assertAggregation(function, Arrays.asList(1L, 2L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 3L), null, Arrays.asList(1L, 2L))), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))));
    }

    @Test
    public void testMaxLongArrayLongArray() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT)})));
        AggregationTestUtils.assertAggregation(function, Arrays.asList(3L, 3L), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 3L), null, Arrays.asList(1L, 2L))), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))));
    }

    @Test
    public void testMinLongArraySlice() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, new ArrayType((Type)BigintType.BIGINT)})));
        AggregationTestUtils.assertAggregation(function, (Object)"c", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))));
    }

    @Test
    public void testMaxLongArraySlice() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, new ArrayType((Type)BigintType.BIGINT)})));
        AggregationTestUtils.assertAggregation(function, (Object)"a", BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 4L), null, Arrays.asList(2L, 2L))));
    }

    @Test
    public void testMinUnknownSlice() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, UnknownType.UNKNOWN})));
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null)));
    }

    @Test
    public void testMaxUnknownSlice() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, UnknownType.UNKNOWN})));
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createStringsBlock("a", "b", "c"), BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null)));
    }

    @Test
    public void testMinUnknownLongArray() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), UnknownType.UNKNOWN})));
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 3L), null, Arrays.asList(1L, 2L))), BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null)));
    }

    @Test
    public void testMaxUnknownLongArray() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), UnknownType.UNKNOWN})));
        AggregationTestUtils.assertAggregation(function, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(Arrays.asList(3L, 3L), null, Arrays.asList(1L, 2L))), BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null)));
    }
}

