/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.minmaxby;

import com.google.common.collect.ImmutableList;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.operator.aggregation.AggregationTestUtils;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.tree.QualifiedName;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestMinMaxByNAggregation {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();

    @Test
    public void testMaxDoubleDouble() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE, BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, Arrays.asList(new Double[]{null}), new Block[]{BlockAssertions.createDoublesBlock(1.0, null), BlockAssertions.createDoublesBlock(3.0, 5.0), BlockAssertions.createRLEBlock(1L, 2)});
        AggregationTestUtils.assertAggregation(function, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createRLEBlock(1L, 2)});
        AggregationTestUtils.assertAggregation(function, Arrays.asList(1.0), new Block[]{BlockAssertions.createDoublesBlock(null, 1.0, null, null), BlockAssertions.createDoublesBlock(null, 0.0, null, null), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, Arrays.asList(1.0), new Block[]{BlockAssertions.createDoublesBlock(1.0), BlockAssertions.createDoublesBlock(0.0), BlockAssertions.createRLEBlock(2L, 1)});
        AggregationTestUtils.assertAggregation(function, null, new Block[]{BlockAssertions.createDoublesBlock(new Double[0]), BlockAssertions.createDoublesBlock(new Double[0]), BlockAssertions.createRLEBlock(2L, 0)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)2.5), new Block[]{BlockAssertions.createDoublesBlock(2.5, 2.0, 5.0, 3.0), BlockAssertions.createDoublesBlock(4.0, 1.5, 2.0, 3.0), BlockAssertions.createRLEBlock(1L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)2.5, (Object)3.0), new Block[]{BlockAssertions.createDoublesBlock(2.5, 2.0, 5.0, 3.0), BlockAssertions.createDoublesBlock(4.0, 1.5, 2.0, 3.0), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMinDoubleDouble() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE, BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, Arrays.asList(new Double[]{null}), new Block[]{BlockAssertions.createDoublesBlock(1.0, null), BlockAssertions.createDoublesBlock(5.0, 3.0), BlockAssertions.createRLEBlock(1L, 2)});
        AggregationTestUtils.assertAggregation(function, null, new Block[]{BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createDoublesBlock(null, null), BlockAssertions.createRLEBlock(1L, 2)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)2.0), new Block[]{BlockAssertions.createDoublesBlock(2.5, 2.0, 5.0, 3.0), BlockAssertions.createDoublesBlock(4.0, 1.5, 2.0, 3.0), BlockAssertions.createRLEBlock(1L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)2.0, (Object)5.0), new Block[]{BlockAssertions.createDoublesBlock(2.5, 2.0, 5.0, 3.0), BlockAssertions.createDoublesBlock(4.0, 1.5, 2.0, 3.0), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMinDoubleVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"z", (Object)"a"), new Block[]{BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createDoublesBlock(1.0, 2.0, 2.0, 3.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"zz"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0, -1.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"zz"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, null, -1.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"b", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(Double.NaN, 2.0, 3.0, 4.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(1.0, Double.NaN, 3.0, 4.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(1.0, 2.0, Double.NaN, 4.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0, Double.NaN), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b"), BlockAssertions.createDoublesBlock(1.0, Double.NaN), BlockAssertions.createRLEBlock(2L, 2)});
    }

    @Test
    public void testMaxDoubleVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"z"), new Block[]{BlockAssertions.createStringsBlock("z", "a", null), BlockAssertions.createDoublesBlock(1.0, 2.0, null), BlockAssertions.createRLEBlock(2L, 3)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"bb", (Object)"hi"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0, -1.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"hi", (Object)"zz"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createDoublesBlock(0.0, 1.0, null, -1.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"d", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(Double.NaN, 2.0, 3.0, 4.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"d", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(1.0, Double.NaN, 3.0, 4.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"d", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(1.0, 2.0, Double.NaN, 4.0), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"c", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createDoublesBlock(1.0, 2.0, 3.0, Double.NaN), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b"), BlockAssertions.createDoublesBlock(1.0, Double.NaN), BlockAssertions.createRLEBlock(2L, 2)});
    }

    @Test
    public void testMinRealVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, RealType.REAL, BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"z", (Object)"a"), new Block[]{BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"zz"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createBlockOfReals(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(-1.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"zz"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createBlockOfReals(Float.valueOf(0.0f), Float.valueOf(1.0f), null, Float.valueOf(-1.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"b", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(Float.NaN), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(Float.NaN), Float.valueOf(3.0f), Float.valueOf(4.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(Float.NaN), Float.valueOf(4.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(Float.NaN)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(Float.NaN)), BlockAssertions.createRLEBlock(2L, 2)});
    }

    @Test
    public void testMaxRealVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, RealType.REAL, BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"z"), new Block[]{BlockAssertions.createStringsBlock("z", "a", null), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), null), BlockAssertions.createRLEBlock(2L, 3)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"bb", (Object)"hi"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createBlockOfReals(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(-1.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"hi", (Object)"zz"), new Block[]{BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createBlockOfReals(Float.valueOf(0.0f), Float.valueOf(1.0f), null, Float.valueOf(-1.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"d", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(Float.NaN), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"d", (Object)"c"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(Float.NaN), Float.valueOf(3.0f), Float.valueOf(4.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"d", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(Float.NaN), Float.valueOf(4.0f)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"c", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b", "c", "d"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(Float.NaN)), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"b"), new Block[]{BlockAssertions.createStringsBlock("a", "b"), BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(Float.NaN)), BlockAssertions.createRLEBlock(2L, 2)});
    }

    @Test
    public void testMinVarcharDouble() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)2.0, (Object)3.0), new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, 2.0, 3.0), BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)-1.0, (Object)2.0), new Block[]{BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0, -1.0), BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)-1.0, (Object)1.0), new Block[]{BlockAssertions.createDoublesBlock(0.0, 1.0, null, -1.0), BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMaxVarcharDouble() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE, VarcharType.VARCHAR, BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)1.0, (Object)2.0), new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.0, null), BlockAssertions.createStringsBlock("z", "a", null), BlockAssertions.createRLEBlock(2L, 3)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)0.0, (Object)1.0), new Block[]{BlockAssertions.createDoublesBlock(0.0, 1.0, 2.0, -1.0), BlockAssertions.createStringsBlock("zz", "hi", "bb", "a"), BlockAssertions.createRLEBlock(2L, 4)});
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)0.0, (Object)1.0), new Block[]{BlockAssertions.createDoublesBlock(0.0, 1.0, null, -1.0), BlockAssertions.createStringsBlock("zz", "hi", null, "a"), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMinVarcharArray() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), VarcharType.VARCHAR, BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)4L, (Object)5L)), new Block[]{BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)3L, (Object)4L), (Object)ImmutableList.of((Object)4L, (Object)5L))), BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMaxVarcharArray() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT), VarcharType.VARCHAR, BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)3L, (Object)4L)), new Block[]{BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)3L, (Object)4L), (Object)ImmutableList.of((Object)4L, (Object)5L))), BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createRLEBlock(2L, 4)});
    }

    @Test
    public void testMinArrayVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"min_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, new ArrayType((Type)BigintType.BIGINT), BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"b", (Object)"x", (Object)"z"), new Block[]{BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)0L, (Object)3L), (Object)ImmutableList.of((Object)0L, (Object)2L))), BlockAssertions.createRLEBlock(3L, 4)});
    }

    @Test
    public void testMaxArrayVarchar() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, new ArrayType((Type)BigintType.BIGINT), BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(function, (Object)ImmutableList.of((Object)"a", (Object)"z", (Object)"x"), new Block[]{BlockAssertions.createStringsBlock("z", "a", "x", "b"), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)2L), (Object)ImmutableList.of((Object)2L, (Object)3L), (Object)ImmutableList.of((Object)0L, (Object)3L), (Object)ImmutableList.of((Object)0L, (Object)2L))), BlockAssertions.createRLEBlock(3L, 4)});
    }

    @Test
    public void testOutOfBound() {
        InternalAggregationFunction function = METADATA.getAggregateFunctionImplementation(METADATA.resolveFunction(QualifiedName.of((String)"max_by"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT})));
        try {
            AggregationTestUtils.groupedAggregation(function, new Page(new Block[]{BlockAssertions.createStringsBlock("z"), BlockAssertions.createLongsBlock(0), BlockAssertions.createLongsBlock(10001)}));
        }
        catch (PrestoException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"third argument of max_by/min_by must be less than or equal to 10000; found 10001");
        }
    }
}

