/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.project;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.block.BlockAssertions;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarcharType;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=5)
@Warmup(iterations=10)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkDictionaryBlockGetSizeInBytes {
    @Benchmark
    public long getSizeInBytes(BenchmarkData data) {
        return data.getDictionaryBlock().getSizeInBytes();
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkDictionaryBlockGetSizeInBytes().getSizeInBytes(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkDictionaryBlockGetSizeInBytes.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int POSITIONS = 100000;
        @Param(value={"100", "1000", "10000", "100000"})
        private String selectedPositions = "100";
        private DictionaryBlock dictionaryBlock;

        @Setup(value=Level.Invocation)
        public void setup() {
            this.dictionaryBlock = new DictionaryBlock(BenchmarkData.createMapBlock(100000), BenchmarkData.generateIds(Integer.parseInt(this.selectedPositions), 100000));
        }

        private static Block createMapBlock(int positionCount) {
            MapType mapType = (MapType)MetadataManager.createTestMetadataManager().getType(new TypeSignature("map", new TypeSignatureParameter[]{TypeSignatureParameter.typeParameter((TypeSignature)VarcharType.VARCHAR.getTypeSignature()), TypeSignatureParameter.typeParameter((TypeSignature)VarcharType.VARCHAR.getTypeSignature())}));
            Block keyBlock = BenchmarkData.createDictionaryBlock(BenchmarkData.generateList("key", positionCount));
            Block valueBlock = BenchmarkData.createDictionaryBlock(BenchmarkData.generateList("value", positionCount));
            int[] offsets = new int[positionCount + 1];
            int mapSize = keyBlock.getPositionCount() / positionCount;
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = mapSize * i;
            }
            return mapType.createBlockFromKeyValue(Optional.empty(), offsets, keyBlock, valueBlock);
        }

        private static Block createDictionaryBlock(List<String> values) {
            Block dictionary = BenchmarkData.createSliceArrayBlock(values);
            int[] ids = new int[values.size()];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = i;
            }
            return new DictionaryBlock(dictionary, ids);
        }

        private static Block createSliceArrayBlock(List<String> values) {
            Slice[] sliceArray = new Slice[values.size() + 1];
            for (int i = 0; i < values.size(); ++i) {
                sliceArray[i] = Slices.utf8Slice((String)values.get(i));
            }
            return BlockAssertions.createSlicesBlock(sliceArray);
        }

        private static List<String> generateList(String prefix, int count) {
            ImmutableList.Builder list = ImmutableList.builder();
            for (int i = 0; i < count; ++i) {
                list.add((Object)(prefix + Integer.toString(i)));
            }
            return list.build();
        }

        private static int[] generateIds(int count, int range) {
            return new Random().ints(count, 0, range).toArray();
        }

        public DictionaryBlock getDictionaryBlock() {
            return this.dictionaryBlock;
        }
    }
}

