/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.project;

import io.prestosql.block.BlockAssertions;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.project.InputPageProjection;
import io.prestosql.operator.project.SelectedPositions;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.LazyBlock;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.testing.TestingConnectorSession;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInputPageProjection {
    @Test
    public void testLazyInputPage() {
        InputPageProjection projection = new InputPageProjection(0, (Type)BigintType.BIGINT);
        Block block = BlockAssertions.createLongSequenceBlock(0, 100);
        Block result = (Block)projection.project(TestingConnectorSession.SESSION, new DriverYieldSignal(), new Page(new Block[]{block}), SelectedPositions.positionsRange((int)0, (int)100)).getResult();
        Assert.assertFalse((boolean)(result instanceof LazyBlock));
        block = TestInputPageProjection.lazyWrapper(block);
        result = (Block)projection.project(TestingConnectorSession.SESSION, new DriverYieldSignal(), new Page(new Block[]{block}), SelectedPositions.positionsRange((int)0, (int)100)).getResult();
        Assert.assertTrue((boolean)(result instanceof LazyBlock));
        Assert.assertFalse((boolean)result.isLoaded());
    }

    private static LazyBlock lazyWrapper(Block block) {
        return new LazyBlock(block.getPositionCount(), () -> ((Block)block).getLoadedBlock());
    }
}

