/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.testing.Closeables;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.metadata.FunctionListBuilder;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.operator.scalar.FunctionAssertions;
import io.prestosql.operator.scalar.timestamp.VarcharToTimestampCast;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.DecimalParseResult;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.Decimals;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.SqlDecimal;
import io.prestosql.spi.type.SqlTimestamp;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.testing.assertions.PrestoExceptionAssert;
import java.io.Closeable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public abstract class AbstractTestFunctions {
    protected final Session session;
    private final FeaturesConfig config;
    protected FunctionAssertions functionAssertions;

    protected AbstractTestFunctions() {
        this(SessionTestUtils.TEST_SESSION);
    }

    protected AbstractTestFunctions(Session session) {
        this(session, new FeaturesConfig());
    }

    protected AbstractTestFunctions(FeaturesConfig config) {
        this(SessionTestUtils.TEST_SESSION, config);
    }

    protected AbstractTestFunctions(Session session, FeaturesConfig config) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.config = Objects.requireNonNull(config, "config is null");
    }

    @BeforeClass
    public final void initTestFunctions() {
        this.functionAssertions = new FunctionAssertions(this.session, this.config);
    }

    @AfterClass(alwaysRun=true)
    public final void destroyTestFunctions() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.functionAssertions});
        this.functionAssertions = null;
    }

    protected void assertFunction(String projection, Type expectedType, Object expected) {
        this.functionAssertions.assertFunction(projection, expectedType, expected);
    }

    protected void assertOperator(OperatorType operator, String value, Type expectedType, Object expected) {
        this.functionAssertions.assertFunction(String.format("\"%s\"(%s)", Signature.mangleOperatorName((OperatorType)operator), value), expectedType, expected);
    }

    protected void assertDecimalFunction(String statement, SqlDecimal expectedResult) {
        this.assertFunction(statement, (Type)DecimalType.createDecimalType((int)expectedResult.getPrecision(), (int)expectedResult.getScale()), expectedResult);
    }

    @Deprecated
    protected void assertInvalidFunction(String projection) {
        this.functionAssertions.assertInvalidFunction(projection);
    }

    protected void assertInvalidFunction(String projection, ErrorCodeSupplier errorCode, String message) {
        this.functionAssertions.assertInvalidFunction(projection, errorCode, message);
    }

    protected void assertInvalidFunction(String projection, String message) {
        this.functionAssertions.assertInvalidFunction(projection, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, message);
    }

    protected void assertInvalidFunction(String projection, ErrorCodeSupplier expectedErrorCode) {
        this.functionAssertions.assertInvalidFunction(projection, expectedErrorCode);
    }

    protected void assertNumericOverflow(String projection, String message) {
        this.functionAssertions.assertNumericOverflow(projection, message);
    }

    protected void assertInvalidCast(String projection) {
        this.functionAssertions.assertInvalidCast(projection);
    }

    protected void assertInvalidCast(String projection, String message) {
        this.functionAssertions.assertInvalidCast(projection, message);
    }

    protected void assertCachedInstanceHasBoundedRetainedSize(String projection) {
        this.functionAssertions.assertCachedInstanceHasBoundedRetainedSize(projection);
    }

    protected void assertNotSupported(String projection, String message) {
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> this.functionAssertions.executeProjectionWithFullEngine(projection)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED).hasMessage(message);
    }

    protected void tryEvaluateWithAll(String projection, Type expectedType) {
        this.functionAssertions.tryEvaluateWithAll(projection, expectedType);
    }

    protected void registerScalarFunction(SqlScalarFunction sqlScalarFunction) {
        this.functionAssertions.getMetadata().addFunctions((List)ImmutableList.of((Object)sqlScalarFunction));
    }

    protected void registerScalar(Class<?> clazz) {
        this.functionAssertions.getMetadata().addFunctions(new FunctionListBuilder().scalars(clazz).getFunctions());
    }

    protected void registerParametricScalar(Class<?> clazz) {
        this.functionAssertions.getMetadata().addFunctions(new FunctionListBuilder().scalar(clazz).getFunctions());
    }

    protected void installPlugin(Plugin plugin) {
        this.functionAssertions.installPlugin(plugin);
    }

    protected static SqlDecimal decimal(String decimalString) {
        DecimalParseResult parseResult = Decimals.parseIncludeLeadingZerosInPrecision((String)decimalString);
        BigInteger unscaledValue = parseResult.getType().isShort() ? BigInteger.valueOf((Long)parseResult.getObject()) : Decimals.decodeUnscaledValue((Slice)((Slice)parseResult.getObject()));
        return new SqlDecimal(unscaledValue, parseResult.getType().getPrecision(), parseResult.getType().getScale());
    }

    protected static SqlTimestamp timestamp(int precision, String timestampValue) {
        LongTimestamp longTimestamp = VarcharToTimestampCast.castToLongTimestamp((int)precision, (String)timestampValue);
        return SqlTimestamp.newInstance((int)precision, (long)longTimestamp.getEpochMicros(), (int)longTimestamp.getPicosOfMicro());
    }

    protected static SqlDecimal maxPrecisionDecimal(long value) {
        String maxPrecisionFormat = "%0" + (38 + (value < 0L ? 1 : 0)) + "d";
        return AbstractTestFunctions.decimal(String.format(maxPrecisionFormat, value));
    }

    protected static <K, V> Map<K, V> asMap(List<K> keyList, List<V> valueList) {
        if (keyList.size() != valueList.size()) {
            Assert.fail((String)"keyList should have same size with valueList");
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (int i = 0; i < keyList.size(); ++i) {
            if (map.put(keyList.get(i), valueList.get(i)) == null) continue;
            Assert.fail((String)"keyList should have same size with valueList");
        }
        return map;
    }
}

