/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.block.BlockAssertions;
import io.prestosql.memory.context.AggregatedMemoryContext;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.project.PageProcessor;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.DictionaryBlock;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.MapType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.gen.ExpressionCompiler;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.testing.TestingConnectorSession;
import io.prestosql.util.StructuralTestUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkMapSubscript {
    private static final int POSITIONS = 1024;

    @Benchmark
    @OperationsPerInvocation(value=1024)
    public List<Optional<Page>> mapSubscript(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkMapSubscript().mapSubscript(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).warmupMode(WarmupMode.INDI).include(".*" + BenchmarkMapSubscript.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"fix-width", "var-width", "dictionary"})
        private String name = "dictionary";
        @Param(value={"1", "13"})
        private int mapSize = 13;
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            Block valueBlock;
            MapType mapType;
            ImmutableList keys;
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
            switch (this.mapSize) {
                case 1: {
                    keys = ImmutableList.of((Object)"do_not_use");
                    break;
                }
                case 13: {
                    keys = ImmutableList.of((Object)"is_inverted", (Object)"device_model", (Object)"country", (Object)"carrier_id", (Object)"network_type", (Object)"os_version", (Object)"device_brand", (Object)"device_type", (Object)"interface", (Object)"device_os", (Object)"app_version", (Object)"device_type_class", (Object[])new String[]{"browser"});
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            Verify.verify((keys.size() == this.mapSize ? 1 : 0) != 0);
            switch (this.name) {
                case "fix-width": {
                    mapType = StructuralTestUtil.mapType((Type)VarcharType.createUnboundedVarcharType(), (Type)DoubleType.DOUBLE);
                    valueBlock = BenchmarkData.createFixWidthValueBlock(1024, this.mapSize);
                    break;
                }
                case "var-width": {
                    mapType = StructuralTestUtil.mapType((Type)VarcharType.createUnboundedVarcharType(), (Type)VarcharType.createUnboundedVarcharType());
                    valueBlock = BenchmarkData.createVarWidthValueBlock(1024, this.mapSize);
                    break;
                }
                case "dictionary": {
                    mapType = StructuralTestUtil.mapType((Type)VarcharType.createUnboundedVarcharType(), (Type)VarcharType.createUnboundedVarcharType());
                    valueBlock = BenchmarkData.createDictionaryValueBlock(1024, this.mapSize);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            Block keyBlock = BenchmarkData.createKeyBlock(1024, (List<String>)keys);
            Block block = BenchmarkData.createMapBlock(mapType, 1024, keyBlock, valueBlock);
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            ResolvedFunction resolvedFunction = metadata.resolveOperator(OperatorType.SUBSCRIPT, (List)ImmutableList.of((Object)mapType, (Object)mapType.getKeyType()));
            for (int i = 0; i < this.mapSize; ++i) {
                projectionsBuilder.add((Object)new CallExpression(resolvedFunction, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)mapType), (Object)Expressions.constant((Object)Slices.utf8Slice((String)((String)keys.get(i))), (Type)VarcharType.createUnboundedVarcharType()))));
            }
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(new Block[]{block});
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }

        private static Block createMapBlock(MapType mapType, int positionCount, Block keyBlock, Block valueBlock) {
            int[] offsets = new int[positionCount + 1];
            int mapSize = keyBlock.getPositionCount() / positionCount;
            for (int i = 0; i < offsets.length; ++i) {
                offsets[i] = mapSize * i;
            }
            return mapType.createBlockFromKeyValue(Optional.empty(), offsets, keyBlock, valueBlock);
        }

        private static Block createKeyBlock(int positionCount, List<String> keys) {
            Block keyDictionaryBlock = BenchmarkData.createSliceArrayBlock(keys);
            int[] keyIds = new int[positionCount * keys.size()];
            for (int i = 0; i < keyIds.length; ++i) {
                keyIds[i] = i % keys.size();
            }
            return new DictionaryBlock(keyDictionaryBlock, keyIds);
        }

        private static Block createFixWidthValueBlock(int positionCount, int mapSize) {
            BlockBuilder valueBlockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, positionCount * mapSize);
            for (int i = 0; i < positionCount * mapSize; ++i) {
                DoubleType.DOUBLE.writeDouble(valueBlockBuilder, ThreadLocalRandom.current().nextDouble());
            }
            return valueBlockBuilder.build();
        }

        private static Block createVarWidthValueBlock(int positionCount, int mapSize) {
            VarcharType valueType = VarcharType.createUnboundedVarcharType();
            BlockBuilder valueBlockBuilder = valueType.createBlockBuilder(null, positionCount * mapSize);
            for (int i = 0; i < positionCount * mapSize; ++i) {
                int wordLength = ThreadLocalRandom.current().nextInt(5, 10);
                valueType.writeSlice(valueBlockBuilder, Slices.utf8Slice((String)BenchmarkData.randomString(wordLength)));
            }
            return valueBlockBuilder.build();
        }

        private static Block createDictionaryValueBlock(int positionCount, int mapSize) {
            double distinctRatio = 0.82;
            int dictionarySize = (int)((double)(positionCount * mapSize) * distinctRatio);
            ArrayList<String> dictionaryStrings = new ArrayList<String>(dictionarySize);
            for (int i = 0; i < dictionarySize; ++i) {
                int wordLength = ThreadLocalRandom.current().nextInt(5, 10);
                dictionaryStrings.add(BenchmarkData.randomString(wordLength));
            }
            Block dictionaryBlock = BenchmarkData.createSliceArrayBlock(dictionaryStrings);
            int[] keyIds = new int[positionCount * mapSize];
            for (int i = 0; i < keyIds.length; ++i) {
                keyIds[i] = ThreadLocalRandom.current().nextInt(0, dictionarySize);
            }
            return new DictionaryBlock(dictionaryBlock, keyIds);
        }

        private static String randomString(int length) {
            String symbols = "abcdefghijklmnopqrstuvwxyz";
            char[] chars = new char[length];
            for (int i = 0; i < length; ++i) {
                chars[i] = symbols.charAt(ThreadLocalRandom.current().nextInt(symbols.length()));
            }
            return new String(chars);
        }

        private static Block createSliceArrayBlock(List<String> keys) {
            Slice[] sliceArray = new Slice[keys.size() + 1];
            for (int i = 0; i < keys.size(); ++i) {
                sliceArray[i] = Slices.utf8Slice((String)keys.get(i));
            }
            return BlockAssertions.createSlicesBlock(sliceArray);
        }
    }
}

