/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.scalar.TypeOperatorBenchmarkUtil;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=30, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=15, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkRowEqualOperator {
    private static final int POSITIONS = 10000;

    @Benchmark
    @OperationsPerInvocation(value=10000)
    public long equalOperator(BenchmarkData data) throws Throwable {
        return data.getEqualBlock().invokeExact(data.getLeftBlock(), data.getRightBlock());
    }

    @Test
    public void test() throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        this.equalOperator(data);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkRowEqualOperator.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"BIGINT", "VARCHAR"})
        private String type = "BIGINT";
        @Param(value={"1", "8", "16", "32", "64", "128"})
        private int fieldCount = 32;
        private MethodHandle equalBlock;
        private Block leftBlock;
        private Block rightBlock;

        @Setup
        public void setup() {
            RowType rowType = RowType.anonymous((List)ImmutableList.copyOf(Collections.nCopies(this.fieldCount, TypeOperatorBenchmarkUtil.toType(this.type))));
            Block[] channels = BenchmarkData.createChannels(10000, rowType);
            this.leftBlock = channels[0];
            this.rightBlock = channels[1];
            this.equalBlock = TypeOperatorBenchmarkUtil.getEqualBlockMethod((Type)rowType);
        }

        private static Block[] createChannels(int positionCount, RowType rowType) {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            BlockBuilder leftBlockBuilder = rowType.createBlockBuilder(null, positionCount);
            BlockBuilder rightBlockBuilder = rowType.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                BlockBuilder leftEntryBuilder = leftBlockBuilder.beginBlockEntry();
                BlockBuilder rightEntryBuilder = rightBlockBuilder.beginBlockEntry();
                List fields = rowType.getFields();
                for (int i = 0; i < fields.size() - 1; ++i) {
                    TypeOperatorBenchmarkUtil.addElement(((RowType.Field)fields.get(i)).getType(), random, leftEntryBuilder, rightEntryBuilder, true);
                }
                TypeOperatorBenchmarkUtil.addElement(((RowType.Field)fields.get(fields.size() - 1)).getType(), random, leftEntryBuilder, rightEntryBuilder, random.nextBoolean());
                leftBlockBuilder.closeEntry();
                rightBlockBuilder.closeEntry();
            }
            return new Block[]{leftBlockBuilder.build(), rightBlockBuilder.build()};
        }

        public MethodHandle getEqualBlock() {
            return this.equalBlock;
        }

        public Block getLeftBlock() {
            return this.leftBlock;
        }

        public Block getRightBlock() {
            return this.rightBlock;
        }
    }
}

