/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.Type;
import org.testng.annotations.Test;

public class TestArrayMatchFunctions
extends AbstractTestFunctions {
    @Test
    public void testAllMatch() {
        this.assertFunction("all_match(ARRAY [5, 7, 9], x -> x % 2 = 1)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("all_match(ARRAY [true, false, true], x -> x)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("all_match(ARRAY ['abc', 'ade', 'afg'], x -> substr(x, 1, 1) = 'a')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("all_match(ARRAY [], x -> true)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("all_match(ARRAY [true, true, NULL], x -> x)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("all_match(ARRAY [true, false, NULL], x -> x)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("all_match(ARRAY [NULL, NULL, NULL], x -> x > 1)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("all_match(ARRAY [NULL, NULL, NULL], x -> x IS NULL)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("all_match(ARRAY [MAP(ARRAY[1,2], ARRAY[3,4]), MAP(ARRAY[1,2,3], ARRAY[3,4,5])], x -> cardinality(x) > 1)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("all_match(ARRAY [TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789'], t -> month(t) = 5)", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testAnyMatch() {
        this.assertFunction("any_match(ARRAY [5, 8, 10], x -> x % 2 = 1)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("any_match(ARRAY [false, false, false], x -> x)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("any_match(ARRAY ['abc', 'def', 'ghi'], x -> substr(x, 1, 1) = 'a')", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("any_match(ARRAY [], x -> true)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("any_match(ARRAY [false, false, NULL], x -> x)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("any_match(ARRAY [true, false, NULL], x -> x)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("any_match(ARRAY [NULL, NULL, NULL], x -> x > 1)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("any_match(ARRAY [true, false, NULL], x -> x IS NULL)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("any_match(ARRAY [MAP(ARRAY[1,2], ARRAY[3,4]), MAP(ARRAY[1,2,3], ARRAY[3,4,5])], x -> cardinality(x) > 4)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("any_match(ARRAY [TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789'], t -> year(t) = 2020)", (Type)BooleanType.BOOLEAN, true);
    }

    @Test
    public void testNoneMatch() {
        this.assertFunction("none_match(ARRAY [5, 8, 10], x -> x % 2 = 1)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("none_match(ARRAY [false, false, false], x -> x)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("none_match(ARRAY ['abc', 'def', 'ghi'], x -> substr(x, 1, 1) = 'a')", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("none_match(ARRAY [], x -> true)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("none_match(ARRAY [false, false, NULL], x -> x)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("none_match(ARRAY [true, false, NULL], x -> x)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("none_match(ARRAY [NULL, NULL, NULL], x -> x > 1)", (Type)BooleanType.BOOLEAN, null);
        this.assertFunction("none_match(ARRAY [true, false, NULL], x -> x IS NULL)", (Type)BooleanType.BOOLEAN, false);
        this.assertFunction("none_match(ARRAY [MAP(ARRAY[1,2], ARRAY[3,4]), MAP(ARRAY[1,2,3], ARRAY[3,4,5])], x -> cardinality(x) > 4)", (Type)BooleanType.BOOLEAN, true);
        this.assertFunction("none_match(ARRAY [TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '1111-05-10 12:34:56.123456789'], t -> month(t) = 10)", (Type)BooleanType.BOOLEAN, true);
    }
}

