/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.type.ArrayType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.type.UnknownType;
import java.util.Arrays;
import org.testng.annotations.Test;

public class TestArrayNgramsFunction
extends AbstractTestFunctions {
    @Test
    public void testBasic() {
        this.assertFunction("ngrams(ARRAY['bar', 'foo', 'baz', 'foo'], 1)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of((Object)"bar"), (Object)ImmutableList.of((Object)"foo"), (Object)ImmutableList.of((Object)"baz"), (Object)ImmutableList.of((Object)"foo")));
        this.assertFunction("ngrams(ARRAY['bar', 'foo', 'baz', 'foo'], 2)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of((Object)"bar", (Object)"foo"), (Object)ImmutableList.of((Object)"foo", (Object)"baz"), (Object)ImmutableList.of((Object)"baz", (Object)"foo")));
        this.assertFunction("ngrams(ARRAY['bar', 'foo', 'baz', 'foo'], 3)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of((Object)"bar", (Object)"foo", (Object)"baz"), (Object)ImmutableList.of((Object)"foo", (Object)"baz", (Object)"foo")));
        this.assertFunction("ngrams(ARRAY['bar', 'foo', 'baz', 'foo'], 4)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of((Object)"bar", (Object)"foo", (Object)"baz", (Object)"foo")));
        this.assertFunction("ngrams(ARRAY['bar', 'foo', 'baz', 'foo'], 5)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of((Object)"bar", (Object)"foo", (Object)"baz", (Object)"foo")));
        this.assertFunction("ngrams(ARRAY['bar', 'foo', 'baz', 'foo'], 6)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of((Object)"bar", (Object)"foo", (Object)"baz", (Object)"foo")));
        this.assertFunction("ngrams(ARRAY['bar', 'foo', 'baz', 'foo'], 100000000)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of((Object)"bar", (Object)"foo", (Object)"baz", (Object)"foo")));
        this.assertFunction("ngrams(ARRAY['a', 'bb', 'ccc', 'dddd'], 2)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)4))), ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"bb"), (Object)ImmutableList.of((Object)"bb", (Object)"ccc"), (Object)ImmutableList.of((Object)"ccc", (Object)"dddd")));
    }

    @Test
    public void testNull() {
        this.assertFunction("ngrams(ARRAY['foo', NULL, 'bar'], 2)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of(Arrays.asList("foo", null), Arrays.asList(null, "bar")));
        this.assertFunction("ngrams(ARRAY [NULL, NULL, NULL], 2)", (Type)new ArrayType((Type)new ArrayType((Type)UnknownType.UNKNOWN)), ImmutableList.of(Arrays.asList(null, null), Arrays.asList(null, null)));
        this.assertFunction("ngrams(ARRAY [NULL, 3, NULL], 2)", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of(Arrays.asList(null, 3), Arrays.asList(3, null)));
    }

    @Test
    public void testTypeCombinations() {
        this.assertFunction("ngrams(ARRAY[1, 2, 3], 2)", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)2, (Object)3)));
        this.assertFunction("ngrams(ARRAY[1.1E0, 2.1E0, 3.1E0], 2)", (Type)new ArrayType((Type)new ArrayType((Type)DoubleType.DOUBLE)), ImmutableList.of((Object)ImmutableList.of((Object)1.1, (Object)2.1), (Object)ImmutableList.of((Object)2.1, (Object)3.1)));
        this.assertFunction("ngrams(ARRAY[true, false, true], 2)", (Type)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN)), ImmutableList.of((Object)ImmutableList.of((Object)true, (Object)false), (Object)ImmutableList.of((Object)false, (Object)true)));
        this.assertFunction("ngrams(ARRAY[ARRAY['A1', 'A2'], ARRAY['B1'], ARRAY['C1', 'C2']], 2)", (Type)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)2)))), ImmutableList.of((Object)ImmutableList.of((Object)ImmutableList.of((Object)"A1", (Object)"A2"), (Object)ImmutableList.of((Object)"B1")), (Object)ImmutableList.of((Object)ImmutableList.of((Object)"B1"), (Object)ImmutableList.of((Object)"C1", (Object)"C2"))));
        this.assertFunction("ngrams(ARRAY['\u4fe1\u5ff5\u7231', '\u5e0c\u671b', '\u671b'], 2)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of((Object)"\u4fe1\u5ff5\u7231", (Object)"\u5e0c\u671b"), (Object)ImmutableList.of((Object)"\u5e0c\u671b", (Object)"\u671b")));
        this.assertFunction("ngrams(ARRAY[], 2)", (Type)new ArrayType((Type)new ArrayType((Type)UnknownType.UNKNOWN)), ImmutableList.of(Arrays.asList(new Object[0])));
        this.assertFunction("ngrams(ARRAY[''], 2)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)0))), ImmutableList.of((Object)ImmutableList.of((Object)"")));
        this.assertFunction("ngrams(ARRAY['', ''], 2)", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)0))), ImmutableList.of((Object)ImmutableList.of((Object)"", (Object)"")));
        this.assertInvalidFunction("ngrams(ARRAY['foo','bar'], 0)", "N must be positive");
        this.assertInvalidFunction("ngrams(ARRAY['foo','bar'], 0)", "N must be positive");
    }
}

