/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.date;

import io.prestosql.operator.scalar.AbstractTestExtract;
import io.prestosql.sql.query.QueryAssertions;
import java.util.List;
import org.assertj.core.api.Assertions;

public class TestExtract
extends AbstractTestExtract {
    @Override
    protected List<String> types() {
        return List.of("date");
    }

    @Override
    public void testYear() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(YEAR FROM DATE '2020-05-10')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(YEAR FROM DATE '1960-05-10')")))).matches("BIGINT '1960'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year(DATE '2020-05-10')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year(DATE '1960-05-10')")))).matches("BIGINT '1960'");
    }

    @Override
    public void testMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(MONTH FROM DATE '2020-05-10')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(MONTH FROM DATE '1960-05-10')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("month(DATE '2020-05-10')")))).matches("BIGINT '5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("month(DATE '1960-05-10')")))).matches("BIGINT '5'");
    }

    @Override
    public void testWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(WEEK FROM DATE '2020-05-10')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(WEEK FROM DATE '1960-05-10')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("week(DATE '2020-05-10')")))).matches("BIGINT '19'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("week(DATE '1960-05-10')")))).matches("BIGINT '19'");
    }

    @Override
    public void testDay() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(DAY FROM DATE '2020-05-10')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(DAY FROM DATE '1960-05-10')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day(DATE '2020-05-10')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day(DATE '1960-05-10')")))).matches("BIGINT '10'");
    }

    @Override
    public void testDayOfMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM DATE '2020-05-10')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(DAY_OF_MONTH FROM DATE '1960-05-10')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_month(DATE '2020-05-10')")))).matches("BIGINT '10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_month(DATE '1960-05-10')")))).matches("BIGINT '10'");
    }

    @Override
    public void testDayOfWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM DATE '2020-05-10')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(DAY_OF_WEEK FROM DATE '1960-05-10')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_week(DATE '2020-05-10')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_week(DATE '1960-05-10')")))).matches("BIGINT '2'");
    }

    @Override
    public void testDow() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(DOW FROM DATE '2020-05-10')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(DOW FROM DATE '1960-05-10')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("dow(DATE '2020-05-10')")))).matches("BIGINT '7'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("dow(DATE '1960-05-10')")))).matches("BIGINT '2'");
    }

    @Override
    public void testDayOfYear() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM DATE '2020-05-10')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(DAY_OF_YEAR FROM DATE '1960-05-10')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_year(DATE '2020-05-10')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("day_of_year(DATE '1960-05-10')")))).matches("BIGINT '131'");
    }

    @Override
    public void testDoy() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(DOY FROM DATE '2020-05-10')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(DOY FROM DATE '1960-05-10')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("doy(DATE '2020-05-10')")))).matches("BIGINT '131'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("doy(DATE '1960-05-10')")))).matches("BIGINT '131'");
    }

    @Override
    public void testQuarter() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(QUARTER FROM DATE '2020-05-10')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(QUARTER FROM DATE '1960-05-10')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("quarter(DATE '2020-05-10')")))).matches("BIGINT '2'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("quarter(DATE '1960-05-10')")))).matches("BIGINT '2'");
    }

    @Override
    public void testYearOfWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM DATE '2020-05-10')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(YEAR_OF_WEEK FROM DATE '1960-05-10')")))).matches("BIGINT '1960'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year_of_week(DATE '2020-05-10')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("year_of_week(DATE '1960-05-10')")))).matches("BIGINT '1960'");
    }

    @Override
    public void testYow() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(YOW FROM DATE '2020-05-10')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(YOW FROM DATE '1960-05-10')")))).matches("BIGINT '1960'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("yow(DATE '2020-05-10')")))).matches("BIGINT '2020'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("yow(DATE '1960-05-10')")))).matches("BIGINT '1960'");
    }
}

