/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.time;

import com.google.common.collect.ImmutableList;
import io.prestosql.operator.scalar.AbstractTestExtract;
import io.prestosql.sql.parser.ParsingException;
import io.prestosql.sql.query.QueryAssertions;
import java.util.List;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestExtract
extends AbstractTestExtract {
    @Override
    protected List<String> types() {
        return (List)IntStream.rangeClosed(0, 12).mapToObj(precision -> String.format("time(%s)", precision)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void testHour() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.1')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.12')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.123')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.1234')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.12345')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.123456')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.1234567')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.12345678')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.123456789')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.1234567890')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.12345678901')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(HOUR FROM TIME '12:34:56.123456789012')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIME '12:34:56')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIME '12:34:56.1')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIME '12:34:56.12')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIME '12:34:56.123')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIME '12:34:56.1234')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIME '12:34:56.12345')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIME '12:34:56.123456')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIME '12:34:56.1234567')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIME '12:34:56.12345678')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIME '12:34:56.123456789')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIME '12:34:56.1234567890')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIME '12:34:56.12345678901')")))).matches("BIGINT '12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("hour(TIME '12:34:56.123456789012')")))).matches("BIGINT '12'");
    }

    @Override
    public void testMinute() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.1')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.12')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.123')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.1234')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.12345')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.123456')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.1234567')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.12345678')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.123456789')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.1234567890')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.12345678901')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(MINUTE FROM TIME '12:34:56.123456789012')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIME '12:34:56')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIME '12:34:56.1')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIME '12:34:56.12')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIME '12:34:56.123')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIME '12:34:56.1234')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIME '12:34:56.12345')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIME '12:34:56.123456')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIME '12:34:56.1234567')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIME '12:34:56.12345678')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIME '12:34:56.123456789')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIME '12:34:56.1234567890')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIME '12:34:56.12345678901')")))).matches("BIGINT '34'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("minute(TIME '12:34:56.123456789012')")))).matches("BIGINT '34'");
    }

    @Override
    public void testSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.1')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.12')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.123')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.1234')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.12345')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.123456')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.1234567')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.12345678')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.123456789')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.1234567890')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.12345678901')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("EXTRACT(SECOND FROM TIME '12:34:56.123456789012')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIME '12:34:56')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIME '12:34:56.1')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIME '12:34:56.12')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIME '12:34:56.123')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIME '12:34:56.1234')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIME '12:34:56.12345')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIME '12:34:56.123456')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIME '12:34:56.1234567')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIME '12:34:56.12345678')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIME '12:34:56.123456789')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIME '12:34:56.1234567890')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIME '12:34:56.12345678901')")))).matches("BIGINT '56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("second(TIME '12:34:56.123456789012')")))).matches("BIGINT '56'");
    }

    @Test
    public void testMillisecond() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertions.expression("EXTRACT(MILLISECOND FROM TIME '12:34:56')")).isInstanceOf(ParsingException.class)).hasMessage("line 1:8: Invalid EXTRACT field: MILLISECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIME '12:34:56')")))).matches("BIGINT '0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIME '12:34:56.1')")))).matches("BIGINT '100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIME '12:34:56.12')")))).matches("BIGINT '120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIME '12:34:56.123')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIME '12:34:56.1234')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIME '12:34:56.12345')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIME '12:34:56.123456')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIME '12:34:56.1234567')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIME '12:34:56.12345678')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIME '12:34:56.123456789')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIME '12:34:56.1234567890')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIME '12:34:56.12345678901')")))).matches("BIGINT '123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("millisecond(TIME '12:34:56.123456789012')")))).matches("BIGINT '123'");
    }
}

