/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.time;

import io.prestosql.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestOperators {
    protected QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' = TIME '12:34:56'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' = TIME '12:34:56.1'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' = TIME '12:34:56.12'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' = TIME '12:34:56.123'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' = TIME '12:34:56.1234'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' = TIME '12:34:56.12345'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' = TIME '12:34:56.123456'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' = TIME '12:34:56.1234567'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' = TIME '12:34:56.12345678'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' = TIME '12:34:56.123456789'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' = TIME '12:34:56.1234567890'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' = TIME '12:34:56.12345678901'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' = TIME '12:34:56.123456789012'")))).isEqualTo(true);
    }

    @Test
    public void testNotEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' <> TIME '12:34:56'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' <> TIME '12:34:56.1'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' <> TIME '12:34:56.12'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' <> TIME '12:34:56.123'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' <> TIME '12:34:56.1234'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' <> TIME '12:34:56.12345'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' <> TIME '12:34:56.123456'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' <> TIME '12:34:56.1234567'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' <> TIME '12:34:56.12345678'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' <> TIME '12:34:56.123456789'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' <> TIME '12:34:56.1234567890'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' <> TIME '12:34:56.12345678901'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' <> TIME '12:34:56.123456789012'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' <> TIME '22:34:56'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' <> TIME '22:34:56.1'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' <> TIME '22:34:56.12'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' <> TIME '22:34:56.123'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' <> TIME '22:34:56.1234'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' <> TIME '22:34:56.12345'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' <> TIME '22:34:56.123456'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' <> TIME '22:34:56.1234567'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' <> TIME '22:34:56.12345678'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' <> TIME '22:34:56.123456789'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' <> TIME '22:34:56.1234567890'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' <> TIME '22:34:56.12345678901'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' <> TIME '22:34:56.123456789012'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' <> TIME '12:34:57'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' <> TIME '12:34:56.2'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' <> TIME '12:34:56.13'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' <> TIME '12:34:56.124'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' <> TIME '12:34:56.1235'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' <> TIME '12:34:56.12346'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' <> TIME '12:34:56.123457'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' <> TIME '12:34:56.1234568'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' <> TIME '12:34:56.12345679'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' <> TIME '12:34:56.123456781'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' <> TIME '12:34:56.1234567891'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' <> TIME '12:34:56.12345678902'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' <> TIME '12:34:56.123456789013'")))).isEqualTo(true);
    }

    @Test
    public void testDistinctFrom() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' IS DISTINCT FROM TIME '12:34:56'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' IS DISTINCT FROM TIME '12:34:56.1'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' IS DISTINCT FROM TIME '12:34:56.12'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' IS DISTINCT FROM TIME '12:34:56.123'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' IS DISTINCT FROM TIME '12:34:56.1234'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' IS DISTINCT FROM TIME '12:34:56.12345'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' IS DISTINCT FROM TIME '12:34:56.123456'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' IS DISTINCT FROM TIME '12:34:56.1234567'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' IS DISTINCT FROM TIME '12:34:56.12345678'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' IS DISTINCT FROM TIME '12:34:56.123456789'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' IS DISTINCT FROM TIME '12:34:56.1234567890'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' IS DISTINCT FROM TIME '12:34:56.12345678901'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' IS DISTINCT FROM TIME '12:34:56.123456789012'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' IS DISTINCT FROM TIME '12:34:55'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' IS DISTINCT FROM TIME '12:34:56.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' IS DISTINCT FROM TIME '12:34:56.11'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' IS DISTINCT FROM TIME '12:34:56.122'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' IS DISTINCT FROM TIME '12:34:56.1233'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' IS DISTINCT FROM TIME '12:34:56.12344'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' IS DISTINCT FROM TIME '12:34:56.123455'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' IS DISTINCT FROM TIME '12:34:56.1234566'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' IS DISTINCT FROM TIME '12:34:56.12345677'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' IS DISTINCT FROM TIME '12:34:56.123456788'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' IS DISTINCT FROM TIME '12:34:56.1234567899'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' IS DISTINCT FROM TIME '12:34:56.12345678900'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' IS DISTINCT FROM TIME '12:34:56.123456789011'")))).isEqualTo(true);
    }

    @Test
    public void testLessThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' < TIME '12:34:57'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' < TIME '12:34:56.2'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' < TIME '12:34:56.13'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' < TIME '12:34:56.124'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' < TIME '12:34:56.1235'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' < TIME '12:34:56.12346'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' < TIME '12:34:56.123457'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' < TIME '12:34:56.1234568'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' < TIME '12:34:56.12345679'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' < TIME '12:34:56.123456790'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' < TIME '12:34:56.1234567891'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' < TIME '12:34:56.12345678902'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' < TIME '12:34:56.123456789013'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' < TIME '12:34:56'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' < TIME '12:34:56.1'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' < TIME '12:34:56.12'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' < TIME '12:34:56.123'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' < TIME '12:34:56.1234'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' < TIME '12:34:56.12345'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' < TIME '12:34:56.123456'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' < TIME '12:34:56.1234567'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' < TIME '12:34:56.12345678'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' < TIME '12:34:56.123456789'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' < TIME '12:34:56.1234567890'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' < TIME '12:34:56.12345678901'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' < TIME '12:34:56.123456789012'")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' > TIME '12:34:55'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' > TIME '12:34:55.9'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' > TIME '12:34:56.11'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' > TIME '12:34:56.122'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' > TIME '12:34:56.1233'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' > TIME '12:34:56.12344'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' > TIME '12:34:56.123455'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' > TIME '12:34:56.1234566'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' > TIME '12:34:56.12345677'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' > TIME '12:34:56.123456788'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' > TIME '12:34:56.1234567889'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' > TIME '12:34:56.12345678899'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' > TIME '12:34:56.123456789011'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' > TIME '12:34:56'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' > TIME '12:34:56.1'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' > TIME '12:34:56.12'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' > TIME '12:34:56.123'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' > TIME '12:34:56.1234'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' > TIME '12:34:56.12345'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' > TIME '12:34:56.123456'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' > TIME '12:34:56.1234567'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' > TIME '12:34:56.12345678'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' > TIME '12:34:56.123456789'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' > TIME '12:34:56.1234567890'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' > TIME '12:34:56.12345678901'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' > TIME '12:34:56.123456789012'")))).isEqualTo(false);
    }

    @Test
    public void testLessThanOrEquals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' <= TIME '12:34:56'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' <= TIME '12:34:56.1'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' <= TIME '12:34:56.12'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' <= TIME '12:34:56.123'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' <= TIME '12:34:56.1234'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' <= TIME '12:34:56.12345'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' <= TIME '12:34:56.123456'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' <= TIME '12:34:56.1234567'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' <= TIME '12:34:56.12345678'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' <= TIME '12:34:56.123456789'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' <= TIME '12:34:56.1234567890'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' <= TIME '12:34:56.12345678901'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' <= TIME '12:34:56.123456789012'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' <= TIME '12:34:57'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' <= TIME '12:34:56.2'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' <= TIME '12:34:56.13'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' <= TIME '12:34:56.124'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' <= TIME '12:34:56.1235'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' <= TIME '12:34:56.12346'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' <= TIME '12:34:56.123457'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' <= TIME '12:34:56.1234568'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' <= TIME '12:34:56.12345679'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' <= TIME '12:34:56.123456790'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' <= TIME '12:34:56.1234567891'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' <= TIME '12:34:56.12345678902'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' <= TIME '12:34:56.123456789013'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' <= TIME '12:34:55'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' <= TIME '12:34:56.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' <= TIME '12:34:56.11'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' <= TIME '12:34:56.122'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' <= TIME '12:34:56.1233'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' <= TIME '12:34:56.12344'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' <= TIME '12:34:56.123454'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' <= TIME '12:34:56.1234566'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' <= TIME '12:34:56.12345677'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' <= TIME '12:34:56.123456788'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' <= TIME '12:34:56.1234567889'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' <= TIME '12:34:56.12345678900'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' <= TIME '12:34:56.123456789011'")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThanOrEquals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' >= TIME '12:34:56'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' >= TIME '12:34:56.1'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' >= TIME '12:34:56.12'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' >= TIME '12:34:56.123'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' >= TIME '12:34:56.1234'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' >= TIME '12:34:56.12345'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' >= TIME '12:34:56.123456'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' >= TIME '12:34:56.1234567'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' >= TIME '12:34:56.12345678'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' >= TIME '12:34:56.123456789'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' >= TIME '12:34:56.1234567890'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' >= TIME '12:34:56.12345678901'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' >= TIME '12:34:56.123456789012'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' >= TIME '12:34:55'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' >= TIME '12:34:55.9'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' >= TIME '12:34:56.11'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' >= TIME '12:34:56.122'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' >= TIME '12:34:56.1233'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' >= TIME '12:34:56.12344'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' >= TIME '12:34:56.123455'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' >= TIME '12:34:56.1234566'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' >= TIME '12:34:56.12345677'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' >= TIME '12:34:56.123456788'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' >= TIME '12:34:56.1234567889'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' >= TIME '12:34:56.12345678899'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' >= TIME '12:34:56.123456789011'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' >= TIME '12:34:57'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' >= TIME '12:34:56.2'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' >= TIME '12:34:56.13'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' >= TIME '12:34:56.124'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' >= TIME '12:34:56.1235'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' >= TIME '12:34:56.12346'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' >= TIME '12:34:56.123457'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' >= TIME '12:34:56.1234568'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' >= TIME '12:34:56.12345679'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' >= TIME '12:34:56.1234567891'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' >= TIME '12:34:56.1234567891'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' >= TIME '12:34:56.12345678902'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' >= TIME '12:34:56.123456789013'")))).isEqualTo(false);
    }

    @Test
    public void testBetween() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' BETWEEN TIME '12:34:55' and TIME '12:34:57'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' BETWEEN TIME '12:34:56.0' and TIME '12:34:56.2'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' BETWEEN TIME '12:34:56.11' and TIME '12:34:56.13'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' BETWEEN TIME '12:34:56.122' and TIME '12:34:56.124'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' BETWEEN TIME '12:34:56.1233' and TIME '12:34:56.1235'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' BETWEEN TIME '12:34:56.12344' and TIME '12:34:56.12346'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' BETWEEN TIME '12:34:56.123455' and TIME '12:34:56.123457'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' BETWEEN TIME '12:34:56.1234566' and TIME '12:34:56.1234568'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' BETWEEN TIME '12:34:56.12345677' and TIME '12:34:56.12345679'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' BETWEEN TIME '12:34:56.123456788' and TIME '12:34:56.123456790'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' BETWEEN TIME '12:34:56.1234567889' and TIME '12:34:56.1234567891'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' BETWEEN TIME '12:34:56.1234567890' and TIME '12:34:56.12345678902'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' BETWEEN TIME '12:34:56.123456789011' and TIME '12:34:56.123456789013'")))).isEqualTo(true);
    }

    @Test
    public void testAddIntervalDayToSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' + INTERVAL '1.123' SECOND")))).matches("TIME '12:34:57.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' + INTERVAL '1.123' SECOND")))).matches("TIME '12:34:57.223'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' + INTERVAL '1.123' SECOND")))).matches("TIME '12:34:57.243'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' + INTERVAL '1.123' SECOND")))).matches("TIME '12:34:57.246'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' + INTERVAL '1.123' SECOND")))).matches("TIME '12:34:57.2464'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' + INTERVAL '1.123' SECOND")))).matches("TIME '12:34:57.24645'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' + INTERVAL '1.123' SECOND")))).matches("TIME '12:34:57.246456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' + INTERVAL '1.123' SECOND")))).matches("TIME '12:34:57.2464567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' + INTERVAL '1.123' SECOND")))).matches("TIME '12:34:57.24645678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' + INTERVAL '1.123' SECOND")))).matches("TIME '12:34:57.246456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' + INTERVAL '1.123' SECOND")))).matches("TIME '12:34:57.2464567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' + INTERVAL '1.123' SECOND")))).matches("TIME '12:34:57.24645678901'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' + INTERVAL '1.123' SECOND")))).matches("TIME '12:34:57.246456789012'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIME '12:34:56'")))).matches("TIME '12:34:57.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIME '12:34:56.1'")))).matches("TIME '12:34:57.223'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIME '12:34:56.12'")))).matches("TIME '12:34:57.243'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIME '12:34:56.123'")))).matches("TIME '12:34:57.246'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIME '12:34:56.1234'")))).matches("TIME '12:34:57.2464'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIME '12:34:56.12345'")))).matches("TIME '12:34:57.24645'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIME '12:34:56.123456'")))).matches("TIME '12:34:57.246456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIME '12:34:56.1234567'")))).matches("TIME '12:34:57.2464567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIME '12:34:56.12345678'")))).matches("TIME '12:34:57.24645678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIME '12:34:56.123456789'")))).matches("TIME '12:34:57.246456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIME '12:34:56.1234567890'")))).matches("TIME '12:34:57.2464567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIME '12:34:56.12345678901'")))).matches("TIME '12:34:57.24645678901'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIME '12:34:56.123456789012'")))).matches("TIME '12:34:57.246456789012'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:59:59' + INTERVAL '1' SECOND")))).matches("TIME '13:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:59:59.999' + INTERVAL '0.001' SECOND")))).matches("TIME '13:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' + INTERVAL '13' HOUR")))).matches("TIME '01:34:56.000'");
    }

    @Test
    public void testSubtractIntervalDayToSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' - INTERVAL '1.123' SECOND")))).matches("TIME '12:34:54.877'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' - INTERVAL '1.123' SECOND")))).matches("TIME '12:34:54.977'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' - INTERVAL '1.123' SECOND")))).matches("TIME '12:34:54.997'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' - INTERVAL '1.123' SECOND")))).matches("TIME '12:34:55.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' - INTERVAL '1.123' SECOND")))).matches("TIME '12:34:55.0004'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' - INTERVAL '1.123' SECOND")))).matches("TIME '12:34:55.00045'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' - INTERVAL '1.123' SECOND")))).matches("TIME '12:34:55.000456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' - INTERVAL '1.123' SECOND")))).matches("TIME '12:34:55.0004567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' - INTERVAL '1.123' SECOND")))).matches("TIME '12:34:55.00045678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' - INTERVAL '1.123' SECOND")))).matches("TIME '12:34:55.000456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567890' - INTERVAL '1.123' SECOND")))).matches("TIME '12:34:55.0004567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678901' - INTERVAL '1.123' SECOND")))).matches("TIME '12:34:55.00045678901'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789012' - INTERVAL '1.123' SECOND")))).matches("TIME '12:34:55.000456789012'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '13:00:00' - INTERVAL '1' SECOND")))).matches("TIME '12:59:59.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '13:00:00' - INTERVAL '0.001' SECOND")))).matches("TIME '12:59:59.999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' - INTERVAL '13' HOUR")))).matches("TIME '23:34:56.000'");
    }

    @Test
    public void testSubtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' - TIME '12:34:55'")))).matches("INTERVAL '1' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.2' - TIME '12:34:55.1'")))).matches("INTERVAL '1.1' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.22' - TIME '12:34:55.11'")))).matches("INTERVAL '1.11' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.222' - TIME '12:34:55.111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.2222' - TIME '12:34:55.1111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.22222' - TIME '12:34:55.11111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.222222' - TIME '12:34:55.111111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.2222222' - TIME '12:34:55.1111111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.22222222' - TIME '12:34:55.11111111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.222222222' - TIME '12:34:55.111111111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.2222222222' - TIME '12:34:55.1111111111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.22222222222' - TIME '12:34:55.11111111111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.222222222222' - TIME '12:34:55.111111111111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.9' - TIME '12:34:55.1'")))).matches("INTERVAL '1.8' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.99' - TIME '12:34:55.11'")))).matches("INTERVAL '1.88' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.999' - TIME '12:34:55.111'")))).matches("INTERVAL '1.888' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.9999' - TIME '12:34:55.1111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.99999' - TIME '12:34:55.11111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.999999' - TIME '12:34:55.111111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.9999999' - TIME '12:34:55.1111111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.99999999' - TIME '12:34:55.11111111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.999999999' - TIME '12:34:55.111111111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.9999999999' - TIME '12:34:55.1111111111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.99999999999' - TIME '12:34:55.11111111111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.999999999999' - TIME '12:34:55.111111111111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55' - TIME '12:34:56'")))).matches("INTERVAL '-1' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.1' - TIME '12:34:56.2'")))).matches("INTERVAL '-1.1' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.11' - TIME '12:34:56.22'")))).matches("INTERVAL '-1.11' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.111' - TIME '12:34:56.222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.1111' - TIME '12:34:56.2222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.11111' - TIME '12:34:56.22222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.111111' - TIME '12:34:56.222222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.1111111' - TIME '12:34:56.2222222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.11111111' - TIME '12:34:56.22222222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.111111111' - TIME '12:34:56.222222222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.1111111111' - TIME '12:34:56.2222222222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.11111111111' - TIME '12:34:56.22222222222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.111111111111' - TIME '12:34:56.222222222222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.1' - TIME '12:34:56.9'")))).matches("INTERVAL '-1.8' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.11' - TIME '12:34:56.99'")))).matches("INTERVAL '-1.88' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.111' - TIME '12:34:56.999'")))).matches("INTERVAL '-1.888' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.1111' - TIME '12:34:56.9999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.11111' - TIME '12:34:56.99999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.111111' - TIME '12:34:56.999999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.1111111' - TIME '12:34:56.9999999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.11111111' - TIME '12:34:56.99999999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.111111111' - TIME '12:34:56.999999999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.1111111111' - TIME '12:34:56.9999999999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.11111111111' - TIME '12:34:56.99999999999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:55.111111111111' - TIME '12:34:56.999999999999'")))).matches("INTERVAL '-1.889' SECOND");
    }
}

