/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.time;

import io.prestosql.Session;
import io.prestosql.spi.type.SqlTime;
import io.prestosql.spi.type.TimeType;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.query.QueryAssertions;
import io.prestosql.testing.QueryRunner;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.function.BiFunction;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTime {
    protected QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testLiterals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56'")))).hasType((Type)TimeType.createTimeType((int)0)).isEqualTo(TestTime.time(0, 12, 34, 56, 0L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1'")))).hasType((Type)TimeType.createTimeType((int)1)).isEqualTo(TestTime.time(1, 12, 34, 56, 100000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12'")))).hasType((Type)TimeType.createTimeType((int)2)).isEqualTo(TestTime.time(2, 12, 34, 56, 120000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123'")))).hasType((Type)TimeType.createTimeType((int)3)).isEqualTo(TestTime.time(3, 12, 34, 56, 123000000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234'")))).hasType((Type)TimeType.createTimeType((int)4)).isEqualTo(TestTime.time(4, 12, 34, 56, 123400000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345'")))).hasType((Type)TimeType.createTimeType((int)5)).isEqualTo(TestTime.time(5, 12, 34, 56, 123450000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456'")))).hasType((Type)TimeType.createTimeType((int)6)).isEqualTo(TestTime.time(6, 12, 34, 56, 123456000000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567'")))).hasType((Type)TimeType.createTimeType((int)7)).isEqualTo(TestTime.time(7, 12, 34, 56, 123456700000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678'")))).hasType((Type)TimeType.createTimeType((int)8)).isEqualTo(TestTime.time(8, 12, 34, 56, 123456780000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789'")))).hasType((Type)TimeType.createTimeType((int)9)).isEqualTo(TestTime.time(9, 12, 34, 56, 123456789000L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567891'")))).hasType((Type)TimeType.createTimeType((int)10)).isEqualTo(TestTime.time(10, 12, 34, 56, 123456789100L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678912'")))).hasType((Type)TimeType.createTimeType((int)11)).isEqualTo(TestTime.time(11, 12, 34, 56, 123456789120L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789123'")))).hasType((Type)TimeType.createTimeType((int)12)).isEqualTo(TestTime.time(12, 12, 34, 56, 123456789123L));
        Assertions.assertThatThrownBy(() -> this.assertions.expression("TIME '12:34:56.1234567891234'")).hasMessage("line 1:8: TIME precision must be in range [0, 12]: 13");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("TIME '25:00:00'")).hasMessage("line 1:8: '25:00:00' is not a valid time literal");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("TIME '12:65:00'")).hasMessage("line 1:8: '12:65:00' is not a valid time literal");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("TIME '12:00:65'")).hasMessage("line 1:8: '12:00:65' is not a valid time literal");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("TIME 'xxx'")).hasMessage("line 1:8: 'xxx' is not a valid time literal");
    }

    @Test
    public void testCastToTime() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(2))")))).matches("TIME '12:34:56.12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(3))")))).matches("TIME '12:34:56.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(4))")))).matches("TIME '12:34:56.1234'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(5))")))).matches("TIME '12:34:56.12345'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIME(6))")))).matches("TIME '12:34:56.123456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIME(7))")))).matches("TIME '12:34:56.1234567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIME(8))")))).matches("TIME '12:34:56.12345678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIME(9))")))).matches("TIME '12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567891' AS TIME(10))")))).matches("TIME '12:34:56.1234567891'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678912' AS TIME(11))")))).matches("TIME '12:34:56.12345678912'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789123' AS TIME(12))")))).matches("TIME '12:34:56.123456789123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(1))")))).matches("TIME '12:34:56.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(2))")))).matches("TIME '12:34:56.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(3))")))).matches("TIME '12:34:56.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(4))")))).matches("TIME '12:34:56.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(5))")))).matches("TIME '12:34:56.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(6))")))).matches("TIME '12:34:56.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(7))")))).matches("TIME '12:34:56.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(8))")))).matches("TIME '12:34:56.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(9))")))).matches("TIME '12:34:56.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(10))")))).matches("TIME '12:34:56.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(11))")))).matches("TIME '12:34:56.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(12))")))).matches("TIME '12:34:56.000000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(2))")))).matches("TIME '12:34:56.10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(3))")))).matches("TIME '12:34:56.100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(4))")))).matches("TIME '12:34:56.1000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(5))")))).matches("TIME '12:34:56.10000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(6))")))).matches("TIME '12:34:56.100000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(7))")))).matches("TIME '12:34:56.1000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(8))")))).matches("TIME '12:34:56.10000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(9))")))).matches("TIME '12:34:56.100000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(10))")))).matches("TIME '12:34:56.1000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(11))")))).matches("TIME '12:34:56.10000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(12))")))).matches("TIME '12:34:56.100000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(3))")))).matches("TIME '12:34:56.120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(4))")))).matches("TIME '12:34:56.1200'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(5))")))).matches("TIME '12:34:56.12000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(6))")))).matches("TIME '12:34:56.120000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(7))")))).matches("TIME '12:34:56.1200000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(8))")))).matches("TIME '12:34:56.12000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(9))")))).matches("TIME '12:34:56.120000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(10))")))).matches("TIME '12:34:56.1200000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(11))")))).matches("TIME '12:34:56.12000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(12))")))).matches("TIME '12:34:56.120000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(4))")))).matches("TIME '12:34:56.1230'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(5))")))).matches("TIME '12:34:56.12300'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(6))")))).matches("TIME '12:34:56.123000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(7))")))).matches("TIME '12:34:56.1230000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(8))")))).matches("TIME '12:34:56.12300000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(9))")))).matches("TIME '12:34:56.123000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(10))")))).matches("TIME '12:34:56.1230000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(11))")))).matches("TIME '12:34:56.12300000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(12))")))).matches("TIME '12:34:56.123000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(5))")))).matches("TIME '12:34:56.12340'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(6))")))).matches("TIME '12:34:56.123400'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(7))")))).matches("TIME '12:34:56.1234000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(8))")))).matches("TIME '12:34:56.12340000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(9))")))).matches("TIME '12:34:56.123400000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(10))")))).matches("TIME '12:34:56.1234000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(11))")))).matches("TIME '12:34:56.12340000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(12))")))).matches("TIME '12:34:56.123400000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(6))")))).matches("TIME '12:34:56.123450'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(7))")))).matches("TIME '12:34:56.1234500'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(8))")))).matches("TIME '12:34:56.12345000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(9))")))).matches("TIME '12:34:56.123450000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(10))")))).matches("TIME '12:34:56.1234500000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(11))")))).matches("TIME '12:34:56.12345000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(12))")))).matches("TIME '12:34:56.123450000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIME(7))")))).matches("TIME '12:34:56.1234560'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIME(8))")))).matches("TIME '12:34:56.12345600'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIME(9))")))).matches("TIME '12:34:56.123456000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIME(10))")))).matches("TIME '12:34:56.1234560000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIME(11))")))).matches("TIME '12:34:56.12345600000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIME(12))")))).matches("TIME '12:34:56.123456000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIME(8))")))).matches("TIME '12:34:56.12345670'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIME(9))")))).matches("TIME '12:34:56.123456700'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIME(10))")))).matches("TIME '12:34:56.1234567000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIME(11))")))).matches("TIME '12:34:56.12345670000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIME(12))")))).matches("TIME '12:34:56.123456700000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIME(9))")))).matches("TIME '12:34:56.123456780'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIME(10))")))).matches("TIME '12:34:56.1234567800'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIME(11))")))).matches("TIME '12:34:56.12345678000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIME(12))")))).matches("TIME '12:34:56.123456780000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIME(10))")))).matches("TIME '12:34:56.1234567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIME(11))")))).matches("TIME '12:34:56.12345678900'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIME(12))")))).matches("TIME '12:34:56.123456789000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567891' AS TIME(11))")))).matches("TIME '12:34:56.12345678910'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567891' AS TIME(12))")))).matches("TIME '12:34:56.123456789100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678912' AS TIME(12))")))).matches("TIME '12:34:56.123456789120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(9))")))).matches("TIME '12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(9))")))).matches("TIME '12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(9))")))).matches("TIME '12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(10))")))).matches("TIME '12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(10))")))).matches("TIME '12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(11))")))).matches("TIME '12:34:56.11111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(9))")))).matches("TIME '12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(9))")))).matches("TIME '12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(9))")))).matches("TIME '12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(10))")))).matches("TIME '12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(10))")))).matches("TIME '12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(11))")))).matches("TIME '12:34:56.55555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(6))")))).matches("TIME '00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(7))")))).matches("TIME '00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(8))")))).matches("TIME '00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(9))")))).matches("TIME '00:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(10))")))).matches("TIME '00:00:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(11))")))).matches("TIME '00:00:00.00000000000'");
    }

    @Test
    public void testLocalTime() {
        Session session = this.assertions.sessionBuilder().setStart(Instant.from(ZonedDateTime.of(2020, 5, 1, 12, 34, 56, 111111111, this.assertions.getDefaultSession().getTimeZoneKey().getZoneId()))).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(0)", session)))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(1)", session)))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(2)", session)))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(3)", session)))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(4)", session)))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(5)", session)))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(6)", session)))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(7)", session)))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(8)", session)))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(9)", session)))).matches("TIME '12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(10)", session)))).matches("TIME '12:34:56.1111111110'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(11)", session)))).matches("TIME '12:34:56.11111111100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(12)", session)))).matches("TIME '12:34:56.111111111000'");
        session = this.assertions.sessionBuilder().setStart(Instant.from(ZonedDateTime.of(2020, 5, 1, 12, 34, 56, 555555555, this.assertions.getDefaultSession().getTimeZoneKey().getZoneId()))).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(0)", session)))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(1)", session)))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(2)", session)))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(3)", session)))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(4)", session)))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(5)", session)))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(6)", session)))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(7)", session)))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(8)", session)))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(9)", session)))).matches("TIME '12:34:56.555555555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(10)", session)))).matches("TIME '12:34:56.5555555550'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(11)", session)))).matches("TIME '12:34:56.55555555500'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(12)", session)))).matches("TIME '12:34:56.555555555000'");
        session = this.assertions.sessionBuilder().setStart(Instant.from(ZonedDateTime.of(2020, 5, 1, 23, 59, 59, 999999999, this.assertions.getDefaultSession().getTimeZoneKey().getZoneId()))).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(0)", session)))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(1)", session)))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(2)", session)))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(3)", session)))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(4)", session)))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(5)", session)))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(6)", session)))).matches("TIME '00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(7)", session)))).matches("TIME '00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(8)", session)))).matches("TIME '00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(9)", session)))).matches("TIME '23:59:59.999999999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(10)", session)))).matches("TIME '23:59:59.9999999990'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(11)", session)))).matches("TIME '23:59:59.99999999900'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("localtime(12)", session)))).matches("TIME '23:59:59.999999999000'");
    }

    @Test
    public void testCastToTimeWithTimeZone() {
        Session session = this.assertions.sessionBuilder().setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"+08:35")).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234567+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345678+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456789+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567891' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234567891+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678912' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345678912+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789123' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456789123+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.0+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.0000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.00000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.0000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.00000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.0000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.00000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.000000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.10+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.100+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.10000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.100000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.10000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.100000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.10000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.100000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.120+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1200+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.120000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1200000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.120000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1200000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.120000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1230+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12300+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1230000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12300000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1230000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12300000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12340+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123400+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12340000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123400000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12340000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123400000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123450+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234500+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123450000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234500000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123450000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234560+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345600+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234560000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345600000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345670+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456700+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234567000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345670000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456700000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456780+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234567800+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345678000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456780000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1234567890+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345678900+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456789000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567891' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.12345678910+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567891' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456789100+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678912' AS TIME(12) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.123456789120+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.111111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.1111111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.11111111111+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '12:34:57+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.6+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.555555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5555555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.5555555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '12:34:56.55555555556+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(0) WITH TIME ZONE)", session)))).matches("TIME '00:00:00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(1) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(2) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(3) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(4) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(5) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(6) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(7) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(8) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(9) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(10) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.0000000000+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(11) WITH TIME ZONE)", session)))).matches("TIME '00:00:00.00000000000+08:35'");
    }

    @Test
    public void testCastToTimestamp() {
        Session session = this.assertions.sessionBuilder().setStart(Instant.from(ZonedDateTime.of(2020, 5, 1, 12, 34, 56, 111111111, this.assertions.getDefaultSession().getTimeZoneKey().getZoneId()))).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567891' AS TIMESTAMP(10))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567891'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678912' AS TIMESTAMP(11))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678912'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789123' AS TIMESTAMP(12))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(10))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(11))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(12))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.000000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.10000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.100000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.10000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.100000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(10))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(11))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.10000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(12))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.100000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1200'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.120000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1200000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.120000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(10))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1200000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(11))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(12))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.120000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1230'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12300'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1230000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12300000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(10))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1230000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(11))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12300000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(12))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12340'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123400'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12340000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123400000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(10))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(11))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12340000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(12))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123400000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123450'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234500'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123450000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(10))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234500000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(11))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(12))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123450000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234560'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345600'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIMESTAMP(10))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234560000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIMESTAMP(11))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345600000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIMESTAMP(12))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345670'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456700'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIMESTAMP(10))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIMESTAMP(11))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345670000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIMESTAMP(12))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456700000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456780'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIMESTAMP(10))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567800'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIMESTAMP(11))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIMESTAMP(12))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456780000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIMESTAMP(10))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIMESTAMP(11))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678900'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIMESTAMP(12))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567891' AS TIMESTAMP(11))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678910'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567891' AS TIMESTAMP(12))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678912' AS TIMESTAMP(12))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(10))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(10))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(11))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(0))", session)))).matches("TIMESTAMP '2020-05-01 12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(1))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(2))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(3))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(4))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(5))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(6))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(7))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(8))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(9))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(10))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(10))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(11))", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555555556'");
    }

    @Test
    public void testCastToTimestampWithTimeZone() {
        Session session = this.assertions.sessionBuilder().setStart(Instant.from(ZonedDateTime.of(2020, 5, 1, 12, 34, 56, 111111111, this.assertions.getDefaultSession().getTimeZoneKey().getZoneId()))).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567891' AS TIMESTAMP(10) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567891 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678912' AS TIMESTAMP(11) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678912 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789123' AS TIMESTAMP(12) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789123 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.0 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.00 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.0000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.00000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.0000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.00000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(10) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.0000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(11) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.00000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS TIMESTAMP(12) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.000000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.10 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.100 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.10000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.100000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.10000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.100000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(10) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(11) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.10000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(12) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.100000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.120 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1200 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.120000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1200000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.120000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(10) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1200000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(11) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS TIMESTAMP(12) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.120000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1230 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12300 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1230000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12300000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(10) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1230000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(11) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12300000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS TIMESTAMP(12) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123000000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12340 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123400 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12340000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123400000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(10) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(11) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12340000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS TIMESTAMP(12) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123400000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123450 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234500 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123450000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(10) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234500000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(11) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS TIMESTAMP(12) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123450000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234560 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345600 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIMESTAMP(10) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234560000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIMESTAMP(11) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345600000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS TIMESTAMP(12) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456000000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345670 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456700 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIMESTAMP(10) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIMESTAMP(11) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345670000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS TIMESTAMP(12) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456700000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456780 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIMESTAMP(10) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567800 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIMESTAMP(11) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS TIMESTAMP(12) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456780000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIMESTAMP(10) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1234567890 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIMESTAMP(11) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678900 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS TIMESTAMP(12) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789000 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567891' AS TIMESTAMP(11) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.12345678910 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567891' AS TIMESTAMP(12) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789100 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678912' AS TIMESTAMP(12) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.123456789120 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.111111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIMESTAMP(10) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(10) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.1111111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIMESTAMP(11) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.11111111111 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:57 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(1) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.6 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(2) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(3) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(4) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(5) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(6) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(7) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(8) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(9) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.555555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIMESTAMP(10) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(10) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.5555555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIMESTAMP(11) WITH TIME ZONE)", session)))).matches("TIMESTAMP '2020-05-01 12:34:56.55555555556 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '12001-05-01 12:34:56' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '12001-05-01 12:34:56 Pacific/Apia'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIMESTAMP '-12001-05-01 12:34:56' AS TIMESTAMP(0) WITH TIME ZONE)", session)))).matches("TIMESTAMP '-12001-05-01 12:34:56 Pacific/Apia'");
    }

    @Test
    public void testCastToVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56' AS VARCHAR)")))).isEqualTo("12:34:56");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS VARCHAR)")))).isEqualTo("12:34:56.1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12' AS VARCHAR)")))).isEqualTo("12:34:56.12");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123' AS VARCHAR)")))).isEqualTo("12:34:56.123");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234' AS VARCHAR)")))).isEqualTo("12:34:56.1234");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345' AS VARCHAR)")))).isEqualTo("12:34:56.12345");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456' AS VARCHAR)")))).isEqualTo("12:34:56.123456");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567' AS VARCHAR)")))).isEqualTo("12:34:56.1234567");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678' AS VARCHAR)")))).isEqualTo("12:34:56.12345678");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789' AS VARCHAR)")))).isEqualTo("12:34:56.123456789");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1234567890' AS VARCHAR)")))).isEqualTo("12:34:56.1234567890");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.12345678901' AS VARCHAR)")))).isEqualTo("12:34:56.12345678901");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.123456789012' AS VARCHAR)")))).isEqualTo("12:34:56.123456789012");
    }

    @Test
    public void testCastFromVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.111111111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.111111111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.111111111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.111111111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.111111111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.111111111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.111111111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.111111111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.111111111111' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.111111111111' AS TIME(9))")))).matches("TIME '12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.111111111111' AS TIME(10))")))).matches("TIME '12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.111111111111' AS TIME(11))")))).matches("TIME '12:34:56.11111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.111111111111' AS TIME(12))")))).matches("TIME '12:34:56.111111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.555555555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.555555555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.555555555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.555555555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.555555555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.555555555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.555555555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.555555555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.555555555555' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.555555555555' AS TIME(9))")))).matches("TIME '12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.555555555555' AS TIME(10))")))).matches("TIME '12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.555555555555' AS TIME(11))")))).matches("TIME '12:34:56.55555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('12:34:56.555555555555' AS TIME(12))")))).matches("TIME '12:34:56.555555555555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('23:59:59.999999999999' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('23:59:59.999999999999' AS TIME(1))")))).matches("TIME '00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('23:59:59.999999999999' AS TIME(2))")))).matches("TIME '00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('23:59:59.999999999999' AS TIME(3))")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('23:59:59.999999999999' AS TIME(4))")))).matches("TIME '00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('23:59:59.999999999999' AS TIME(5))")))).matches("TIME '00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('23:59:59.999999999999' AS TIME(6))")))).matches("TIME '00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('23:59:59.999999999999' AS TIME(7))")))).matches("TIME '00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('23:59:59.999999999999' AS TIME(8))")))).matches("TIME '00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('23:59:59.999999999999' AS TIME(9))")))).matches("TIME '00:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('23:59:59.999999999999' AS TIME(10))")))).matches("TIME '00:00:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST('23:59:59.999999999999' AS TIME(11))")))).matches("TIME '00:00:00.00000000000'");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('12:34:56.1111111111111' AS TIME(0))")).hasMessage("Value cannot be cast to time: 12:34:56.1111111111111");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('12:34:56.1111111111111' AS TIME(1))")).hasMessage("Value cannot be cast to time: 12:34:56.1111111111111");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('12:34:56.1111111111111' AS TIME(2))")).hasMessage("Value cannot be cast to time: 12:34:56.1111111111111");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('12:34:56.1111111111111' AS TIME(3))")).hasMessage("Value cannot be cast to time: 12:34:56.1111111111111");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('12:34:56.1111111111111' AS TIME(4))")).hasMessage("Value cannot be cast to time: 12:34:56.1111111111111");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('12:34:56.1111111111111' AS TIME(5))")).hasMessage("Value cannot be cast to time: 12:34:56.1111111111111");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('12:34:56.1111111111111' AS TIME(6))")).hasMessage("Value cannot be cast to time: 12:34:56.1111111111111");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('12:34:56.1111111111111' AS TIME(7))")).hasMessage("Value cannot be cast to time: 12:34:56.1111111111111");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('12:34:56.1111111111111' AS TIME(8))")).hasMessage("Value cannot be cast to time: 12:34:56.1111111111111");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('12:34:56.1111111111111' AS TIME(9))")).hasMessage("Value cannot be cast to time: 12:34:56.1111111111111");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('12:34:56.1111111111111' AS TIME(10))")).hasMessage("Value cannot be cast to time: 12:34:56.1111111111111");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('12:34:56.1111111111111' AS TIME(11))")).hasMessage("Value cannot be cast to time: 12:34:56.1111111111111");
        Assertions.assertThatThrownBy(() -> this.assertions.expression("CAST('12:34:56.1111111111111' AS TIME(12))")).hasMessage("Value cannot be cast to time: 12:34:56.1111111111111");
    }

    @Test
    public void testLowerDigitsZeroed() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.111111111111' AS TIME(0)) AS TIME(12))")))).matches("TIME '12:34:56.000000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.111111111111' AS TIME(3)) AS TIME(12))")))).matches("TIME '12:34:56.111000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.111111111111' AS TIME(6)) AS TIME(12))")))).matches("TIME '12:34:56.111111000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.111111111111' AS TIME(9)) AS TIME(12))")))).matches("TIME '12:34:56.111111111000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.111111' AS TIME(0)) AS TIME(6))")))).matches("TIME '12:34:56.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.111111' AS TIME(3)) AS TIME(6))")))).matches("TIME '12:34:56.111000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.111111' AS TIME(6)) AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.111' AS TIME(0)) AS TIME(3))")))).matches("TIME '12:34:56.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.555555555555' AS TIME(0)) AS TIME(12))")))).matches("TIME '12:34:57.000000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.555555555555' AS TIME(3)) AS TIME(12))")))).matches("TIME '12:34:56.556000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.555555555555' AS TIME(6)) AS TIME(12))")))).matches("TIME '12:34:56.555556000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.555555555555' AS TIME(9)) AS TIME(12))")))).matches("TIME '12:34:56.555555556000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.555555' AS TIME(0)) AS TIME(6))")))).matches("TIME '12:34:57.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.555555' AS TIME(3)) AS TIME(6))")))).matches("TIME '12:34:56.556000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.555555' AS TIME(6)) AS TIME(6))")))).matches("TIME '12:34:56.555555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(CAST(TIME '12:34:56.555' AS TIME(0)) AS TIME(3))")))).matches("TIME '12:34:57.000'");
    }

    @Test
    public void testRoundDown() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(9))")))).matches("TIME '12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(10))")))).matches("TIME '12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111111' AS TIME(11))")))).matches("TIME '12:34:56.11111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(9))")))).matches("TIME '12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111111' AS TIME(10))")))).matches("TIME '12:34:56.1111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111111' AS TIME(9))")))).matches("TIME '12:34:56.111111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111111' AS TIME(8))")))).matches("TIME '12:34:56.11111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111111' AS TIME(7))")))).matches("TIME '12:34:56.1111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111111' AS TIME(6))")))).matches("TIME '12:34:56.111111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111111' AS TIME(5))")))).matches("TIME '12:34:56.11111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11111' AS TIME(4))")))).matches("TIME '12:34:56.1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1111' AS TIME(3))")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.111' AS TIME(2))")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11' AS TIME(0))")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.11' AS TIME(1))")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.1' AS TIME(0))")))).matches("TIME '12:34:56'");
    }

    @Test
    public void testRoundUp() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '23:59:59.999999999999' AS TIME(0))")))).matches("TIME '00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(9))")))).matches("TIME '12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(10))")))).matches("TIME '12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555555' AS TIME(11))")))).matches("TIME '12:34:56.55555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(9))")))).matches("TIME '12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555555' AS TIME(10))")))).matches("TIME '12:34:56.5555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555555' AS TIME(9))")))).matches("TIME '12:34:56.555555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555555' AS TIME(8))")))).matches("TIME '12:34:56.55555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555555' AS TIME(7))")))).matches("TIME '12:34:56.5555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555555' AS TIME(6))")))).matches("TIME '12:34:56.555556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555555' AS TIME(5))")))).matches("TIME '12:34:56.55556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55555' AS TIME(4))")))).matches("TIME '12:34:56.5556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5555' AS TIME(3))")))).matches("TIME '12:34:56.556'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.555' AS TIME(2))")))).matches("TIME '12:34:56.56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55' AS TIME(0))")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.55' AS TIME(1))")))).matches("TIME '12:34:56.6'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("CAST(TIME '12:34:56.5' AS TIME(0))")))).matches("TIME '12:34:57'");
    }

    @Test
    public void testFormat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56')")))).isEqualTo("12:34:56");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.1')")))).isEqualTo("12:34:56.100");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.11')")))).isEqualTo("12:34:56.110");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.111')")))).isEqualTo("12:34:56.111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.1111')")))).isEqualTo("12:34:56.111100");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.11111')")))).isEqualTo("12:34:56.111110");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.111111')")))).isEqualTo("12:34:56.111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.1111111')")))).isEqualTo("12:34:56.111111100");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.11111111')")))).isEqualTo("12:34:56.111111110");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.111111111')")))).isEqualTo("12:34:56.111111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.1111111111')")))).isEqualTo("12:34:56.111111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.11111111111')")))).isEqualTo("12:34:56.111111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.111111111111')")))).isEqualTo("12:34:56.111111111");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56')")))).isEqualTo("12:34:56");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.5')")))).isEqualTo("12:34:56.500");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.55')")))).isEqualTo("12:34:56.550");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.555')")))).isEqualTo("12:34:56.555");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.5555')")))).isEqualTo("12:34:56.555500");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.55555')")))).isEqualTo("12:34:56.555550");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.555555')")))).isEqualTo("12:34:56.555555");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.5555555')")))).isEqualTo("12:34:56.555555500");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.55555555')")))).isEqualTo("12:34:56.555555550");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.555555555')")))).isEqualTo("12:34:56.555555555");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.5555555555')")))).isEqualTo("12:34:56.555555556");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.55555555555')")))).isEqualTo("12:34:56.555555556");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("format('%s', TIME '12:34:56.555555555555')")))).isEqualTo("12:34:56.555555556");
    }

    @Test
    public void testDateDiff() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55', TIME '12:34:56')")))).matches("BIGINT '1000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.1', TIME '12:34:56.2')")))).matches("BIGINT '1100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.11', TIME '12:34:56.22')")))).matches("BIGINT '1110'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.111', TIME '12:34:56.222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.1111', TIME '12:34:56.2222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.11111', TIME '12:34:56.22222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.111111', TIME '12:34:56.222222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.1111111', TIME '12:34:56.2222222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.11111111', TIME '12:34:56.22222222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.111111111', TIME '12:34:56.222222222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.1111111111', TIME '12:34:56.2222222222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.11111111111', TIME '12:34:56.22222222222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.111111111111', TIME '12:34:56.222222222222')")))).matches("BIGINT '1111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55', TIME '12:34:56')")))).matches("BIGINT '1000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.1', TIME '12:34:56.9')")))).matches("BIGINT '1800'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.11', TIME '12:34:56.99')")))).matches("BIGINT '1880'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.111', TIME '12:34:56.999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.1111', TIME '12:34:56.9999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.11111', TIME '12:34:56.99999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.111111', TIME '12:34:56.999999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.1111111', TIME '12:34:56.9999999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.11111111', TIME '12:34:56.99999999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.111111111', TIME '12:34:56.999999999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.1111111111', TIME '12:34:56.9999999999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.11111111111', TIME '12:34:56.99999999999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('millisecond', TIME '12:34:55.111111111111', TIME '12:34:56.999999999999')")))).matches("BIGINT '1888'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55', TIME '12:34:56')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.1', TIME '12:34:56.2')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.11', TIME '12:34:56.22')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.111', TIME '12:34:56.222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.1111', TIME '12:34:56.2222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.11111', TIME '12:34:56.22222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.111111', TIME '12:34:56.222222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.1111111', TIME '12:34:56.2222222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.11111111', TIME '12:34:56.22222222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.111111111', TIME '12:34:56.222222222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.1111111111', TIME '12:34:56.2222222222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.11111111111', TIME '12:34:56.22222222222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.111111111111', TIME '12:34:56.222222222222')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.1', TIME '12:34:56.9')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.11', TIME '12:34:56.99')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.111', TIME '12:34:56.999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.1111', TIME '12:34:56.9999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.11111', TIME '12:34:56.99999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.111111', TIME '12:34:56.999999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.1111111', TIME '12:34:56.9999999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.11111111', TIME '12:34:56.99999999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.111111111', TIME '12:34:56.999999999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.1111111111', TIME '12:34:56.9999999999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.11111111111', TIME '12:34:56.99999999999')")))).matches("BIGINT '1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_diff('hour', TIME '11:34:55.111111111111', TIME '12:34:56.999999999999')")))).matches("BIGINT '1'");
    }

    @Test
    public void testDateAdd() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIME '12:34:56')")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIME '12:34:56.1')")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIME '12:34:56.10')")))).matches("TIME '12:34:56.10'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIME '12:34:56.100')")))).matches("TIME '12:34:56.101'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIME '12:34:56.1000')")))).matches("TIME '12:34:56.1010'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIME '12:34:56.10000')")))).matches("TIME '12:34:56.10100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIME '12:34:56.100000')")))).matches("TIME '12:34:56.101000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIME '12:34:56.1000000')")))).matches("TIME '12:34:56.1010000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIME '12:34:56.10000000')")))).matches("TIME '12:34:56.10100000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIME '12:34:56.100000000')")))).matches("TIME '12:34:56.101000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIME '12:34:56.1000000000')")))).matches("TIME '12:34:56.1010000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIME '12:34:56.10000000000')")))).matches("TIME '12:34:56.10100000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIME '12:34:56.100000000000')")))).matches("TIME '12:34:56.101000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1000, TIME '12:34:56')")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', 1, TIME '23:59:59.999')")))).matches("TIME '00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', -1, TIME '00:00:00.000')")))).matches("TIME '23:59:59.999'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('hour', 365 * 24, TIME '12:34:56')")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('hour', 365 * 24 + 1, TIME '12:34:56')")))).matches("TIME '13:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('minute', 365 * 24 * 60, TIME '12:34:56')")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('minute', 365 * 24 * 60 + 1, TIME '12:34:56')")))).matches("TIME '12:35:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('second', 365 * 24 * 60 * 60, TIME '12:34:56')")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('second', 365 * 24 * 60 * 60 + 1, TIME '12:34:56')")))).matches("TIME '12:34:57'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', BIGINT '365' * 24 * 60 * 60 * 1000, TIME '12:34:56.000')")))).matches("TIME '12:34:56.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_add('millisecond', BIGINT '365' * 24 * 60 * 60 * 1000 + 1, TIME '12:34:56.000')")))).matches("TIME '12:34:56.001'");
    }

    @Test
    public void testDateTrunc() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56')")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.1')")))).matches("TIME '12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.11')")))).matches("TIME '12:34:56.11'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.111')")))).matches("TIME '12:34:56.111'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.1111')")))).matches("TIME '12:34:56.1110'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.11111')")))).matches("TIME '12:34:56.11100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.111111')")))).matches("TIME '12:34:56.111000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.1111111')")))).matches("TIME '12:34:56.1110000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.11111111')")))).matches("TIME '12:34:56.11100000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.111111111')")))).matches("TIME '12:34:56.111000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.1111111111')")))).matches("TIME '12:34:56.1110000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.11111111111')")))).matches("TIME '12:34:56.11100000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.111111111111')")))).matches("TIME '12:34:56.111000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.5')")))).matches("TIME '12:34:56.5'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.55')")))).matches("TIME '12:34:56.55'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.555')")))).matches("TIME '12:34:56.555'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.5555')")))).matches("TIME '12:34:56.5550'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.55555')")))).matches("TIME '12:34:56.55500'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.555555')")))).matches("TIME '12:34:56.555000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.5555555')")))).matches("TIME '12:34:56.5550000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.55555555')")))).matches("TIME '12:34:56.55500000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.555555555')")))).matches("TIME '12:34:56.555000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.5555555555')")))).matches("TIME '12:34:56.5550000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.55555555555')")))).matches("TIME '12:34:56.55500000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIME '12:34:56.555555555555')")))).matches("TIME '12:34:56.555000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56')")))).matches("TIME '12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.1')")))).matches("TIME '12:34:56.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.11')")))).matches("TIME '12:34:56.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.111')")))).matches("TIME '12:34:56.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.1111')")))).matches("TIME '12:34:56.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.11111')")))).matches("TIME '12:34:56.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.111111')")))).matches("TIME '12:34:56.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.1111111')")))).matches("TIME '12:34:56.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.11111111')")))).matches("TIME '12:34:56.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.111111111')")))).matches("TIME '12:34:56.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.1111111111')")))).matches("TIME '12:34:56.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.11111111111')")))).matches("TIME '12:34:56.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.111111111111')")))).matches("TIME '12:34:56.000000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.5')")))).matches("TIME '12:34:56.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.55')")))).matches("TIME '12:34:56.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.555')")))).matches("TIME '12:34:56.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.5555')")))).matches("TIME '12:34:56.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.55555')")))).matches("TIME '12:34:56.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.555555')")))).matches("TIME '12:34:56.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.5555555')")))).matches("TIME '12:34:56.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.55555555')")))).matches("TIME '12:34:56.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.555555555')")))).matches("TIME '12:34:56.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.5555555555')")))).matches("TIME '12:34:56.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.55555555555')")))).matches("TIME '12:34:56.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIME '12:34:56.555555555555')")))).matches("TIME '12:34:56.000000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56')")))).matches("TIME '12:34:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.1')")))).matches("TIME '12:34:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.11')")))).matches("TIME '12:34:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.111')")))).matches("TIME '12:34:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.1111')")))).matches("TIME '12:34:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.11111')")))).matches("TIME '12:34:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.111111')")))).matches("TIME '12:34:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.1111111')")))).matches("TIME '12:34:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.11111111')")))).matches("TIME '12:34:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.111111111')")))).matches("TIME '12:34:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.1111111111')")))).matches("TIME '12:34:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.11111111111')")))).matches("TIME '12:34:00.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.111111111111')")))).matches("TIME '12:34:00.000000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.5')")))).matches("TIME '12:34:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.55')")))).matches("TIME '12:34:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.555')")))).matches("TIME '12:34:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.5555')")))).matches("TIME '12:34:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.55555')")))).matches("TIME '12:34:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.555555')")))).matches("TIME '12:34:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.5555555')")))).matches("TIME '12:34:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.55555555')")))).matches("TIME '12:34:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.555555555')")))).matches("TIME '12:34:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.5555555555')")))).matches("TIME '12:34:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.55555555555')")))).matches("TIME '12:34:00.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIME '12:34:56.555555555555')")))).matches("TIME '12:34:00.000000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56')")))).matches("TIME '12:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.1')")))).matches("TIME '12:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.11')")))).matches("TIME '12:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.111')")))).matches("TIME '12:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.1111')")))).matches("TIME '12:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.11111')")))).matches("TIME '12:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.111111')")))).matches("TIME '12:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.1111111')")))).matches("TIME '12:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.11111111')")))).matches("TIME '12:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.111111111')")))).matches("TIME '12:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.1111111111')")))).matches("TIME '12:00:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.11111111111')")))).matches("TIME '12:00:00.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.111111111111')")))).matches("TIME '12:00:00.000000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.5')")))).matches("TIME '12:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.55')")))).matches("TIME '12:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.555')")))).matches("TIME '12:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.5555')")))).matches("TIME '12:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.55555')")))).matches("TIME '12:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.555555')")))).matches("TIME '12:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.5555555')")))).matches("TIME '12:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.55555555')")))).matches("TIME '12:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.555555555')")))).matches("TIME '12:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.5555555555')")))).matches("TIME '12:00:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.55555555555')")))).matches("TIME '12:00:00.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIME '12:34:56.555555555555')")))).matches("TIME '12:00:00.000000000000'");
    }

    @Test
    public void testAtTimeZone() {
        Session session = this.assertions.sessionBuilder().setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Pacific/Apia")).setStart(Instant.from(ZonedDateTime.of(2020, 5, 1, 12, 0, 0, 0, ZoneId.of("Pacific/Apia")))).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' AT TIME ZONE '+08:35'", session)))).matches("TIME '08:09:56+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' AT TIME ZONE '+08:35'", session)))).matches("TIME '08:09:56.1+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' AT TIME ZONE '+08:35'", session)))).matches("TIME '08:09:56.12+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' AT TIME ZONE '+08:35'", session)))).matches("TIME '08:09:56.123+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' AT TIME ZONE '+08:35'", session)))).matches("TIME '08:09:56.1234+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' AT TIME ZONE '+08:35'", session)))).matches("TIME '08:09:56.12345+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' AT TIME ZONE '+08:35'", session)))).matches("TIME '08:09:56.123456+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' AT TIME ZONE '+08:35'", session)))).matches("TIME '08:09:56.1234567+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' AT TIME ZONE '+08:35'", session)))).matches("TIME '08:09:56.12345678+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' AT TIME ZONE '+08:35'", session)))).matches("TIME '08:09:56.123456789+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567891' AT TIME ZONE '+08:35'", session)))).matches("TIME '08:09:56.1234567891+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678912' AT TIME ZONE '+08:35'", session)))).matches("TIME '08:09:56.12345678912+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789123' AT TIME ZONE '+08:35'", session)))).matches("TIME '08:09:56.123456789123+08:35'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIME '09:34:56+10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIME '09:34:56.1+10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIME '09:34:56.12+10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIME '09:34:56.123+10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIME '09:34:56.1234+10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIME '09:34:56.12345+10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIME '09:34:56.123456+10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIME '09:34:56.1234567+10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIME '09:34:56.12345678+10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIME '09:34:56.123456789+10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.1234567891' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIME '09:34:56.1234567891+10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.12345678912' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIME '09:34:56.12345678912+10:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIME '12:34:56.123456789123' AT TIME ZONE INTERVAL '10' HOUR", session)))).matches("TIME '09:34:56.123456789123+10:00'");
    }

    private static BiFunction<Session, QueryRunner, Object> time(int precision, int hour, int minute, int second, long picoOfSecond) {
        return (session, queryRunner) -> {
            long picos = (long)(hour * 3600 + minute * 60 + second) * 1000000000000L + picoOfSecond;
            return SqlTime.newInstance((int)precision, (long)picos);
        };
    }
}

