/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.Session;
import io.prestosql.sql.query.QueryAssertions;
import io.prestosql.testing.TestingSession;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDateTrunc {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        Session session = TestingSession.testSessionBuilder().setTimeZoneKey(TestingSession.DEFAULT_TIME_ZONE_KEY).build();
        this.assertions = new QueryAssertions(session);
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testDateTruncYear() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56')")))).matches("TIMESTAMP '2020-01-01 00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("TIMESTAMP '2020-01-01 00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("TIMESTAMP '2020-01-01 00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("TIMESTAMP '2020-01-01 00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("TIMESTAMP '2020-01-01 00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("TIMESTAMP '2020-01-01 00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("TIMESTAMP '2020-01-01 00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("TIMESTAMP '2020-01-01 00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("TIMESTAMP '2020-01-01 00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("TIMESTAMP '2020-01-01 00:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("TIMESTAMP '2020-01-01 00:00:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("TIMESTAMP '2020-01-01 00:00:00.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('year', TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("TIMESTAMP '2020-01-01 00:00:00.000000000000'");
    }

    @Test
    public void testDateTruncQuarter() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56')")))).matches("TIMESTAMP '2020-04-01 00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("TIMESTAMP '2020-04-01 00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("TIMESTAMP '2020-04-01 00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("TIMESTAMP '2020-04-01 00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("TIMESTAMP '2020-04-01 00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("TIMESTAMP '2020-04-01 00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("TIMESTAMP '2020-04-01 00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("TIMESTAMP '2020-04-01 00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("TIMESTAMP '2020-04-01 00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("TIMESTAMP '2020-04-01 00:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("TIMESTAMP '2020-04-01 00:00:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("TIMESTAMP '2020-04-01 00:00:00.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('quarter', TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("TIMESTAMP '2020-04-01 00:00:00.000000000000'");
    }

    @Test
    public void testDateTruncMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56')")))).matches("TIMESTAMP '2020-05-01 00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("TIMESTAMP '2020-05-01 00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("TIMESTAMP '2020-05-01 00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("TIMESTAMP '2020-05-01 00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("TIMESTAMP '2020-05-01 00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("TIMESTAMP '2020-05-01 00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("TIMESTAMP '2020-05-01 00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("TIMESTAMP '2020-05-01 00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("TIMESTAMP '2020-05-01 00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("TIMESTAMP '2020-05-01 00:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("TIMESTAMP '2020-05-01 00:00:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("TIMESTAMP '2020-05-01 00:00:00.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('month', TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("TIMESTAMP '2020-05-01 00:00:00.000000000000'");
    }

    @Test
    public void testDateTruncWeek() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56')")))).matches("TIMESTAMP '2020-05-04 00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("TIMESTAMP '2020-05-04 00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("TIMESTAMP '2020-05-04 00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("TIMESTAMP '2020-05-04 00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("TIMESTAMP '2020-05-04 00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("TIMESTAMP '2020-05-04 00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("TIMESTAMP '2020-05-04 00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("TIMESTAMP '2020-05-04 00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("TIMESTAMP '2020-05-04 00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("TIMESTAMP '2020-05-04 00:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("TIMESTAMP '2020-05-04 00:00:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("TIMESTAMP '2020-05-04 00:00:00.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('week', TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("TIMESTAMP '2020-05-04 00:00:00.000000000000'");
    }

    @Test
    public void testDateTruncDay() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56')")))).matches("TIMESTAMP '2020-05-10 00:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("TIMESTAMP '2020-05-10 00:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("TIMESTAMP '2020-05-10 00:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("TIMESTAMP '2020-05-10 00:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("TIMESTAMP '2020-05-10 00:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("TIMESTAMP '2020-05-10 00:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("TIMESTAMP '2020-05-10 00:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("TIMESTAMP '2020-05-10 00:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("TIMESTAMP '2020-05-10 00:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("TIMESTAMP '2020-05-10 00:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("TIMESTAMP '2020-05-10 00:00:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("TIMESTAMP '2020-05-10 00:00:00.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('day', TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("TIMESTAMP '2020-05-10 00:00:00.000000000000'");
    }

    @Test
    public void testDateTruncHour() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56')")))).matches("TIMESTAMP '2020-05-10 12:00:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("TIMESTAMP '2020-05-10 12:00:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("TIMESTAMP '2020-05-10 12:00:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("TIMESTAMP '2020-05-10 12:00:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("TIMESTAMP '2020-05-10 12:00:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("TIMESTAMP '2020-05-10 12:00:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("TIMESTAMP '2020-05-10 12:00:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("TIMESTAMP '2020-05-10 12:00:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("TIMESTAMP '2020-05-10 12:00:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("TIMESTAMP '2020-05-10 12:00:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("TIMESTAMP '2020-05-10 12:00:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("TIMESTAMP '2020-05-10 12:00:00.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('hour', TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("TIMESTAMP '2020-05-10 12:00:00.000000000000'");
    }

    @Test
    public void testDateTruncMinute() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56')")))).matches("TIMESTAMP '2020-05-10 12:34:00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("TIMESTAMP '2020-05-10 12:34:00.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("TIMESTAMP '2020-05-10 12:34:00.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("TIMESTAMP '2020-05-10 12:34:00.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("TIMESTAMP '2020-05-10 12:34:00.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("TIMESTAMP '2020-05-10 12:34:00.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("TIMESTAMP '2020-05-10 12:34:00.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("TIMESTAMP '2020-05-10 12:34:00.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("TIMESTAMP '2020-05-10 12:34:00.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("TIMESTAMP '2020-05-10 12:34:00.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("TIMESTAMP '2020-05-10 12:34:00.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("TIMESTAMP '2020-05-10 12:34:00.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('minute', TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("TIMESTAMP '2020-05-10 12:34:00.000000000000'");
    }

    @Test
    public void testDateTruncSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56')")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("TIMESTAMP '2020-05-10 12:34:56.0'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("TIMESTAMP '2020-05-10 12:34:56.00'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("TIMESTAMP '2020-05-10 12:34:56.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("TIMESTAMP '2020-05-10 12:34:56.0000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("TIMESTAMP '2020-05-10 12:34:56.00000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("TIMESTAMP '2020-05-10 12:34:56.000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("TIMESTAMP '2020-05-10 12:34:56.0000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("TIMESTAMP '2020-05-10 12:34:56.00000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("TIMESTAMP '2020-05-10 12:34:56.000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("TIMESTAMP '2020-05-10 12:34:56.0000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("TIMESTAMP '2020-05-10 12:34:56.00000000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('second', TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("TIMESTAMP '2020-05-10 12:34:56.000000000000'");
    }

    @Test
    public void testDateTruncMilliSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56')")))).matches("TIMESTAMP '2020-05-10 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.1')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.12')")))).matches("TIMESTAMP '2020-05-10 12:34:56.12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.123')")))).matches("TIMESTAMP '2020-05-10 12:34:56.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.1234')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1230'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.12345')")))).matches("TIMESTAMP '2020-05-10 12:34:56.12300'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.123456')")))).matches("TIMESTAMP '2020-05-10 12:34:56.123000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.1234567')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1230000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.12345678')")))).matches("TIMESTAMP '2020-05-10 12:34:56.12300000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.123456789')")))).matches("TIMESTAMP '2020-05-10 12:34:56.123000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.1234567890')")))).matches("TIMESTAMP '2020-05-10 12:34:56.1230000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.12345678901')")))).matches("TIMESTAMP '2020-05-10 12:34:56.12300000000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("date_trunc('millisecond', TIMESTAMP '2020-05-10 12:34:56.123456789012')")))).matches("TIMESTAMP '2020-05-10 12:34:56.123000000000'");
    }
}

