/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.operator.scalar.AbstractTestFunctions;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import org.testng.annotations.Test;

public class TestHumanReadableSeconds
extends AbstractTestFunctions {
    @Test
    public void testToHumanRedableSecondsFormat() {
        this.assertFunction("human_readable_seconds(0)", (Type)VarcharType.VARCHAR, "0 seconds");
        this.assertFunction("human_readable_seconds(1)", (Type)VarcharType.VARCHAR, "1 second");
        this.assertFunction("human_readable_seconds(60)", (Type)VarcharType.VARCHAR, "1 minute");
        this.assertFunction("human_readable_seconds(-60)", (Type)VarcharType.VARCHAR, "1 minute");
        this.assertFunction("human_readable_seconds(61)", (Type)VarcharType.VARCHAR, "1 minute, 1 second");
        this.assertFunction("human_readable_seconds(-61)", (Type)VarcharType.VARCHAR, "1 minute, 1 second");
        this.assertFunction("human_readable_seconds(535333.9513888889)", (Type)VarcharType.VARCHAR, "6 days, 4 hours, 42 minutes, 14 seconds");
        this.assertFunction("human_readable_seconds(535333.2513888889)", (Type)VarcharType.VARCHAR, "6 days, 4 hours, 42 minutes, 13 seconds");
        this.assertFunction("human_readable_seconds(56363463)", (Type)VarcharType.VARCHAR, "93 weeks, 1 day, 8 hours, 31 minutes, 3 seconds");
        this.assertFunction("human_readable_seconds(3660)", (Type)VarcharType.VARCHAR, "1 hour, 1 minute");
        this.assertFunction("human_readable_seconds(3601)", (Type)VarcharType.VARCHAR, "1 hour, 1 second");
        this.assertFunction("human_readable_seconds(8003)", (Type)VarcharType.VARCHAR, "2 hours, 13 minutes, 23 seconds");
        this.assertFunction("human_readable_seconds(NULL)", (Type)VarcharType.VARCHAR, null);
        this.assertInvalidFunction("human_readable_seconds(0.0E0 / 0.0E0)", "Invalid argument found: NaN");
        this.assertInvalidFunction("human_readable_seconds(1.0E0 / 0.0E0)", "Invalid argument found: Infinity");
    }
}

