/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.unnest;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.block.ArrayBlockBuilder;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Objects;
import org.testng.Assert;

public final class TestingUnnesterUtil {
    private TestingUnnesterUtil() {
    }

    public static Block createSimpleBlock(Slice[] values) {
        BlockBuilder elementBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, values.length);
        for (Slice v : values) {
            if (v == null) {
                elementBlockBuilder.appendNull();
                continue;
            }
            VarcharType.VARCHAR.writeSlice(elementBlockBuilder, v);
        }
        return elementBlockBuilder.build();
    }

    public static Block createArrayBlock(Slice[][] values) {
        ArrayBlockBuilder blockBuilder = new ArrayBlockBuilder((Type)VarcharType.VARCHAR, null, 100, 100);
        for (Slice[] expectedValue : values) {
            if (expectedValue == null) {
                blockBuilder.appendNull();
                continue;
            }
            Block elementBlock = TestingUnnesterUtil.createSimpleBlock(expectedValue);
            blockBuilder.appendStructure(elementBlock);
        }
        return blockBuilder.build();
    }

    public static Block createArrayBlockOfRowBlocks(Slice[][][] elements, RowType rowType) {
        ArrayBlockBuilder arrayBlockBuilder = new ArrayBlockBuilder((Type)rowType, null, 100, 100);
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null) {
                arrayBlockBuilder.appendNull();
                continue;
            }
            Slice[][] expectedValues = elements[i];
            BlockBuilder elementBlockBuilder = rowType.createBlockBuilder(null, elements[i].length);
            for (Slice[] expectedValue : expectedValues) {
                if (expectedValue == null) {
                    elementBlockBuilder.appendNull();
                    continue;
                }
                BlockBuilder entryBuilder = elementBlockBuilder.beginBlockEntry();
                for (Slice v : expectedValue) {
                    if (v == null) {
                        entryBuilder.appendNull();
                        continue;
                    }
                    VarcharType.VARCHAR.writeSlice(entryBuilder, v);
                }
                elementBlockBuilder.closeEntry();
            }
            arrayBlockBuilder.appendStructure(elementBlockBuilder.build());
        }
        return arrayBlockBuilder.build();
    }

    public static boolean nullExists(Slice[][] elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null) continue;
            for (int j = 0; j < elements[i].length; ++j) {
                if (elements[i][j] != null) continue;
                return true;
            }
        }
        return false;
    }

    public static Slice[] computeExpectedUnnestedOutput(Slice[][] elements, int[] requiredOutputCounts, int startPosition, int length) {
        Preconditions.checkArgument((startPosition >= 0 && length >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((startPosition + length - 1 < requiredOutputCounts.length ? 1 : 0) != 0);
        Preconditions.checkArgument((elements.length == requiredOutputCounts.length ? 1 : 0) != 0);
        int outputCount = 0;
        for (int i = 0; i < length; ++i) {
            int position = startPosition + i;
            int arrayLength = elements[position] == null ? 0 : elements[position].length;
            Preconditions.checkArgument((requiredOutputCounts[position] >= arrayLength ? 1 : 0) != 0);
            outputCount += requiredOutputCounts[position];
        }
        Slice[] expectedOutput = new Slice[outputCount];
        int offset = 0;
        for (int i = 0; i < length; ++i) {
            int j;
            int position = startPosition + i;
            int arrayLength = elements[position] == null ? 0 : elements[position].length;
            int requiredCount = requiredOutputCounts[position];
            for (j = 0; j < arrayLength; ++j) {
                expectedOutput[offset++] = elements[position][j];
            }
            for (j = 0; j < requiredCount - arrayLength; ++j) {
                expectedOutput[offset++] = null;
            }
        }
        return expectedOutput;
    }

    public static Slice[][] getFieldElements(Slice[][][] slices, int fieldNo) {
        Slice[][] output = new Slice[slices.length][];
        for (int i = 0; i < slices.length; ++i) {
            if (slices[i] != null) {
                output[i] = new Slice[slices[i].length];
                for (int j = 0; j < slices[i].length; ++j) {
                    output[i][j] = slices[i][j] != null ? slices[i][j][fieldNo] : null;
                }
                continue;
            }
            output[i] = null;
        }
        return output;
    }

    public static void validateTestInput(int[] requiredOutputCounts, int[] unnestedLengths, Slice[][][] slices, int fieldCount) {
        Objects.requireNonNull(requiredOutputCounts, "output counts array is null");
        Objects.requireNonNull(unnestedLengths, "unnested lengths is null");
        Objects.requireNonNull(slices, "slices array is null");
        int positionCount = slices.length;
        Assert.assertEquals((int)requiredOutputCounts.length, (int)positionCount);
        Assert.assertEquals((int)unnestedLengths.length, (int)positionCount);
        for (int i = 0; i < requiredOutputCounts.length; ++i) {
            Assert.assertTrue((unnestedLengths[i] <= requiredOutputCounts[i] ? 1 : 0) != 0);
        }
        for (int index = 0; index < positionCount; ++index) {
            Slice[][] entry = slices[index];
            int entryLength = entry != null ? entry.length : 0;
            Assert.assertEquals((int)entryLength, (int)unnestedLengths[index]);
            for (int i = 0; i < entryLength; ++i) {
                if (entry[i] == null) continue;
                Assert.assertEquals((int)entry[i].length, (int)fieldCount);
            }
        }
    }

    public static Slice[] createReplicatedOutputSlice(Slice[] input, int[] counts) {
        Assert.assertEquals((int)input.length, (int)counts.length);
        int outputLength = 0;
        for (int i = 0; i < input.length; ++i) {
            outputLength += counts[i];
        }
        Slice[] output = new Slice[outputLength];
        int offset = 0;
        for (int i = 0; i < input.length; ++i) {
            for (int j = 0; j < counts[i]; ++j) {
                output[offset++] = input[i];
            }
        }
        return output;
    }

    static Slice[][][] column(Slice[][] ... arraysOfRow) {
        return arraysOfRow;
    }

    static Slice[][] array(Slice[] ... rows) {
        return rows;
    }

    static Slice[] toSlices(String ... values) {
        Slice[] slices = new Slice[values.length];
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            slices[i] = Slices.utf8Slice((String)values[i]);
        }
        return slices;
    }
}

