/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.security;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.eventlistener.EventListenerManager;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.plugin.base.security.FileBasedSystemAccessControl;
import io.prestosql.security.AccessControl;
import io.prestosql.security.AccessControlConfig;
import io.prestosql.security.AccessControlManager;
import io.prestosql.security.SecurityContext;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.PrincipalType;
import io.prestosql.spi.security.Privilege;
import io.prestosql.testing.TestingEventListenerManager;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionBuilder;
import io.prestosql.transaction.TransactionManager;
import java.io.File;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Files;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestFileBasedSystemAccessControl {
    private static final Identity alice = Identity.forUser((String)"alice").withGroups((Set)ImmutableSet.of((Object)"staff")).build();
    private static final Identity kerberosValidAlice = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("alice/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosValidNonAsciiUser = Identity.forUser((String)"\u0194\u0194\u0194").withPrincipal((Principal)new KerberosPrincipal("\u0194\u0194\u0194/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosInvalidAlice = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("mallory/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosValidShare = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("valid/example.com@EXAMPLE.COM")).build();
    private static final Identity kerberosInValidShare = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("invalid/example.com@EXAMPLE.COM")).build();
    private static final Identity validSpecialRegexWildDot = Identity.forUser((String)".*").withPrincipal((Principal)new KerberosPrincipal("special/.*@EXAMPLE.COM")).build();
    private static final Identity validSpecialRegexEndQuote = Identity.forUser((String)"\\E").withPrincipal((Principal)new KerberosPrincipal("special/\\E@EXAMPLE.COM")).build();
    private static final Identity invalidSpecialRegex = Identity.forUser((String)"alice").withPrincipal((Principal)new KerberosPrincipal("special/.*@EXAMPLE.COM")).build();
    private static final Identity bob = Identity.forUser((String)"bob").withGroups((Set)ImmutableSet.of((Object)"staff")).build();
    private static final Identity admin = Identity.forUser((String)"admin").withGroups((Set)ImmutableSet.of((Object)"admin")).build();
    private static final Identity nonAsciiUser = Identity.forUser((String)"\u0194\u0194\u0194").withGroups((Set)ImmutableSet.of((Object)"\u0194\u0194\u0194")).build();
    private static final Set<String> allCatalogs = ImmutableSet.of((Object)"secret", (Object)"open-to-all", (Object)"all-allowed", (Object)"alice-catalog", (Object)"\u0200\u0200\u0200", (Object)"staff-catalog", (Object[])new String[0]);
    private static final QualifiedObjectName aliceTable = new QualifiedObjectName("alice-catalog", "schema", "table");
    private static final QualifiedObjectName aliceView = new QualifiedObjectName("alice-catalog", "schema", "view");
    private static final CatalogSchemaName aliceSchema = new CatalogSchemaName("alice-catalog", "schema");
    private static final QualifiedObjectName staffTable = new QualifiedObjectName("staff-catalog", "schema2", "table");
    private static final QualifiedObjectName staffView = new QualifiedObjectName("staff-catalog", "schema2", "view");
    private static final QueryId queryId = new QueryId("query_id");

    @Test
    public void testCanImpersonateUserOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_impersonation.json");
        accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"alice"), "bob");
        accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"alice"), "charlie");
        try {
            accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"alice"), "admin");
            throw new AssertionError((Object)"expected AccessDeniedException");
        }
        catch (AccessDeniedException accessDeniedException) {
            accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"admin"), "alice");
            accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"admin"), "bob");
            accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"admin"), "anything");
            accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"admin-other"), "anything");
            try {
                accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"admin-test"), "alice");
                throw new AssertionError((Object)"expected AccessDeniedException");
            }
            catch (AccessDeniedException accessDeniedException2) {
                try {
                    accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"invalid"), "alice");
                    throw new AssertionError((Object)"expected AccessDeniedException");
                }
                catch (AccessDeniedException accessDeniedException3) {
                    accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"anything"), "test");
                    try {
                        accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"invalid-other"), "test");
                        throw new AssertionError((Object)"expected AccessDeniedException");
                    }
                    catch (AccessDeniedException accessDeniedException4) {
                        accessControlManager = this.newAccessControlManager(transactionManager, "catalog_principal.json");
                        accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"anything"), "anythingElse");
                        return;
                    }
                }
            }
        }
    }

    @Test
    public void testDocsExample() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig());
        accessControlManager.setSystemAccessControl("file", (Map)ImmutableMap.of((Object)"security.config-file", (Object)new File("../presto-docs/src/main/sphinx/security/user-impersonation.json").getAbsolutePath()));
        accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"alice"), "charlie");
        accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"bob"), "charlie");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"alice"), "bob")).isInstanceOf(AccessDeniedException.class)).hasMessageContaining("Access Denied: User alice cannot impersonate user bob");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"bob"), "alice")).isInstanceOf(AccessDeniedException.class)).hasMessageContaining("Access Denied: User bob cannot impersonate user alice");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"charlie"), "doris")).isInstanceOf(AccessDeniedException.class)).hasMessageContaining("Access Denied: User charlie cannot impersonate user doris");
        accessControlManager.checkCanImpersonateUser(Identity.ofUser((String)"charlie"), "test");
    }

    @Test
    public void testCanSetUserOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_principal.json");
        try {
            accessControlManager.checkCanSetUser(Optional.empty(), alice.getUser());
            throw new AssertionError((Object)"expected AccessDeniedExeption");
        }
        catch (AccessDeniedException accessDeniedException) {
            accessControlManager.checkCanSetUser(kerberosValidAlice.getPrincipal(), kerberosValidAlice.getUser());
            accessControlManager.checkCanSetUser(kerberosValidNonAsciiUser.getPrincipal(), kerberosValidNonAsciiUser.getUser());
            try {
                accessControlManager.checkCanSetUser(kerberosInvalidAlice.getPrincipal(), kerberosInvalidAlice.getUser());
                throw new AssertionError((Object)"expected AccessDeniedExeption");
            }
            catch (AccessDeniedException accessDeniedException2) {
                accessControlManager.checkCanSetUser(kerberosValidShare.getPrincipal(), kerberosValidShare.getUser());
                try {
                    accessControlManager.checkCanSetUser(kerberosInValidShare.getPrincipal(), kerberosInValidShare.getUser());
                    throw new AssertionError((Object)"expected AccessDeniedExeption");
                }
                catch (AccessDeniedException accessDeniedException3) {
                    accessControlManager.checkCanSetUser(validSpecialRegexWildDot.getPrincipal(), validSpecialRegexWildDot.getUser());
                    accessControlManager.checkCanSetUser(validSpecialRegexEndQuote.getPrincipal(), validSpecialRegexEndQuote.getUser());
                    try {
                        accessControlManager.checkCanSetUser(invalidSpecialRegex.getPrincipal(), invalidSpecialRegex.getUser());
                        throw new AssertionError((Object)"expected AccessDeniedExeption");
                    }
                    catch (AccessDeniedException accessDeniedException4) {
                        AccessControlManager accessControlManagerNoPatterns = this.newAccessControlManager(transactionManager, "catalog.json");
                        accessControlManagerNoPatterns.checkCanSetUser(kerberosValidAlice.getPrincipal(), kerberosValidAlice.getUser());
                        return;
                    }
                }
            }
        }
    }

    @Test
    public void testSystemInformation() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "system_information.json");
        accessControlManager.checkCanReadSystemInformation(admin);
        accessControlManager.checkCanWriteSystemInformation(admin);
        accessControlManager.checkCanReadSystemInformation(nonAsciiUser);
        accessControlManager.checkCanWriteSystemInformation(nonAsciiUser);
        accessControlManager.checkCanReadSystemInformation(admin);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanWriteSystemInformation(alice))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot write system information");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanReadSystemInformation(bob))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot read system information");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanWriteSystemInformation(bob))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot write system information");
    }

    @Test
    public void testCatalogOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(admin, allCatalogs), allCatalogs);
            ImmutableSet aliceCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"alice-catalog", (Object)"all-allowed", (Object)"staff-catalog");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(alice, allCatalogs), (Set)aliceCatalogs);
            ImmutableSet bobCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"all-allowed", (Object)"staff-catalog");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(bob, allCatalogs), (Set)bobCatalogs);
            ImmutableSet nonAsciiUserCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"all-allowed", (Object)"\u0200\u0200\u0200");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(nonAsciiUser, allCatalogs), (Set)nonAsciiUserCatalogs);
        });
    }

    @Test
    public void testCatalogOperationsReadOnly() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_read_only.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(admin, allCatalogs), allCatalogs);
            ImmutableSet aliceCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"alice-catalog", (Object)"all-allowed");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(alice, allCatalogs), (Set)aliceCatalogs);
            ImmutableSet bobCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"all-allowed");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(bob, allCatalogs), (Set)bobCatalogs);
            ImmutableSet nonAsciiUserCatalogs = ImmutableSet.of((Object)"open-to-all", (Object)"all-allowed", (Object)"\u0200\u0200\u0200");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(nonAsciiUser, allCatalogs), (Set)nonAsciiUserCatalogs);
        });
    }

    @Test
    public void testSchemaOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            ImmutableSet aliceSchemas = ImmutableSet.of((Object)"schema");
            Assert.assertEquals((Set)accessControlManager.filterSchemas(new SecurityContext(transactionId, alice, queryId), "alice-catalog", (Set)aliceSchemas), (Set)aliceSchemas);
            Assert.assertEquals((Set)accessControlManager.filterSchemas(new SecurityContext(transactionId, bob, queryId), "alice-catalog", (Set)aliceSchemas), (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateSchema(new SecurityContext(transactionId, alice, queryId), aliceSchema);
            accessControlManager.checkCanDropSchema(new SecurityContext(transactionId, alice, queryId), aliceSchema);
            accessControlManager.checkCanRenameSchema(new SecurityContext(transactionId, alice, queryId), aliceSchema, "new-schema");
            accessControlManager.checkCanShowSchemas(new SecurityContext(transactionId, alice, queryId), "alice-catalog");
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(new SecurityContext(transactionId, bob, queryId), aliceSchema))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
    }

    @Test
    public void testSchemaOperationsReadOnly() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_read_only.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            ImmutableSet aliceSchemas = ImmutableSet.of((Object)"schema");
            Assert.assertEquals((Set)accessControlManager.filterSchemas(new SecurityContext(transactionId, alice, queryId), "alice-catalog", (Set)aliceSchemas), (Set)aliceSchemas);
            Assert.assertEquals((Set)accessControlManager.filterSchemas(new SecurityContext(transactionId, bob, queryId), "alice-catalog", (Set)aliceSchemas), (Set)ImmutableSet.of());
            accessControlManager.checkCanShowSchemas(new SecurityContext(transactionId, alice, queryId), "alice-catalog");
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(new SecurityContext(transactionId, alice, queryId), aliceSchema))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot create schema alice-catalog.schema");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropSchema(new SecurityContext(transactionId, alice, queryId), aliceSchema))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot drop schema alice-catalog.schema");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRenameSchema(new SecurityContext(transactionId, alice, queryId), aliceSchema, "new-schema"))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot rename schema from alice-catalog.schema to new-schema");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateSchema(new SecurityContext(transactionId, bob, queryId), aliceSchema))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
    }

    @Test
    public void testTableOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            ImmutableSet aliceTables = ImmutableSet.of((Object)new SchemaTableName("schema", "table"));
            SecurityContext aliceContext = new SecurityContext(transactionId, alice, queryId);
            SecurityContext bobContext = new SecurityContext(transactionId, bob, queryId);
            SecurityContext nonAsciiContext = new SecurityContext(transactionId, nonAsciiUser, queryId);
            Assert.assertEquals((Set)accessControlManager.filterTables(aliceContext, "alice-catalog", (Set)aliceTables), (Set)aliceTables);
            Assert.assertEquals((Set)accessControlManager.filterTables(aliceContext, "staff-catalog", (Set)aliceTables), (Set)aliceTables);
            Assert.assertEquals((Set)accessControlManager.filterTables(bobContext, "alice-catalog", (Set)aliceTables), (Set)ImmutableSet.of());
            Assert.assertEquals((Set)accessControlManager.filterTables(bobContext, "staff-catalog", (Set)aliceTables), (Set)aliceTables);
            Assert.assertEquals((Set)accessControlManager.filterTables(nonAsciiContext, "alice-catalog", (Set)aliceTables), (Set)ImmutableSet.of());
            Assert.assertEquals((Set)accessControlManager.filterTables(nonAsciiContext, "staff-catalog", (Set)aliceTables), (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateTable(aliceContext, aliceTable);
            accessControlManager.checkCanDropTable(aliceContext, aliceTable);
            accessControlManager.checkCanSelectFromColumns(aliceContext, aliceTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(aliceContext, aliceTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanInsertIntoTable(aliceContext, aliceTable);
            accessControlManager.checkCanDeleteFromTable(aliceContext, aliceTable);
            accessControlManager.checkCanAddColumns(aliceContext, aliceTable);
            accessControlManager.checkCanRenameColumn(aliceContext, aliceTable);
            accessControlManager.checkCanCreateTable(aliceContext, staffTable);
            accessControlManager.checkCanDropTable(aliceContext, staffTable);
            accessControlManager.checkCanSelectFromColumns(aliceContext, staffTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(aliceContext, staffTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanInsertIntoTable(aliceContext, staffTable);
            accessControlManager.checkCanDeleteFromTable(aliceContext, staffTable);
            accessControlManager.checkCanAddColumns(aliceContext, staffTable);
            accessControlManager.checkCanRenameColumn(aliceContext, staffTable);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateTable(bobContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDropTable(bobContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSelectFromColumns(bobContext, aliceTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(bobContext, aliceTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanInsertIntoTable(bobContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDeleteFromTable(bobContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanAddColumns(bobContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanRenameColumn(bobContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            accessControlManager.checkCanCreateTable(bobContext, staffTable);
            accessControlManager.checkCanDropTable(bobContext, staffTable);
            accessControlManager.checkCanSelectFromColumns(bobContext, staffTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(bobContext, staffTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanInsertIntoTable(bobContext, staffTable);
            accessControlManager.checkCanDeleteFromTable(bobContext, staffTable);
            accessControlManager.checkCanAddColumns(bobContext, staffTable);
            accessControlManager.checkCanRenameColumn(bobContext, staffTable);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateTable(nonAsciiContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDropTable(nonAsciiContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSelectFromColumns(nonAsciiContext, aliceTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(nonAsciiContext, aliceTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanInsertIntoTable(nonAsciiContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDeleteFromTable(nonAsciiContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanAddColumns(nonAsciiContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanRenameColumn(nonAsciiContext, aliceTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateTable(nonAsciiContext, staffTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDropTable(nonAsciiContext, staffTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSelectFromColumns(nonAsciiContext, staffTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(nonAsciiContext, staffTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanInsertIntoTable(nonAsciiContext, staffTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDeleteFromTable(nonAsciiContext, staffTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanAddColumns(nonAsciiContext, staffTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanRenameColumn(nonAsciiContext, staffTable)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
        });
    }

    @Test
    public void testTableOperationsReadOnly() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_read_only.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            ImmutableSet aliceTables = ImmutableSet.of((Object)new SchemaTableName("schema", "table"));
            Assert.assertEquals((Set)accessControlManager.filterTables(new SecurityContext(transactionId, alice, queryId), "alice-catalog", (Set)aliceTables), (Set)aliceTables);
            Assert.assertEquals((Set)accessControlManager.filterTables(new SecurityContext(transactionId, bob, queryId), "alice-catalog", (Set)aliceTables), (Set)ImmutableSet.of());
            accessControlManager.checkCanSelectFromColumns(new SecurityContext(transactionId, alice, queryId), aliceTable, (Set)ImmutableSet.of());
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateTable(new SecurityContext(transactionId, alice, queryId), aliceTable))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot create table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropTable(new SecurityContext(transactionId, alice, queryId), aliceTable))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot drop table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanInsertIntoTable(new SecurityContext(transactionId, alice, queryId), aliceTable))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot insert into table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDeleteFromTable(new SecurityContext(transactionId, alice, queryId), aliceTable))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot delete from table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanAddColumns(new SecurityContext(transactionId, alice, queryId), aliceTable))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot add a column to table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRenameColumn(new SecurityContext(transactionId, alice, queryId), aliceTable))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot rename a column in table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateTable(new SecurityContext(transactionId, bob, queryId), aliceTable))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
    }

    @Test
    public void testViewOperations() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            SecurityContext aliceContext = new SecurityContext(transactionId, alice, queryId);
            SecurityContext bobContext = new SecurityContext(transactionId, bob, queryId);
            SecurityContext nonAsciiContext = new SecurityContext(transactionId, nonAsciiUser, queryId);
            accessControlManager.checkCanCreateView(aliceContext, aliceView);
            accessControlManager.checkCanDropView(aliceContext, aliceView);
            accessControlManager.checkCanSelectFromColumns(aliceContext, aliceView, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(aliceContext, aliceTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(aliceContext, aliceView, (Set)ImmutableSet.of());
            accessControlManager.checkCanSetCatalogSessionProperty(aliceContext, "alice-catalog", "property");
            accessControlManager.checkCanGrantTablePrivilege(aliceContext, Privilege.SELECT, aliceTable, new PrestoPrincipal(PrincipalType.USER, "grantee"), true);
            accessControlManager.checkCanRevokeTablePrivilege(aliceContext, Privilege.SELECT, aliceTable, new PrestoPrincipal(PrincipalType.USER, "revokee"), true);
            accessControlManager.checkCanCreateView(aliceContext, staffView);
            accessControlManager.checkCanDropView(aliceContext, staffView);
            accessControlManager.checkCanSelectFromColumns(aliceContext, staffView, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(aliceContext, staffTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(aliceContext, staffView, (Set)ImmutableSet.of());
            accessControlManager.checkCanSetCatalogSessionProperty(aliceContext, "alice-catalog", "property");
            accessControlManager.checkCanGrantTablePrivilege(aliceContext, Privilege.SELECT, staffTable, new PrestoPrincipal(PrincipalType.USER, "grantee"), true);
            accessControlManager.checkCanRevokeTablePrivilege(aliceContext, Privilege.SELECT, staffTable, new PrestoPrincipal(PrincipalType.USER, "revokee"), true);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateView(bobContext, aliceView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDropView(bobContext, aliceView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSelectFromColumns(bobContext, aliceView, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(bobContext, aliceTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(bobContext, aliceView, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetCatalogSessionProperty(bobContext, "alice-catalog", "property")).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanGrantTablePrivilege(bobContext, Privilege.SELECT, aliceTable, new PrestoPrincipal(PrincipalType.USER, "grantee"), true)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanRevokeTablePrivilege(bobContext, Privilege.SELECT, aliceTable, new PrestoPrincipal(PrincipalType.USER, "revokee"), true)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            accessControlManager.checkCanCreateView(bobContext, staffView);
            accessControlManager.checkCanDropView(bobContext, staffView);
            accessControlManager.checkCanSelectFromColumns(bobContext, staffView, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(bobContext, staffTable, (Set)ImmutableSet.of());
            accessControlManager.checkCanCreateViewWithSelectFromColumns(bobContext, staffView, (Set)ImmutableSet.of());
            accessControlManager.checkCanSetCatalogSessionProperty(bobContext, "staff-catalog", "property");
            accessControlManager.checkCanGrantTablePrivilege(bobContext, Privilege.SELECT, staffTable, new PrestoPrincipal(PrincipalType.USER, "grantee"), true);
            accessControlManager.checkCanRevokeTablePrivilege(bobContext, Privilege.SELECT, staffTable, new PrestoPrincipal(PrincipalType.USER, "revokee"), true);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateView(nonAsciiContext, aliceView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDropView(nonAsciiContext, aliceView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSelectFromColumns(nonAsciiContext, aliceView, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(nonAsciiContext, aliceTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(nonAsciiContext, aliceView, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetCatalogSessionProperty(nonAsciiContext, "alice-catalog", "property")).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanGrantTablePrivilege(nonAsciiContext, Privilege.SELECT, aliceTable, new PrestoPrincipal(PrincipalType.USER, "grantee"), true)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanRevokeTablePrivilege(nonAsciiContext, Privilege.SELECT, aliceTable, new PrestoPrincipal(PrincipalType.USER, "revokee"), true)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateView(nonAsciiContext, staffView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanDropView(nonAsciiContext, staffView)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSelectFromColumns(nonAsciiContext, staffView, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(nonAsciiContext, staffTable, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanCreateViewWithSelectFromColumns(nonAsciiContext, staffView, (Set)ImmutableSet.of())).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanSetCatalogSessionProperty(nonAsciiContext, "staff-catalog", "property")).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanGrantTablePrivilege(nonAsciiContext, Privilege.SELECT, staffTable, new PrestoPrincipal(PrincipalType.USER, "grantee"), true)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> accessControlManager.checkCanRevokeTablePrivilege(nonAsciiContext, Privilege.SELECT, staffTable, new PrestoPrincipal(PrincipalType.USER, "revokee"), true)).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog staff-catalog");
        });
    }

    @Test
    public void testViewOperationsReadOnly() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = this.newAccessControlManager(transactionManager, "catalog_read_only.json");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            SecurityContext context = new SecurityContext(transactionId, alice, queryId);
            accessControlManager.checkCanSelectFromColumns(context, aliceView, (Set)ImmutableSet.of());
            accessControlManager.checkCanSetCatalogSessionProperty(context, "alice-catalog", "property");
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(new SecurityContext(transactionId, alice, queryId), aliceView))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot create view alice-catalog.schema.view");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanDropView(new SecurityContext(transactionId, alice, queryId), aliceView))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot drop view alice-catalog.schema.view");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanGrantTablePrivilege(new SecurityContext(transactionId, alice, queryId), Privilege.SELECT, aliceTable, new PrestoPrincipal(PrincipalType.USER, "grantee"), true))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot grant privilege SELECT on table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanRevokeTablePrivilege(new SecurityContext(transactionId, alice, queryId), Privilege.SELECT, aliceTable, new PrestoPrincipal(PrincipalType.USER, "revokee"), true))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot revoke privilege SELECT on table alice-catalog.schema.table");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(new SecurityContext(transactionId, bob, queryId), aliceView))).isInstanceOf(AccessDeniedException.class)).hasMessage("Access Denied: Cannot access catalog alice-catalog");
    }

    @Test
    public void testRefreshing() throws Exception {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig());
        File configFile = Files.newTemporaryFile();
        configFile.deleteOnExit();
        com.google.common.io.Files.copy((File)new File(this.getResourcePath("catalog.json")), (File)configFile);
        accessControlManager.setSystemAccessControl("file", (Map)ImmutableMap.of((Object)"security.config-file", (Object)configFile.getAbsolutePath(), (Object)"security.refresh-period", (Object)"1ms"));
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            accessControlManager.checkCanCreateView(new SecurityContext(transactionId, alice, queryId), aliceView);
            accessControlManager.checkCanCreateView(new SecurityContext(transactionId, alice, queryId), aliceView);
            accessControlManager.checkCanCreateView(new SecurityContext(transactionId, alice, queryId), aliceView);
        });
        com.google.common.io.Files.copy((File)new File(this.getResourcePath("security-config-file-with-unknown-rules.json")), (File)configFile);
        Thread.sleep(2L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(new SecurityContext(transactionId, alice, queryId), aliceView))).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Invalid JSON file");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(new SecurityContext(transactionId, alice, queryId), aliceView))).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Invalid JSON file");
        com.google.common.io.Files.copy((File)new File(this.getResourcePath("catalog.json")), (File)configFile);
        Thread.sleep(2L);
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanCreateView(new SecurityContext(transactionId, alice, queryId), aliceView));
    }

    @Test
    public void testAllowModeIsRequired() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.newAccessControlManager(InMemoryTransactionManager.createTestTransactionManager(), "catalog_allow_unset.json")).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Invalid JSON file");
    }

    @Test
    public void testAllowModeInvalidValue() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.newAccessControlManager(InMemoryTransactionManager.createTestTransactionManager(), "catalog_invalid_allow_value.json")).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Invalid JSON file");
    }

    private AccessControlManager newAccessControlManager(TransactionManager transactionManager, String resourceName) {
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig());
        accessControlManager.setSystemAccessControl("file", (Map)ImmutableMap.of((Object)"security.config-file", (Object)this.getResourcePath(resourceName)));
        return accessControlManager;
    }

    private String getResourcePath(String resourceName) {
        return this.getClass().getClassLoader().getResource(resourceName).getPath();
    }

    @Test
    public void parseUnknownRules() {
        Assertions.assertThatThrownBy(() -> this.parse("src/test/resources/security-config-file-with-unknown-rules.json")).hasMessageContaining("Invalid JSON");
    }

    private void parse(String path) {
        new FileBasedSystemAccessControl.Factory().create((Map)ImmutableMap.of((Object)"security.config-file", (Object)path));
    }
}

