/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.prestosql.Session;
import io.prestosql.cost.StatsAndCosts;
import io.prestosql.execution.StageId;
import io.prestosql.execution.TaskId;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.TableHandle;
import io.prestosql.operator.StageExecutionDescriptor;
import io.prestosql.server.DynamicFilterService;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.connector.DynamicFilter;
import io.prestosql.spi.connector.TestingColumnHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.analyzer.TypeSignatureTranslator;
import io.prestosql.sql.planner.Partitioning;
import io.prestosql.sql.planner.PartitioningHandle;
import io.prestosql.sql.planner.PartitioningScheme;
import io.prestosql.sql.planner.PlanFragment;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.SystemPartitioningHandle;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.FilterNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.PlanFragmentId;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.planner.plan.RemoteSourceNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.testing.TestingHandles;
import io.prestosql.testing.TestingMetadata;
import io.prestosql.testing.TestingSession;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDynamicFilterService {
    private final Metadata metadata = MetadataManager.createTestMetadataManager();
    private final TypeOperators typeOperators = new TypeOperators();
    private static final Session session = TestingSession.testSessionBuilder().build();

    @Test
    public void testDynamicFilterSummaryCompletion() {
        DynamicFilterService dynamicFilterService = new DynamicFilterService(this.metadata, this.typeOperators, (ExecutorService)MoreExecutors.newDirectExecutorService());
        DynamicFilterId filterId = new DynamicFilterId("df");
        QueryId queryId = new QueryId("query");
        StageId stageId = new StageId(queryId, 0);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId), (Set)ImmutableSet.of((Object)filterId), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId, 3);
        Assert.assertFalse((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent());
        DynamicFilterService.DynamicFiltersStats stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assert.assertEquals((int)stats.getTotalDynamicFilters(), (int)1);
        Assert.assertEquals((int)stats.getDynamicFiltersCompleted(), (int)0);
        Assert.assertEquals((int)stats.getLazyDynamicFilters(), (int)1);
        Assert.assertEquals((int)stats.getReplicatedDynamicFilters(), (int)0);
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 0), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
        Assert.assertFalse((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent());
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assert.assertEquals((int)stats.getDynamicFiltersCompleted(), (int)0);
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 1), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L)));
        Assert.assertFalse((boolean)dynamicFilterService.getSummary(queryId, filterId).isPresent());
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assert.assertEquals((int)stats.getDynamicFiltersCompleted(), (int)0);
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 2), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)3L)));
        Optional summary = dynamicFilterService.getSummary(queryId, filterId);
        Assert.assertTrue((boolean)summary.isPresent());
        Assert.assertEquals(summary.get(), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)));
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assert.assertEquals((int)stats.getDynamicFiltersCompleted(), (int)1);
        Assert.assertEquals((int)stats.getLazyDynamicFilters(), (int)1);
        Assert.assertEquals((int)stats.getReplicatedDynamicFilters(), (int)0);
        Assert.assertEquals((Collection)stats.getDynamicFilterDomainStats(), (Collection)ImmutableList.of((Object)new DynamicFilterService.DynamicFilterDomainStats(filterId, TestDynamicFilterService.getExpectedDomainString(1L, 3L), 3, 0)));
    }

    @Test
    public void testDynamicFilter() {
        DynamicFilterService dynamicFilterService = new DynamicFilterService(this.metadata, this.typeOperators, (ExecutorService)MoreExecutors.newDirectExecutorService());
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        DynamicFilterId filterId2 = new DynamicFilterId("df2");
        DynamicFilterId filterId3 = new DynamicFilterId("df3");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)IntegerType.INTEGER);
        Symbol symbol2 = symbolAllocator.newSymbol("DF_SYMBOL2", (Type)IntegerType.INTEGER);
        Symbol symbol3 = symbolAllocator.newSymbol("DF_SYMBOL3", (Type)IntegerType.INTEGER);
        SymbolReference df1 = symbol1.toSymbolReference();
        SymbolReference df2 = symbol2.toSymbolReference();
        SymbolReference df3 = symbol3.toSymbolReference();
        QueryId queryId = new QueryId("query");
        StageId stageId1 = new StageId(queryId, 1);
        StageId stageId2 = new StageId(queryId, 2);
        StageId stageId3 = new StageId(queryId, 3);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId1, (Object)filterId2, (Object)filterId3), (Set)ImmutableSet.of((Object)filterId1, (Object)filterId2, (Object)filterId3), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId1, 2);
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId2, 2);
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId3, 2);
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)df1), (Object)new DynamicFilters.Descriptor(filterId2, (Expression)df2), (Object)new DynamicFilters.Descriptor(filterId3, (Expression)df3)), (Map)ImmutableMap.of((Object)symbol1, (Object)new TestingColumnHandle("probeColumnA"), (Object)symbol2, (Object)new TestingColumnHandle("probeColumnA"), (Object)symbol3, (Object)new TestingColumnHandle("probeColumnB")), symbolAllocator.getTypes());
        Assert.assertTrue((boolean)dynamicFilter.getCurrentPredicate().isAll());
        Assert.assertFalse((boolean)dynamicFilter.isComplete());
        Assert.assertTrue((boolean)dynamicFilter.isAwaitable());
        DynamicFilterService.DynamicFiltersStats stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assert.assertEquals((int)stats.getTotalDynamicFilters(), (int)3);
        Assert.assertEquals((int)stats.getDynamicFiltersCompleted(), (int)0);
        Assert.assertEquals((int)stats.getLazyDynamicFilters(), (int)3);
        Assert.assertEquals((int)stats.getReplicatedDynamicFilters(), (int)0);
        CompletableFuture blockedFuture = dynamicFilter.isBlocked();
        Assert.assertFalse((boolean)blockedFuture.isDone());
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId1, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
        Assert.assertTrue((boolean)dynamicFilter.getCurrentPredicate().isAll());
        Assert.assertFalse((boolean)dynamicFilter.isComplete());
        Assert.assertTrue((boolean)dynamicFilter.isAwaitable());
        Assert.assertFalse((boolean)blockedFuture.isDone());
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId1, 1), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L)));
        Assert.assertEquals((Object)dynamicFilter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)2L)))));
        Assert.assertTrue((boolean)blockedFuture.isDone());
        Assert.assertFalse((boolean)blockedFuture.isCompletedExceptionally());
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assert.assertEquals((int)stats.getDynamicFiltersCompleted(), (int)1);
        Assert.assertFalse((boolean)dynamicFilter.isComplete());
        Assert.assertTrue((boolean)dynamicFilter.isAwaitable());
        blockedFuture = dynamicFilter.isBlocked();
        Assert.assertFalse((boolean)blockedFuture.isDone());
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId2, 0), (Map)ImmutableMap.of((Object)filterId2, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L)));
        Assert.assertEquals((Object)dynamicFilter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)2L)))));
        Assert.assertFalse((boolean)dynamicFilter.isComplete());
        Assert.assertTrue((boolean)dynamicFilter.isAwaitable());
        Assert.assertFalse((boolean)blockedFuture.isDone());
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assert.assertEquals((int)stats.getDynamicFiltersCompleted(), (int)1);
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId2, 1), (Map)ImmutableMap.of((Object)filterId2, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)3L)));
        Assert.assertEquals((Object)dynamicFilter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L))));
        Assert.assertTrue((boolean)blockedFuture.isDone());
        Assert.assertFalse((boolean)blockedFuture.isCompletedExceptionally());
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assert.assertEquals((int)stats.getDynamicFiltersCompleted(), (int)2);
        Assert.assertFalse((boolean)dynamicFilter.isComplete());
        Assert.assertTrue((boolean)dynamicFilter.isAwaitable());
        blockedFuture = dynamicFilter.isBlocked();
        Assert.assertFalse((boolean)blockedFuture.isDone());
        DynamicFilter dynamicFilterColumnA = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)df1), (Object)new DynamicFilters.Descriptor(filterId2, (Expression)df2)), (Map)ImmutableMap.of((Object)symbol1, (Object)new TestingColumnHandle("probeColumnA"), (Object)symbol2, (Object)new TestingColumnHandle("probeColumnA")), symbolAllocator.getTypes());
        Assert.assertTrue((boolean)dynamicFilterColumnA.isComplete());
        Assert.assertFalse((boolean)dynamicFilterColumnA.isAwaitable());
        Assert.assertTrue((boolean)dynamicFilterColumnA.isBlocked().isDone());
        Assert.assertEquals((Object)dynamicFilterColumnA.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L))));
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId3, 0), (Map)ImmutableMap.of((Object)filterId3, (Object)Domain.none((Type)IntegerType.INTEGER)));
        Assert.assertEquals((Object)dynamicFilter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L))));
        Assert.assertFalse((boolean)dynamicFilter.isComplete());
        Assert.assertTrue((boolean)dynamicFilter.isAwaitable());
        Assert.assertFalse((boolean)blockedFuture.isDone());
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assert.assertEquals((int)stats.getDynamicFiltersCompleted(), (int)2);
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId3, 1), (Map)ImmutableMap.of((Object)filterId3, (Object)Domain.none((Type)IntegerType.INTEGER)));
        Assert.assertEquals((Object)dynamicFilter.getCurrentPredicate(), (Object)TupleDomain.none());
        Assert.assertTrue((boolean)blockedFuture.isDone());
        Assert.assertFalse((boolean)blockedFuture.isCompletedExceptionally());
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assert.assertEquals((int)stats.getDynamicFiltersCompleted(), (int)3);
        Assert.assertEquals((int)stats.getLazyDynamicFilters(), (int)3);
        Assert.assertEquals((int)stats.getReplicatedDynamicFilters(), (int)0);
        Assert.assertEquals((Set)ImmutableSet.copyOf((Collection)stats.getDynamicFilterDomainStats()), (Set)ImmutableSet.of((Object)new DynamicFilterService.DynamicFilterDomainStats(filterId1, TestDynamicFilterService.getExpectedDomainString(1L, 2L), 2, 0), (Object)new DynamicFilterService.DynamicFilterDomainStats(filterId2, TestDynamicFilterService.getExpectedDomainString(2L, 3L), 2, 0), (Object)new DynamicFilterService.DynamicFilterDomainStats(filterId3, Domain.none((Type)IntegerType.INTEGER).toString(session.toConnectorSession()), 0, 0)));
        Assert.assertTrue((boolean)dynamicFilter.isComplete());
        Assert.assertFalse((boolean)dynamicFilter.isAwaitable());
        Assert.assertTrue((boolean)dynamicFilter.isBlocked().isDone());
    }

    @Test
    public void testShortCircuitOnAllTupleDomain() {
        DynamicFilterService dynamicFilterService = new DynamicFilterService(this.metadata, this.typeOperators, (ExecutorService)MoreExecutors.newDirectExecutorService());
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)IntegerType.INTEGER);
        SymbolReference df1 = symbol1.toSymbolReference();
        QueryId queryId = new QueryId("query");
        StageId stageId1 = new StageId(queryId, 1);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId1, 2);
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)df1)), (Map)ImmutableMap.of((Object)symbol1, (Object)new TestingColumnHandle("probeColumnA")), symbolAllocator.getTypes());
        Assert.assertTrue((boolean)dynamicFilter.getCurrentPredicate().isAll());
        Assert.assertFalse((boolean)dynamicFilter.isComplete());
        Assert.assertFalse((boolean)dynamicFilter.isBlocked().isDone());
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId1, 1), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.all((Type)IntegerType.INTEGER)));
        Assert.assertTrue((boolean)dynamicFilter.getCurrentPredicate().isAll());
        Assert.assertTrue((boolean)dynamicFilter.isComplete());
        Assert.assertTrue((boolean)dynamicFilter.isBlocked().isDone());
    }

    @Test
    public void testDynamicFilterCoercion() {
        DynamicFilterService dynamicFilterService = new DynamicFilterService(this.metadata, this.typeOperators, (ExecutorService)MoreExecutors.newDirectExecutorService());
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)IntegerType.INTEGER);
        Cast df1 = new Cast((Expression)symbol1.toSymbolReference(), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT));
        QueryId queryId = new QueryId("query");
        StageId stageId1 = new StageId(queryId, 1);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId1, 1);
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)df1)), (Map)ImmutableMap.of((Object)symbol1, (Object)new TestingColumnHandle("probeColumnA")), symbolAllocator.getTypes());
        Assert.assertFalse((boolean)dynamicFilter.isComplete());
        Assert.assertTrue((boolean)dynamicFilter.getCurrentPredicate().isAll());
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId1, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L))));
        Assert.assertTrue((boolean)dynamicFilter.isComplete());
        Assert.assertEquals((Object)dynamicFilter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))));
    }

    @Test
    public void testReplicatedDynamicFilter() {
        DynamicFilterService dynamicFilterService = new DynamicFilterService(this.metadata, this.typeOperators, (ExecutorService)MoreExecutors.newDirectExecutorService());
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)IntegerType.INTEGER);
        SymbolReference df1 = symbol1.toSymbolReference();
        QueryId queryId = new QueryId("query");
        StageId stageId1 = new StageId(queryId, 1);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)filterId1));
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)df1)), (Map)ImmutableMap.of((Object)symbol1, (Object)new TestingColumnHandle("probeColumnA")), symbolAllocator.getTypes());
        Assert.assertTrue((boolean)dynamicFilter.getCurrentPredicate().isAll());
        DynamicFilterService.DynamicFiltersStats stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assert.assertEquals((int)stats.getTotalDynamicFilters(), (int)1);
        Assert.assertEquals((int)stats.getDynamicFiltersCompleted(), (int)0);
        Assert.assertEquals((int)stats.getReplicatedDynamicFilters(), (int)1);
        Assert.assertEquals((int)stats.getLazyDynamicFilters(), (int)0);
        Assert.assertFalse((boolean)dynamicFilter.isComplete());
        Assert.assertFalse((boolean)dynamicFilter.isAwaitable());
        Assert.assertTrue((boolean)dynamicFilter.isBlocked().isDone());
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId1, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
        Assert.assertEquals((Object)dynamicFilter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L))));
        Assert.assertTrue((boolean)dynamicFilter.isComplete());
        Assert.assertFalse((boolean)dynamicFilter.isAwaitable());
        stats = dynamicFilterService.getDynamicFilteringStats(queryId, session);
        Assert.assertEquals((int)stats.getTotalDynamicFilters(), (int)1);
        Assert.assertEquals((int)stats.getDynamicFiltersCompleted(), (int)1);
        Assert.assertEquals((int)stats.getReplicatedDynamicFilters(), (int)1);
        Assert.assertEquals((int)stats.getLazyDynamicFilters(), (int)0);
        Assert.assertEquals((Collection)stats.getDynamicFilterDomainStats(), (Collection)ImmutableList.of((Object)new DynamicFilterService.DynamicFilterDomainStats(filterId1, Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L).toString(session.toConnectorSession()), 1, 0)));
    }

    @Test
    public void testStageCannotScheduleMoreTasks() {
        DynamicFilterService dynamicFilterService = new DynamicFilterService(this.metadata, this.typeOperators, (ExecutorService)MoreExecutors.newDirectExecutorService());
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)IntegerType.INTEGER);
        SymbolReference df1 = symbol1.toSymbolReference();
        QueryId queryId = new QueryId("query");
        StageId stageId1 = new StageId(queryId, 1);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of());
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)df1)), (Map)ImmutableMap.of((Object)symbol1, (Object)new TestingColumnHandle("probeColumnA")), symbolAllocator.getTypes());
        Assert.assertTrue((boolean)dynamicFilter.getCurrentPredicate().isAll());
        Assert.assertFalse((boolean)dynamicFilter.isComplete());
        CompletableFuture blockedFuture = dynamicFilter.isBlocked();
        Assert.assertFalse((boolean)blockedFuture.isDone());
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId1, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
        Assert.assertTrue((boolean)dynamicFilter.getCurrentPredicate().isAll());
        Assert.assertFalse((boolean)dynamicFilter.isComplete());
        Assert.assertFalse((boolean)blockedFuture.isDone());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId1, 1);
        Assert.assertEquals((Object)dynamicFilter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("probeColumnA"), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L))));
        Assert.assertTrue((boolean)dynamicFilter.isComplete());
        Assert.assertTrue((boolean)blockedFuture.isDone());
        Assert.assertFalse((boolean)blockedFuture.isCompletedExceptionally());
    }

    @Test
    public void testDynamicFilterCancellation() {
        DynamicFilterService dynamicFilterService = new DynamicFilterService(this.metadata, this.typeOperators, (ExecutorService)MoreExecutors.newDirectExecutorService());
        DynamicFilterId filterId = new DynamicFilterId("df");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)IntegerType.INTEGER);
        SymbolReference df1 = symbol1.toSymbolReference();
        QueryId queryId = new QueryId("query");
        StageId stageId = new StageId(queryId, 0);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId), (Set)ImmutableSet.of((Object)filterId), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId, 2);
        TestingColumnHandle column = new TestingColumnHandle("probeColumnA");
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId, (Expression)df1)), (Map)ImmutableMap.of((Object)symbol1, (Object)column), symbolAllocator.getTypes());
        Assert.assertFalse((boolean)dynamicFilter.isBlocked().isDone());
        Assert.assertFalse((boolean)dynamicFilter.isComplete());
        Assert.assertEquals((Object)dynamicFilter.getCurrentPredicate(), (Object)TupleDomain.all());
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 0), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L)));
        Assert.assertEquals((Object)dynamicFilter.getCurrentPredicate(), (Object)TupleDomain.all());
        CompletableFuture isBlocked = dynamicFilter.isBlocked();
        Assert.assertFalse((boolean)isBlocked.isDone());
        Assert.assertFalse((boolean)isBlocked.cancel(false));
        Assert.assertFalse((boolean)dynamicFilter.isBlocked().isDone());
        Assert.assertFalse((boolean)dynamicFilter.isComplete());
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId, 1), (Map)ImmutableMap.of((Object)filterId, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L)));
        Assert.assertTrue((boolean)isBlocked.isDone());
        Assert.assertTrue((boolean)dynamicFilter.isComplete());
        Assert.assertEquals((Object)dynamicFilter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.multipleValues((Type)IntegerType.INTEGER, (List)ImmutableList.of((Object)1L, (Object)2L)))));
    }

    @Test
    public void testIsAwaitable() {
        DynamicFilterService dynamicFilterService = new DynamicFilterService(this.metadata, this.typeOperators, (ExecutorService)MoreExecutors.newDirectExecutorService());
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        DynamicFilterId filterId2 = new DynamicFilterId("df2");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol = symbolAllocator.newSymbol("symbol", (Type)IntegerType.INTEGER);
        TestingColumnHandle handle = new TestingColumnHandle("probeColumnA");
        QueryId queryId = new QueryId("query");
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId1, (Object)filterId2), (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of());
        DynamicFilter dynamicFilter1 = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)symbol.toSymbolReference())), (Map)ImmutableMap.of((Object)symbol, (Object)handle), symbolAllocator.getTypes());
        DynamicFilter dynamicFilter2 = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId2, (Expression)symbol.toSymbolReference())), (Map)ImmutableMap.of((Object)symbol, (Object)handle), symbolAllocator.getTypes());
        Assert.assertTrue((boolean)dynamicFilter1.isAwaitable());
        Assert.assertFalse((boolean)dynamicFilter2.isAwaitable());
    }

    @Test
    public void testMultipleColumnMapping() {
        DynamicFilterService dynamicFilterService = new DynamicFilterService(this.metadata, this.typeOperators, (ExecutorService)MoreExecutors.newDirectExecutorService());
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)IntegerType.INTEGER);
        Symbol symbol2 = symbolAllocator.newSymbol("DF_SYMBOL2", (Type)IntegerType.INTEGER);
        SymbolReference df1 = symbol1.toSymbolReference();
        SymbolReference df2 = symbol2.toSymbolReference();
        QueryId queryId = new QueryId("query");
        StageId stageId1 = new StageId(queryId, 1);
        dynamicFilterService.registerQuery(queryId, session, (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of((Object)filterId1), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(stageId1, 1);
        TestingColumnHandle column1 = new TestingColumnHandle("probeColumnA");
        TestingColumnHandle column2 = new TestingColumnHandle("probeColumnB");
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)df1), (Object)new DynamicFilters.Descriptor(filterId1, (Expression)df2)), (Map)ImmutableMap.of((Object)symbol1, (Object)column1, (Object)symbol2, (Object)column2), symbolAllocator.getTypes());
        Domain domain = Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L);
        dynamicFilterService.addTaskDynamicFilters(new TaskId(stageId1, 0), (Map)ImmutableMap.of((Object)filterId1, (Object)domain));
        Assert.assertEquals((Object)dynamicFilter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column1, (Object)domain, (Object)column2, (Object)domain)));
    }

    @Test
    public void testSourceStageInnerLazyDynamicFilters() {
        DynamicFilterId dynamicFilterId = new DynamicFilterId("filterId");
        Assert.assertEquals((Set)DynamicFilterService.getSourceStageInnerLazyDynamicFilters((PlanFragment)TestDynamicFilterService.createPlan(dynamicFilterId, SystemPartitioningHandle.SOURCE_DISTRIBUTION, ExchangeNode.Type.REPLICATE)), (Set)ImmutableSet.of((Object)dynamicFilterId));
        Assert.assertEquals((Set)DynamicFilterService.getSourceStageInnerLazyDynamicFilters((PlanFragment)TestDynamicFilterService.createPlan(dynamicFilterId, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, ExchangeNode.Type.REPLICATE)), (Set)ImmutableSet.of());
        Assert.assertEquals((Set)DynamicFilterService.getSourceStageInnerLazyDynamicFilters((PlanFragment)TestDynamicFilterService.createPlan(dynamicFilterId, SystemPartitioningHandle.SOURCE_DISTRIBUTION, ExchangeNode.Type.REPARTITION)), (Set)ImmutableSet.of());
    }

    private static PlanFragment createPlan(DynamicFilterId dynamicFilterId, PartitioningHandle stagePartitioning, ExchangeNode.Type exchangeType) {
        Symbol symbol = new Symbol("column");
        Symbol buildSymbol = new Symbol("buildColumn");
        PlanNodeId tableScanNodeId = new PlanNodeId("plan_id");
        TableScanNode tableScan = TableScanNode.newInstance((PlanNodeId)tableScanNodeId, (TableHandle)TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)symbol), (Map)ImmutableMap.of((Object)symbol, (Object)new TestingMetadata.TestingColumnHandle("column")), (boolean)false);
        FilterNode filterNode = new FilterNode(new PlanNodeId("filter_node_id"), (PlanNode)tableScan, DynamicFilters.createDynamicFilterExpression((Metadata)MetadataManager.createTestMetadataManager(), (DynamicFilterId)dynamicFilterId, (Type)VarcharType.VARCHAR, (Expression)symbol.toSymbolReference()));
        RemoteSourceNode remote = new RemoteSourceNode(new PlanNodeId("remote_id"), new PlanFragmentId("plan_fragment_id"), (List)ImmutableList.of((Object)buildSymbol), Optional.empty(), exchangeType);
        return new PlanFragment(new PlanFragmentId("plan_id"), (PlanNode)new JoinNode(new PlanNodeId("join_id"), JoinNode.Type.INNER, (PlanNode)filterNode, (PlanNode)remote, (List)ImmutableList.of(), tableScan.getOutputSymbols(), remote.getOutputSymbols(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of((Object)dynamicFilterId, (Object)buildSymbol), Optional.empty()), (Map)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR), stagePartitioning, (List)ImmutableList.of((Object)tableScanNodeId), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)symbol)), StageExecutionDescriptor.ungroupedExecution(), StatsAndCosts.empty(), Optional.empty());
    }

    private static String getExpectedDomainString(long low, long high) {
        return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)IntegerType.INTEGER, (Object)low, (boolean)true, (Object)high, (boolean)true), (Range[])new Range[0]), (boolean)false).toString(session.toConnectorSession());
    }
}

