/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.prestosql.server.InternalCommunicationConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.testng.annotations.Test;

public class TestInternalCommunicationConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((InternalCommunicationConfig)ConfigAssertions.recordDefaults(InternalCommunicationConfig.class)).setSharedSecret(null).setHttp2Enabled(false).setHttpsRequired(false).setKeyStorePath(null).setKeyStorePassword(null).setTrustStorePath(null).setTrustStorePassword(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path keystoreFile = Files.createTempFile(null, null, new FileAttribute[0]);
        Path truststoreFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"internal-communication.shared-secret", (Object)"secret").put((Object)"internal-communication.http2.enabled", (Object)"true").put((Object)"internal-communication.https.required", (Object)"true").put((Object)"internal-communication.https.keystore.path", (Object)keystoreFile.toString()).put((Object)"internal-communication.https.keystore.key", (Object)"key-key").put((Object)"internal-communication.https.truststore.path", (Object)truststoreFile.toString()).put((Object)"internal-communication.https.truststore.key", (Object)"trust-key").build();
        InternalCommunicationConfig expected = new InternalCommunicationConfig().setSharedSecret("secret").setHttp2Enabled(true).setHttpsRequired(true).setKeyStorePath(keystoreFile.toString()).setKeyStorePassword("key-key").setTrustStorePath(truststoreFile.toString()).setTrustStorePassword("trust-key");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

