/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import io.airlift.http.client.HttpClient;
import io.airlift.http.client.JsonResponseHandler;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.testing.Closeables;
import io.prestosql.failuredetector.HeartbeatFailureDetector;
import io.prestosql.server.testing.TestingPrestoServer;
import java.io.Closeable;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestNodeResource {
    private TestingPrestoServer server;
    private HttpClient client;

    @BeforeClass
    public void setup() {
        this.server = TestingPrestoServer.create();
        this.client = new JettyHttpClient();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        Closeables.closeAll((Closeable[])new Closeable[]{this.server, this.client});
    }

    @Test
    public void testGetAllNodes() {
        List nodes = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/node")).setHeader("X-Presto-User", "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(HeartbeatFailureDetector.Stats.class)));
        Assert.assertTrue((boolean)nodes.isEmpty());
    }

    @Test
    public void testGetFailedNodes() {
        List nodes = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/node/failed")).setHeader("X-Presto-User", "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(HeartbeatFailureDetector.Stats.class)));
        Assert.assertTrue((boolean)nodes.isEmpty());
    }
}

