/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.JsonResponseHandler;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.UnexpectedResponseException;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.units.Duration;
import io.prestosql.client.QueryResults;
import io.prestosql.execution.QueryState;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.server.QueryStateInfo;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.Plugin;
import io.prestosql.testing.TestingAccessControlManager;
import io.prestosql.testing.assertions.Assert;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestQueryStateInfoResource {
    private static final String LONG_LASTING_QUERY = "SELECT * FROM tpch.sf1.lineitem";
    private static final JsonCodec<QueryResults> QUERY_RESULTS_JSON_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private TestingPrestoServer server;
    private HttpClient client;
    private QueryResults queryResults;

    @BeforeClass
    public void setUp() {
        this.server = TestingPrestoServer.create();
        this.server.installPlugin((Plugin)new TpchPlugin());
        this.server.createCatalog("tpch", "tpch");
        this.client = new JettyHttpClient();
        Request request1 = Request.Builder.preparePost().setUri(HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/statement").build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)LONG_LASTING_QUERY, (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user1").build();
        this.queryResults = (QueryResults)this.client.execute(request1, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
        this.client.execute(Request.Builder.prepareGet().setUri(this.queryResults.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
        Request request2 = Request.Builder.preparePost().setUri(HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/statement").build()).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)LONG_LASTING_QUERY, (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user2").build();
        QueryResults queryResults2 = (QueryResults)this.client.execute(request2, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryResults.class)));
        this.client.execute(Request.Builder.prepareGet().setUri(queryResults2.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_JSON_CODEC));
        long start = System.nanoTime();
        while (Duration.nanosSince((long)start).compareTo(new Duration(5.0, TimeUnit.MINUTES)) < 0) {
            List queryInfos = (List)this.client.execute(Request.Builder.prepareGet().setUri(HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath("/v1/query").build()).setHeader("X-Presto-User", "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(BasicQueryInfo.class)));
            if (queryInfos.size() != 2) continue;
            if (queryInfos.stream().allMatch(info -> info.getState() == QueryState.RUNNING)) break;
            List errorCodes = (List)queryInfos.stream().filter(info -> info.getState() == QueryState.FAILED).map(BasicQueryInfo::getErrorCode).collect(ImmutableList.toImmutableList());
            if (errorCodes.isEmpty()) continue;
            Fail.fail((String)("setup queries failed with: " + errorCodes));
        }
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws IOException {
        Closer closer = Closer.create();
        closer.register((Closeable)this.server);
        closer.register((Closeable)this.client);
        closer.close();
    }

    @Test
    public void testGetAllQueryStateInfos() {
        List infos = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState")).setHeader("X-Presto-User", "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(QueryStateInfo.class)));
        Assert.assertEquals((int)infos.size(), (int)2);
    }

    @Test
    public void testGetQueryStateInfosForUser() {
        List infos = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState?user=user2")).setHeader("X-Presto-User", "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(QueryStateInfo.class)));
        Assert.assertEquals((int)infos.size(), (int)1);
    }

    @Test
    public void testGetQueryStateInfosForUserNoResult() {
        List infos = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState?user=user3")).setHeader("X-Presto-User", "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(QueryStateInfo.class)));
        org.testng.Assert.assertTrue((boolean)infos.isEmpty());
    }

    @Test
    public void testGetQueryStateInfo() {
        QueryStateInfo info = (QueryStateInfo)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState/" + this.queryResults.getId())).setHeader("X-Presto-User", "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryStateInfo.class)));
        org.testng.Assert.assertNotNull((Object)info);
    }

    @Test
    public void testGetAllQueryStateInfosDenied() {
        List infos = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState")).setHeader("X-Presto-User", "any-other-user").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(QueryStateInfo.class)));
        Assert.assertEquals((int)infos.size(), (int)2);
        this.testGetAllQueryStateInfosDenied("user1", 1);
        this.testGetAllQueryStateInfosDenied("any-other-user", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGetAllQueryStateInfosDenied(String executionUser, int expectedCount) {
        this.server.getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)executionUser, (String)"query", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.VIEW_QUERY)});
        try {
            List infos = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState")).setHeader("X-Presto-User", executionUser).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(QueryStateInfo.class)));
            Assert.assertEquals((int)infos.size(), (int)expectedCount);
        }
        finally {
            this.server.getAccessControl().reset();
        }
    }

    @Test
    public void testGetQueryStateInfoDenied() {
        this.server.getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"query", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.VIEW_QUERY)});
        try {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState/" + this.queryResults.getId())).setHeader("X-Presto-User", "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryStateInfo.class)))).isInstanceOf(UnexpectedResponseException.class)).matches(throwable -> ((UnexpectedResponseException)throwable).getStatusCode() == 403);
        }
        finally {
            this.server.getAccessControl().reset();
        }
    }

    @Test(expectedExceptions={UnexpectedResponseException.class}, expectedExceptionsMessageRegExp="Expected response code .*, but was 404")
    public void testGetQueryStateInfoNo() {
        this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/queryState/123")).setHeader("X-Presto-User", "unknown").build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.jsonCodec(QueryStateInfo.class)));
    }
}

