/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import io.airlift.json.ObjectMapperProvider;
import io.prestosql.server.RangeJsonSerde;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.block.TestingBlockEncodingSerde;
import io.prestosql.spi.block.TestingBlockJsonSerde;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.TestingTypeDeserializer;
import io.prestosql.spi.type.TestingTypeManager;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeManager;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRangeJsonSerde {
    @Test
    public void testRangeJsonSerde() throws JsonProcessingException {
        TestingTypeManager typeManager = new TestingTypeManager();
        TestingBlockEncodingSerde blockEncodingSerde = new TestingBlockEncodingSerde();
        ObjectMapper mapper = new ObjectMapperProvider().get().registerModule((Module)new SimpleModule().addSerializer(Range.class, (JsonSerializer)new RangeJsonSerde.Serializer()).addDeserializer(Range.class, (JsonDeserializer)new RangeJsonSerde.Deserializer()).addDeserializer(Type.class, (JsonDeserializer)new TestingTypeDeserializer((TypeManager)typeManager)).addSerializer(Block.class, (JsonSerializer)new TestingBlockJsonSerde.Serializer((BlockEncodingSerde)blockEncodingSerde)).addDeserializer(Block.class, (JsonDeserializer)new TestingBlockJsonSerde.Deserializer((BlockEncodingSerde)blockEncodingSerde)));
        Range singleValueRange = Range.equal((Type)BigintType.BIGINT, (Object)1L);
        Range range = Range.range((Type)BigintType.BIGINT, (Object)12L, (boolean)true, (Object)42L, (boolean)true);
        Range unboundedRange = Range.greaterThan((Type)BigintType.BIGINT, (Object)123L);
        String serializedRanges = mapper.writeValueAsString((Object)ImmutableList.of((Object)singleValueRange, (Object)range, (Object)unboundedRange, (Object)singleValueRange));
        Assert.assertEquals((String)serializedRanges, (String)"[1,\"bigint\",\"CgAAAExPTkdfQVJSQVkBAAAAAAEAAAAAAAAA\",0,{\"type\":\"bigint\",\"valueBlock\":\"CgAAAExPTkdfQVJSQVkBAAAAAAwAAAAAAAAA\",\"bound\":\"EXACTLY\"},{\"type\":\"bigint\",\"valueBlock\":\"CgAAAExPTkdfQVJSQVkBAAAAACoAAAAAAAAA\",\"bound\":\"EXACTLY\"},0,{\"type\":\"bigint\",\"valueBlock\":\"CgAAAExPTkdfQVJSQVkBAAAAAHsAAAAAAAAA\",\"bound\":\"ABOVE\"},{\"type\":\"bigint\",\"bound\":\"BELOW\"},1,\"bigint\",\"CgAAAExPTkdfQVJSQVkBAAAAAAEAAAAAAAAA\"]");
        Assert.assertEquals((Collection)((Collection)mapper.readValue(serializedRanges, (TypeReference)new TypeReference<List<Range>>(){})), (Collection)ImmutableList.of((Object)singleValueRange, (Object)range, (Object)unboundedRange, (Object)singleValueRange));
    }
}

