/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.testing.Closeables;
import io.prestosql.client.Column;
import io.prestosql.client.QueryError;
import io.prestosql.client.QueryResults;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.type.TimeZoneNotSupportedException;
import java.io.Closeable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestServer {
    private static final JsonCodec<QueryResults> QUERY_RESULTS_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private TestingPrestoServer server;
    private HttpClient client;

    @BeforeClass
    public void setup() {
        this.server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().put((Object)"http-server.process-forwarded", (Object)"true").build()).build();
        this.client = new JettyHttpClient();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        Closeables.closeAll((Closeable[])new Closeable[]{this.server, this.client});
    }

    @Test
    public void testInvalidSessionError() {
        String invalidTimeZone = "this_is_an_invalid_time_zone";
        QueryResults queryResults = (QueryResults)this.postQuery(request -> request.setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-Catalog", "catalog").setHeader("X-Presto-Schema", "schema").setHeader("X-Presto-Path", "path").setHeader("X-Presto-Time-Zone", invalidTimeZone)).map(FullJsonResponseHandler.JsonResponse::getValue).peek(result -> Preconditions.checkState((result.getError() == null != (result.getNextUri() == null) ? 1 : 0) != 0)).collect(TestServer.last());
        QueryError queryError = queryResults.getError();
        Assert.assertNotNull((Object)queryError);
        TimeZoneNotSupportedException expected = new TimeZoneNotSupportedException(invalidTimeZone);
        Assert.assertEquals((int)queryError.getErrorCode(), (int)expected.getErrorCode().getCode());
        Assert.assertEquals((String)queryError.getErrorName(), (String)expected.getErrorCode().getName());
        Assert.assertEquals((String)queryError.getErrorType(), (String)expected.getErrorCode().getType().name());
        Assert.assertEquals((String)queryError.getMessage(), (String)expected.getMessage());
    }

    @Test
    public void testFirstResponseColumns() {
        List queryResults = (List)this.postQuery(request -> request.setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-Catalog", "catalog").setHeader("X-Presto-Schema", "schema").setHeader("X-Presto-Path", "path")).map(FullJsonResponseHandler.JsonResponse::getValue).collect(ImmutableList.toImmutableList());
        QueryResults first = (QueryResults)queryResults.get(0);
        QueryResults last = (QueryResults)queryResults.get(queryResults.size() - 1);
        Optional<QueryResults> data = queryResults.stream().filter(results -> results.getData() != null).findFirst();
        Assert.assertNull((Object)first.getColumns());
        Assert.assertEquals((String)first.getStats().getState(), (String)"QUEUED");
        Assert.assertNull((Object)first.getData());
        Assertions.assertThat((List)last.getColumns()).hasSize(1);
        Assertions.assertThat((String)((Column)last.getColumns().get(0)).getName()).isEqualTo("Catalog");
        Assertions.assertThat((String)((Column)last.getColumns().get(0)).getType()).isEqualTo("varchar(6)");
        Assert.assertEquals((String)last.getStats().getState(), (String)"FINISHED");
        Assertions.assertThat(data).isPresent();
        QueryResults results2 = data.orElseThrow();
        Assertions.assertThat((Iterable)results2.getData()).containsOnly((Object[])new List[]{ImmutableList.of((Object)"system")});
    }

    @Test
    public void testServerStarts() {
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/info")).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)Response.Status.OK.getStatusCode());
    }

    @Test
    public void testQuery() {
        ImmutableList.Builder data = ImmutableList.builder();
        QueryResults queryResults = (QueryResults)this.postQuery(request -> request.setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-Catalog", "catalog").setHeader("X-Presto-Schema", "schema").setHeader("X-Presto-Path", "path").setHeader("X-Presto-Client-Info", "{\"clientVersion\":\"testVersion\"}").addHeader("X-Presto-Session", "query_max_memory=1GB").addHeader("X-Presto-Session", "join_distribution_type=partitioned,hash_partition_count = 43").addHeader("X-Presto-Prepared-Statement", "foo=select * from bar")).map(FullJsonResponseHandler.JsonResponse::getValue).peek(result -> Assert.assertNull((Object)result.getError())).peek(results -> {
            if (results.getData() != null) {
                data.addAll(results.getData());
            }
        }).collect(TestServer.last());
        BasicQueryInfo queryInfo = this.server.getQueryManager().getQueryInfo(new QueryId(queryResults.getId()));
        Assert.assertEquals((Map)queryInfo.getSession().getSystemProperties(), (Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"1GB").put((Object)"join_distribution_type", (Object)"partitioned").put((Object)"hash_partition_count", (Object)"43").build());
        Assert.assertEquals((String)((String)queryInfo.getSession().getClientInfo().get()), (String)"{\"clientVersion\":\"testVersion\"}");
        Assert.assertEquals((Map)queryInfo.getSession().getPreparedStatements(), (Map)ImmutableMap.builder().put((Object)"foo", (Object)"select * from bar").build());
        ImmutableList rows = data.build();
        Assert.assertEquals((Collection)rows, (Collection)ImmutableList.of((Object)ImmutableList.of((Object)"system")));
    }

    @Test
    public void testTransactionSupport() {
        FullJsonResponseHandler.JsonResponse queryResults = (FullJsonResponseHandler.JsonResponse)this.postQuery(request -> request.setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"start transaction", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-Transaction-Id", "none")).peek(result -> Assert.assertNull((Object)((QueryResults)result.getValue()).getError())).collect(TestServer.last());
        Assert.assertNotNull((Object)queryResults.getHeader("X-Presto-Started-Transaction-Id"));
    }

    @Test
    public void testNoTransactionSupport() {
        QueryResults queryResults = this.postQuery(request -> request.setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"start transaction", (Charset)StandardCharsets.UTF_8))).map(FullJsonResponseHandler.JsonResponse::getValue).filter(result -> result.getError() != null).findFirst().orElseThrow(() -> new RuntimeException("Error expected"));
        Assert.assertNull((Object)queryResults.getNextUri());
        Assert.assertEquals((int)queryResults.getError().getErrorCode(), (int)StandardErrorCode.INCOMPATIBLE_CLIENT.toErrorCode().getCode());
    }

    @Test(dataProvider="testVersionOnErrorDataProvider")
    public void testVersionOnError(String query) {
        QueryResults queryResults = this.postQuery(request -> request.setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)query, (Charset)StandardCharsets.UTF_8))).map(FullJsonResponseHandler.JsonResponse::getValue).filter(result -> result.getError() != null).findFirst().orElseThrow(() -> new RuntimeException("Error expected"));
        Assert.assertNull((Object)queryResults.getNextUri());
        QueryError queryError = queryResults.getError();
        List stackTrace = Splitter.on((String)"\n").splitToList((CharSequence)Throwables.getStackTraceAsString((Throwable)queryError.getFailureInfo().toException()));
        long versionLines = stackTrace.stream().filter(line -> line.contains("at io.prestosql.$gen.Presto_testversion____")).count();
        Assert.assertEquals((long)versionLines, (long)1L, (String)"Number of times version is embedded in stacktrace");
    }

    @DataProvider
    public Object[][] testVersionOnErrorDataProvider() {
        return new Object[][]{{"SELECT query that fails parsing"}, {"SELECT foo FROM no.such.table"}, {"SELECT 1 / 0"}, {"select 1 / a from (values 0) t(a)"}};
    }

    @Test
    public void testStatusPing() {
        Request request = Request.Builder.prepareHead().setUri(this.uriFor("/v1/status")).setHeader("X-Presto-User", "unknown").setFollowRedirects(false).build();
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.client.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Status code");
        Assert.assertEquals((String)response.getHeader("Content-Type"), (String)"application/json", (String)"Content Type");
    }

    @Test
    public void testRedirectToUi() {
        Request request = Request.Builder.prepareGet().setUri(this.uriFor("/")).setFollowRedirects(false).build();
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.client.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)Response.Status.SEE_OTHER.getStatusCode(), (String)"Status code");
        Assert.assertEquals((String)response.getHeader("Location"), (String)(this.server.getBaseUrl() + "/ui/"), (String)"Location");
        request = Request.Builder.prepareGet().setUri(this.uriFor("/")).setHeader("X-Forwarded-Proto", "https").setHeader("X-Forwarded-Host", "my-load-balancer.local").setHeader("X-Forwarded-Port", "443").setFollowRedirects(false).build();
        response = (StatusResponseHandler.StatusResponse)this.client.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)Response.Status.SEE_OTHER.getStatusCode(), (String)"Status code");
        Assert.assertEquals((String)response.getHeader("Location"), (String)"https://my-load-balancer.local/ui/", (String)"Location");
    }

    private Stream<FullJsonResponseHandler.JsonResponse<QueryResults>> postQuery(Function<Request.Builder, Request.Builder> requestConfigurer) {
        Request.Builder request = Request.Builder.preparePost().setUri(this.uriFor("/v1/statement")).setHeader("X-Presto-User", "user").setHeader("X-Presto-Source", "source");
        request = requestConfigurer.apply(request);
        FullJsonResponseHandler.JsonResponse queryResults = (FullJsonResponseHandler.JsonResponse)this.client.execute(request.build(), (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(QUERY_RESULTS_CODEC));
        return Streams.stream((Iterator)((Object)new QueryResultsIterator(this.client, (FullJsonResponseHandler.JsonResponse<QueryResults>)queryResults)));
    }

    private URI uriFor(String path) {
        return HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath(path).build();
    }

    private static <T> Collector<T, ?, T> last() {
        return Collectors.collectingAndThen(Collectors.reducing((a, b) -> b), Optional::get);
    }

    private static class QueryResultsIterator
    extends AbstractSequentialIterator<FullJsonResponseHandler.JsonResponse<QueryResults>> {
        private final HttpClient client;

        QueryResultsIterator(HttpClient client, FullJsonResponseHandler.JsonResponse<QueryResults> firstResults) {
            super(Objects.requireNonNull(firstResults, "firstResults is null"));
            this.client = Objects.requireNonNull(client, "client is null");
        }

        protected FullJsonResponseHandler.JsonResponse<QueryResults> computeNext(FullJsonResponseHandler.JsonResponse<QueryResults> previous) {
            if (((QueryResults)previous.getValue()).getNextUri() == null) {
                return null;
            }
            return (FullJsonResponseHandler.JsonResponse)this.client.execute(Request.Builder.prepareGet().setUri(((QueryResults)previous.getValue()).getNextUri()).build(), (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(QUERY_RESULTS_CODEC));
        }
    }
}

