/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.remotetask;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.testing.TestingHttpClient;
import io.airlift.jaxrs.JsonMapper;
import io.airlift.jaxrs.testing.JaxrsTestingHttpProcessor;
import io.airlift.json.JsonBinder;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecBinder;
import io.airlift.json.JsonModule;
import io.airlift.testing.Assertions;
import io.airlift.units.Duration;
import io.prestosql.SessionTestUtils;
import io.prestosql.block.BlockJsonSerde;
import io.prestosql.client.NodeVersion;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.DynamicFilterConfig;
import io.prestosql.execution.DynamicFiltersCollector;
import io.prestosql.execution.ExecutionFailureInfo;
import io.prestosql.execution.Lifespan;
import io.prestosql.execution.LocationFactory;
import io.prestosql.execution.NodeTaskMap;
import io.prestosql.execution.QueryManagerConfig;
import io.prestosql.execution.RemoteTask;
import io.prestosql.execution.StageId;
import io.prestosql.execution.TaskId;
import io.prestosql.execution.TaskInfo;
import io.prestosql.execution.TaskManagerConfig;
import io.prestosql.execution.TaskSource;
import io.prestosql.execution.TaskState;
import io.prestosql.execution.TaskStatus;
import io.prestosql.execution.TaskTestUtils;
import io.prestosql.execution.TestSqlTaskManager;
import io.prestosql.execution.buffer.OutputBuffers;
import io.prestosql.metadata.HandleJsonModule;
import io.prestosql.metadata.HandleResolver;
import io.prestosql.metadata.InternalNode;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.Split;
import io.prestosql.server.DynamicFilterService;
import io.prestosql.server.HttpRemoteTaskFactory;
import io.prestosql.server.TaskUpdateRequest;
import io.prestosql.server.remotetask.RemoteTaskStats;
import io.prestosql.spi.ErrorCode;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.DynamicFilter;
import io.prestosql.spi.connector.TestingColumnHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.SymbolAllocator;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.PlanNodeId;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.testing.TestingHandleResolver;
import io.prestosql.testing.TestingSplit;
import io.prestosql.type.TypeDeserializer;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHttpRemoteTask {
    private static final Duration POLL_TIMEOUT = new Duration(100.0, TimeUnit.MILLISECONDS);
    private static final Duration IDLE_TIMEOUT = new Duration(3.0, TimeUnit.SECONDS);
    private static final Duration FAIL_TIMEOUT = new Duration(20.0, TimeUnit.SECONDS);
    private static final TaskManagerConfig TASK_MANAGER_CONFIG = new TaskManagerConfig().setStatusRefreshMaxWait(new Duration((double)(IDLE_TIMEOUT.roundTo(TimeUnit.MILLISECONDS) / 100L), TimeUnit.MILLISECONDS)).setInfoUpdateInterval(new Duration((double)(IDLE_TIMEOUT.roundTo(TimeUnit.MILLISECONDS) / 10L), TimeUnit.MILLISECONDS));
    private static final boolean TRACE_HTTP = false;

    @Test(timeOut=30000L)
    public void testRemoteTaskMismatch() throws Exception {
        this.runTest(FailureScenario.TASK_MISMATCH);
    }

    @Test(timeOut=30000L)
    public void testRejectedExecutionWhenVersionIsHigh() throws Exception {
        this.runTest(FailureScenario.TASK_MISMATCH_WHEN_VERSION_IS_HIGH);
    }

    @Test(timeOut=30000L)
    public void testRejectedExecution() throws Exception {
        this.runTest(FailureScenario.REJECTED_EXECUTION);
    }

    @Test(timeOut=30000L)
    public void testRegular() throws Exception {
        AtomicLong lastActivityNanos = new AtomicLong(System.nanoTime());
        TestingTaskResource testingTaskResource = new TestingTaskResource(lastActivityNanos, FailureScenario.NO_FAILURE);
        HttpRemoteTaskFactory httpRemoteTaskFactory = TestHttpRemoteTask.createHttpRemoteTaskFactory(testingTaskResource);
        RemoteTask remoteTask = this.createRemoteTask(httpRemoteTaskFactory);
        testingTaskResource.setInitialTaskInfo(remoteTask.getTaskInfo());
        remoteTask.start();
        Lifespan lifespan = Lifespan.driverGroup((int)3);
        remoteTask.addSplits((Multimap)ImmutableMultimap.of((Object)TaskTestUtils.TABLE_SCAN_NODE_ID, (Object)new Split(new CatalogName("test"), (ConnectorSplit)TestingSplit.createLocalSplit(), lifespan)));
        TestHttpRemoteTask.poll(() -> testingTaskResource.getTaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID) != null);
        TestHttpRemoteTask.poll(() -> testingTaskResource.getTaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID).getSplits().size() == 1);
        remoteTask.noMoreSplits(TaskTestUtils.TABLE_SCAN_NODE_ID, lifespan);
        TestHttpRemoteTask.poll(() -> testingTaskResource.getTaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID).getNoMoreSplitsForLifespan().size() == 1);
        remoteTask.noMoreSplits(TaskTestUtils.TABLE_SCAN_NODE_ID);
        TestHttpRemoteTask.poll(() -> testingTaskResource.getTaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID).isNoMoreSplits());
        remoteTask.cancel();
        TestHttpRemoteTask.poll(() -> remoteTask.getTaskStatus().getState().isDone());
        TestHttpRemoteTask.poll(() -> remoteTask.getTaskInfo().getTaskStatus().getState().isDone());
        httpRemoteTaskFactory.stop();
    }

    @Test(timeOut=30000L)
    public void testDynamicFilters() throws Exception {
        DynamicFilterId filterId1 = new DynamicFilterId("df1");
        DynamicFilterId filterId2 = new DynamicFilterId("df2");
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("DF_SYMBOL1", (Type)BigintType.BIGINT);
        Symbol symbol2 = symbolAllocator.newSymbol("DF_SYMBOL2", (Type)BigintType.BIGINT);
        SymbolReference df1 = symbol1.toSymbolReference();
        SymbolReference df2 = symbol2.toSymbolReference();
        TestingColumnHandle handle1 = new TestingColumnHandle("column1");
        TestingColumnHandle handle2 = new TestingColumnHandle("column2");
        QueryId queryId = new QueryId("test");
        TestingTaskResource testingTaskResource = new TestingTaskResource(new AtomicLong(System.nanoTime()), FailureScenario.NO_FAILURE);
        DynamicFilterService dynamicFilterService = new DynamicFilterService((Metadata)MetadataManager.createTestMetadataManager(), new TypeOperators(), (ExecutorService)MoreExecutors.newDirectExecutorService());
        HttpRemoteTaskFactory httpRemoteTaskFactory = TestHttpRemoteTask.createHttpRemoteTaskFactory(testingTaskResource, dynamicFilterService);
        RemoteTask remoteTask = this.createRemoteTask(httpRemoteTaskFactory);
        ImmutableMap initialDomain = ImmutableMap.of((Object)filterId1, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L));
        testingTaskResource.setInitialTaskInfo(remoteTask.getTaskInfo());
        testingTaskResource.setDynamicFilterDomains(new DynamicFiltersCollector.VersionedDynamicFilterDomains(1L, (Map)initialDomain));
        dynamicFilterService.registerQuery(queryId, SessionTestUtils.TEST_SESSION, (Set)ImmutableSet.of((Object)filterId1, (Object)filterId2), (Set)ImmutableSet.of((Object)filterId1, (Object)filterId2), (Set)ImmutableSet.of());
        dynamicFilterService.stageCannotScheduleMoreTasks(new StageId(queryId, 1), 1);
        DynamicFilter dynamicFilter = dynamicFilterService.createDynamicFilter(queryId, (List)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)df1), (Object)new DynamicFilters.Descriptor(filterId2, (Expression)df2)), (Map)ImmutableMap.of((Object)symbol1, (Object)handle1, (Object)symbol2, (Object)handle2), symbolAllocator.getTypes());
        CompletableFuture future = dynamicFilter.isBlocked();
        remoteTask.start();
        future.get();
        io.prestosql.testing.assertions.Assert.assertEquals((Object)dynamicFilter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)handle1, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L))));
        io.prestosql.testing.assertions.Assert.assertEquals((long)testingTaskResource.getDynamicFiltersFetchCounter(), (long)1L);
        io.prestosql.testing.assertions.Assert.assertEventually((Duration)new Duration(15.0, TimeUnit.SECONDS), () -> Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(testingTaskResource.getStatusFetchCounter()), (Comparable)Long.valueOf(3L)));
        future = dynamicFilter.isBlocked();
        testingTaskResource.setDynamicFilterDomains(new DynamicFiltersCollector.VersionedDynamicFilterDomains(2L, (Map)ImmutableMap.of((Object)filterId2, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
        future.get();
        io.prestosql.testing.assertions.Assert.assertEquals((Object)dynamicFilter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)handle1, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L), (Object)handle2, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
        io.prestosql.testing.assertions.Assert.assertEquals((long)testingTaskResource.getDynamicFiltersFetchCounter(), (long)2L);
        Assertions.assertGreaterThanOrEqual((Comparable)Long.valueOf(testingTaskResource.getStatusFetchCounter()), (Comparable)Long.valueOf(4L));
        httpRemoteTaskFactory.stop();
        dynamicFilterService.stop();
    }

    private void runTest(FailureScenario failureScenario) throws Exception {
        AtomicLong lastActivityNanos = new AtomicLong(System.nanoTime());
        TestingTaskResource testingTaskResource = new TestingTaskResource(lastActivityNanos, failureScenario);
        HttpRemoteTaskFactory httpRemoteTaskFactory = TestHttpRemoteTask.createHttpRemoteTaskFactory(testingTaskResource);
        RemoteTask remoteTask = this.createRemoteTask(httpRemoteTaskFactory);
        testingTaskResource.setInitialTaskInfo(remoteTask.getTaskInfo());
        remoteTask.start();
        TestHttpRemoteTask.waitUntilIdle(lastActivityNanos);
        httpRemoteTaskFactory.stop();
        Assert.assertTrue((boolean)remoteTask.getTaskStatus().getState().isDone(), (String)String.format("TaskStatus is not in a done state: %s", remoteTask.getTaskStatus()));
        ErrorCode actualErrorCode = ((ExecutionFailureInfo)Iterables.getOnlyElement((Iterable)remoteTask.getTaskStatus().getFailures())).getErrorCode();
        switch (failureScenario) {
            case TASK_MISMATCH: 
            case TASK_MISMATCH_WHEN_VERSION_IS_HIGH: {
                Assert.assertTrue((boolean)remoteTask.getTaskInfo().getTaskStatus().getState().isDone(), (String)String.format("TaskInfo is not in a done state: %s", remoteTask.getTaskInfo()));
                io.prestosql.testing.assertions.Assert.assertEquals((Object)actualErrorCode, (Object)StandardErrorCode.REMOTE_TASK_MISMATCH.toErrorCode());
                break;
            }
            case REJECTED_EXECUTION: {
                io.prestosql.testing.assertions.Assert.assertEquals((Object)actualErrorCode, (Object)StandardErrorCode.REMOTE_TASK_ERROR.toErrorCode());
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private RemoteTask createRemoteTask(HttpRemoteTaskFactory httpRemoteTaskFactory) {
        return httpRemoteTaskFactory.createRemoteTask(SessionTestUtils.TEST_SESSION, new TaskId("test", 1, 2), new InternalNode("node-id", URI.create("http://fake.invalid/"), new NodeVersion("version"), false), TaskTestUtils.PLAN_FRAGMENT, (Multimap)ImmutableMultimap.of(), OptionalInt.empty(), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.BROADCAST), new NodeTaskMap.PartitionedSplitCountTracker(i -> {}), true);
    }

    private static HttpRemoteTaskFactory createHttpRemoteTaskFactory(TestingTaskResource testingTaskResource) {
        return TestHttpRemoteTask.createHttpRemoteTaskFactory(testingTaskResource, new DynamicFilterService((Metadata)MetadataManager.createTestMetadataManager(), new TypeOperators(), new DynamicFilterConfig()));
    }

    private static HttpRemoteTaskFactory createHttpRemoteTaskFactory(final TestingTaskResource testingTaskResource, final DynamicFilterService dynamicFilterService) {
        Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new HandleJsonModule(), new Module(){

            public void configure(Binder binder) {
                binder.bind(JsonMapper.class);
                binder.bind(Metadata.class).toInstance((Object)MetadataManager.createTestMetadataManager());
                JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
                JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskStatus.class);
                JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(DynamicFiltersCollector.VersionedDynamicFilterDomains.class);
                JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Block.class).to(BlockJsonSerde.Serializer.class);
                JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Block.class).to(BlockJsonSerde.Deserializer.class);
                JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskInfo.class);
                JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskUpdateRequest.class);
            }

            @Provides
            @Singleton
            public BlockEncodingSerde createBlockEncodingSerde(Metadata metadata) {
                return metadata.getBlockEncodingSerde();
            }

            @Provides
            private HttpRemoteTaskFactory createHttpRemoteTaskFactory(JsonMapper jsonMapper, JsonCodec<TaskStatus> taskStatusCodec, JsonCodec<DynamicFiltersCollector.VersionedDynamicFilterDomains> dynamicFilterDomainsCodec, JsonCodec<TaskInfo> taskInfoCodec, JsonCodec<TaskUpdateRequest> taskUpdateRequestCodec) {
                JaxrsTestingHttpProcessor jaxrsTestingHttpProcessor = new JaxrsTestingHttpProcessor(URI.create("http://fake.invalid/"), new Object[]{testingTaskResource, jsonMapper});
                TestingHttpClient testingHttpClient = new TestingHttpClient((TestingHttpClient.Processor)jaxrsTestingHttpProcessor.setTrace(false));
                testingTaskResource.setHttpClient(testingHttpClient);
                return new HttpRemoteTaskFactory(new QueryManagerConfig(), TASK_MANAGER_CONFIG, (HttpClient)testingHttpClient, (LocationFactory)new TestSqlTaskManager.MockLocationFactory(), taskStatusCodec, dynamicFilterDomainsCodec, taskInfoCodec, taskUpdateRequestCodec, new RemoteTaskStats(), dynamicFilterService);
            }
        }});
        Injector injector = app.strictConfig().doNotInitializeLogging().quiet().initialize();
        HandleResolver handleResolver = (HandleResolver)injector.getInstance(HandleResolver.class);
        handleResolver.addCatalogHandleResolver("test", (ConnectorHandleResolver)new TestingHandleResolver());
        return (HttpRemoteTaskFactory)injector.getInstance(HttpRemoteTaskFactory.class);
    }

    private static void poll(BooleanSupplier success) throws InterruptedException {
        long failAt = System.nanoTime() + FAIL_TIMEOUT.roundTo(TimeUnit.NANOSECONDS);
        while (!success.getAsBoolean()) {
            long millisUntilFail = (failAt - System.nanoTime()) / 1000000L;
            if (millisUntilFail <= 0L) {
                throw new AssertionError((Object)String.format("Timeout of %s reached", FAIL_TIMEOUT));
            }
            Thread.sleep(Math.min(POLL_TIMEOUT.toMillis(), millisUntilFail));
        }
    }

    private static void waitUntilIdle(AtomicLong lastActivityNanos) throws InterruptedException {
        long startTimeNanos = System.nanoTime();
        while (true) {
            long millisSinceLastActivity = (System.nanoTime() - lastActivityNanos.get()) / 1000000L;
            long millisSinceStart = (System.nanoTime() - startTimeNanos) / 1000000L;
            long millisToIdleTarget = IDLE_TIMEOUT.toMillis() - millisSinceLastActivity;
            long millisToFailTarget = FAIL_TIMEOUT.toMillis() - millisSinceStart;
            if (millisToFailTarget < millisToIdleTarget) {
                throw new AssertionError((Object)String.format("Activity doesn't stop after %s", FAIL_TIMEOUT));
            }
            if (millisToIdleTarget < 0L) {
                return;
            }
            Thread.sleep(millisToIdleTarget);
        }
    }

    @Path(value="/task/{nodeId}")
    public static class TestingTaskResource {
        private static final String INITIAL_TASK_INSTANCE_ID = "task-instance-id";
        private static final String NEW_TASK_INSTANCE_ID = "task-instance-id-x";
        private final AtomicLong lastActivityNanos;
        private final FailureScenario failureScenario;
        private AtomicReference<TestingHttpClient> httpClient = new AtomicReference();
        private TaskInfo initialTaskInfo;
        private TaskStatus initialTaskStatus;
        private Optional<DynamicFiltersCollector.VersionedDynamicFilterDomains> dynamicFilterDomains = Optional.empty();
        private long version;
        private TaskState taskState;
        private String taskInstanceId = "task-instance-id";
        private long statusFetchCounter;
        private long dynamicFiltersFetchCounter;
        Map<PlanNodeId, TaskSource> taskSourceMap = new HashMap<PlanNodeId, TaskSource>();

        public TestingTaskResource(AtomicLong lastActivityNanos, FailureScenario failureScenario) {
            this.lastActivityNanos = Objects.requireNonNull(lastActivityNanos, "lastActivityNanos is null");
            this.failureScenario = Objects.requireNonNull(failureScenario, "failureScenario is null");
        }

        public void setHttpClient(TestingHttpClient newValue) {
            this.httpClient.set(newValue);
        }

        @GET
        @Path(value="{taskId}")
        @Produces(value={"application/json"})
        public synchronized TaskInfo getTaskInfo(@PathParam(value="taskId") TaskId taskId, @HeaderParam(value="X-Presto-Current-Version") Long currentVersion, @HeaderParam(value="X-Presto-Max-Wait") Duration maxWait, @Context UriInfo uriInfo) {
            this.lastActivityNanos.set(System.nanoTime());
            return this.buildTaskInfo();
        }

        @POST
        @Path(value="{taskId}")
        @Consumes(value={"application/json"})
        @Produces(value={"application/json"})
        public synchronized TaskInfo createOrUpdateTask(@PathParam(value="taskId") TaskId taskId, TaskUpdateRequest taskUpdateRequest, @Context UriInfo uriInfo) {
            for (TaskSource source : taskUpdateRequest.getSources()) {
                this.taskSourceMap.compute(source.getPlanNodeId(), (planNodeId, taskSource) -> taskSource == null ? source : taskSource.update(source));
            }
            this.lastActivityNanos.set(System.nanoTime());
            return this.buildTaskInfo();
        }

        public synchronized TaskSource getTaskSource(PlanNodeId planNodeId) {
            TaskSource source = this.taskSourceMap.get(planNodeId);
            if (source == null) {
                return null;
            }
            return new TaskSource(source.getPlanNodeId(), source.getSplits(), source.getNoMoreSplitsForLifespan(), source.isNoMoreSplits());
        }

        @GET
        @Path(value="{taskId}/status")
        @Produces(value={"application/json"})
        public synchronized TaskStatus getTaskStatus(@PathParam(value="taskId") TaskId taskId, @HeaderParam(value="X-Presto-Current-Version") Long currentVersion, @HeaderParam(value="X-Presto-Max-Wait") Duration maxWait, @Context UriInfo uriInfo) throws InterruptedException {
            this.lastActivityNanos.set(System.nanoTime());
            this.wait(maxWait.roundTo(TimeUnit.MILLISECONDS));
            return this.buildTaskStatus();
        }

        @GET
        @Path(value="{taskId}/dynamicfilters")
        @Produces(value={"application/json"})
        public synchronized DynamicFiltersCollector.VersionedDynamicFilterDomains acknowledgeAndGetNewDynamicFilterDomains(@PathParam(value="taskId") TaskId taskId, @HeaderParam(value="X-Presto-Current-Version") Long currentDynamicFiltersVersion, @Context UriInfo uriInfo) {
            ++this.dynamicFiltersFetchCounter;
            return this.dynamicFilterDomains.orElse(null);
        }

        @DELETE
        @Path(value="{taskId}")
        @Produces(value={"application/json"})
        public synchronized TaskInfo deleteTask(@PathParam(value="taskId") TaskId taskId, @QueryParam(value="abort") @DefaultValue(value="true") boolean abort, @Context UriInfo uriInfo) {
            this.lastActivityNanos.set(System.nanoTime());
            this.taskState = abort ? TaskState.ABORTED : TaskState.CANCELED;
            return this.buildTaskInfo();
        }

        public void setInitialTaskInfo(TaskInfo initialTaskInfo) {
            this.initialTaskInfo = initialTaskInfo;
            this.initialTaskStatus = initialTaskInfo.getTaskStatus();
            this.taskState = this.initialTaskStatus.getState();
            this.version = this.initialTaskStatus.getVersion();
            switch (this.failureScenario) {
                case TASK_MISMATCH_WHEN_VERSION_IS_HIGH: {
                    this.version = 1000000L;
                    break;
                }
                case TASK_MISMATCH: 
                case REJECTED_EXECUTION: 
                case NO_FAILURE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        public synchronized void setDynamicFilterDomains(DynamicFiltersCollector.VersionedDynamicFilterDomains dynamicFilterDomains) {
            this.dynamicFilterDomains = Optional.of(dynamicFilterDomains);
        }

        public synchronized long getStatusFetchCounter() {
            return this.statusFetchCounter;
        }

        public synchronized long getDynamicFiltersFetchCounter() {
            return this.dynamicFiltersFetchCounter;
        }

        private TaskInfo buildTaskInfo() {
            return new TaskInfo(this.buildTaskStatus(), this.initialTaskInfo.getLastHeartbeat(), this.initialTaskInfo.getOutputBuffers(), this.initialTaskInfo.getNoMoreSplits(), this.initialTaskInfo.getStats(), this.initialTaskInfo.isNeedsPlan());
        }

        private TaskStatus buildTaskStatus() {
            ++this.statusFetchCounter;
            switch (this.failureScenario) {
                case TASK_MISMATCH: 
                case TASK_MISMATCH_WHEN_VERSION_IS_HIGH: {
                    if (this.statusFetchCounter != 10L) break;
                    this.taskInstanceId = NEW_TASK_INSTANCE_ID;
                    this.version = 0L;
                    break;
                }
                case REJECTED_EXECUTION: {
                    if (this.statusFetchCounter < 10L) break;
                    this.httpClient.get().close();
                    throw new RejectedExecutionException();
                }
                case NO_FAILURE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return new TaskStatus(this.initialTaskStatus.getTaskId(), this.taskInstanceId, ++this.version, this.taskState, this.initialTaskStatus.getSelf(), "fake", (Set)ImmutableSet.of(), this.initialTaskStatus.getFailures(), this.initialTaskStatus.getQueuedPartitionedDrivers(), this.initialTaskStatus.getRunningPartitionedDrivers(), this.initialTaskStatus.isOutputBufferOverutilized(), this.initialTaskStatus.getPhysicalWrittenDataSize(), this.initialTaskStatus.getMemoryReservation(), this.initialTaskStatus.getSystemMemoryReservation(), this.initialTaskStatus.getRevocableMemoryReservation(), this.initialTaskStatus.getFullGcCount(), this.initialTaskStatus.getFullGcTime(), this.dynamicFilterDomains.map(DynamicFiltersCollector.VersionedDynamicFilterDomains::getVersion).orElse(0L).longValue());
        }
    }

    private static enum FailureScenario {
        NO_FAILURE,
        TASK_MISMATCH,
        TASK_MISMATCH_WHEN_VERSION_IS_HIGH,
        REJECTED_EXECUTION;

    }
}

