/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.prestosql.server.security.InsecureAuthenticatorConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.testng.annotations.Test;

public class TestInsecureAuthenticatorConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((InsecureAuthenticatorConfig)ConfigAssertions.recordDefaults(InsecureAuthenticatorConfig.class)).setUserMappingPattern(null).setUserMappingFile(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path userMappingFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"http-server.authentication.insecure.user-mapping.pattern", (Object)"(.*)@something").put((Object)"http-server.authentication.insecure.user-mapping.file", (Object)userMappingFile.toString()).build();
        InsecureAuthenticatorConfig expected = new InsecureAuthenticatorConfig().setUserMappingPattern("(.*)@something").setUserMappingFile(userMappingFile.toFile());
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

