/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.prestosql.server.security.SecurityConfig;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestSecurityConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((SecurityConfig)ConfigAssertions.recordDefaults(SecurityConfig.class)).setAuthenticationTypes("insecure").setInsecureAuthenticationOverHttpAllowed(true).setFixedManagementUser(null).setFixedManagementUserForHttps(false));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"http-server.authentication.type", (Object)"KERBEROS,PASSWORD").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"false").put((Object)"management.user", (Object)"management-user").put((Object)"management.user.https-enabled", (Object)"true").build();
        SecurityConfig expected = new SecurityConfig().setAuthenticationTypes((List)ImmutableList.of((Object)"KERBEROS", (Object)"PASSWORD")).setInsecureAuthenticationOverHttpAllowed(false).setFixedManagementUser("management-user").setFixedManagementUserForHttps(true);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

