/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security.jwt;

import com.google.common.net.MediaType;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Response;
import io.airlift.http.client.testing.TestingHttpClient;
import io.airlift.http.client.testing.TestingResponse;
import io.airlift.units.Duration;
import io.prestosql.server.security.jwt.JwkService;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestJwkService {
    private static final String EMPTY_KEYS = "{ \"keys\": [] }";
    private static final String TEST_JWK_RESPONSE = "{\n  \"keys\": [\n    {\n      \"e\": \"AQAB\",\n      \"n\": \"mvj-0waJ2owQlFWrlC06goLs9PcNehIzCF0QrkdsYZJXOsipcHCFlXBsgQIdTdLvlCzNI07jSYA-zggycYi96lfDX-FYv_CqC8dRLf9TBOPvUgCyFMCFNUTC69hsrEYMR_J79Wj0MIOffiVr6eX-AaCG3KhBMZMh15KCdn3uVrl9coQivy7bk2Uw-aUJ_b26C0gWYj1DnpO4UEEKBk1X-lpeUMh0B_XorqWeq0NYK2pN6CoEIh0UrzYKlGfdnMU1pJJCsNxMiha-Vw3qqxez6oytOV_AswlWvQc7TkSX6cHfqepNskQb7pGxpgQpy9sA34oIxB_S-O7VS7_h0Qh4vQ\",\n      \"alg\": \"RS256\",\n      \"use\": \"sig\",\n      \"kty\": \"RSA\",\n      \"kid\": \"test-rsa\"\n    },\n    {\n      \"kty\": \"EC\",\n      \"use\": \"sig\",\n      \"crv\": \"P-256\",\n      \"kid\": \"test-ec\",\n      \"x\": \"W9pnAHwUz81LldKjL3BzxO1iHe1Pc0fO6rHkrybVy6Y\",\n      \"y\": \"XKSNmn_xajgOvWuAiJnWx5I46IwPVJJYPaEpsX3NPZg\",\n      \"alg\": \"ES256\"\n    }\n  ]\n}";

    @Test
    public void testSuccess() {
        TestingHttpClient httpClient = new TestingHttpClient(request -> TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)TEST_JWK_RESPONSE));
        JwkService service = new JwkService(URI.create("http://example.com"), (HttpClient)httpClient, new Duration(1.0, TimeUnit.DAYS));
        TestJwkService.assertTestKeys(service);
    }

    @Test
    public void testReload() {
        AtomicReference<Response> response = new AtomicReference<Response>(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)EMPTY_KEYS));
        JwkService service = new JwkService(URI.create("http://example.com"), (HttpClient)new TestingHttpClient(request -> (Response)response.get()), new Duration(1.0, TimeUnit.DAYS));
        TestJwkService.assertEmptyKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)EMPTY_KEYS));
        service.refreshKeys();
        TestJwkService.assertEmptyKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)TEST_JWK_RESPONSE));
        service.refreshKeys();
        TestJwkService.assertTestKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)TEST_JWK_RESPONSE));
        service.refreshKeys();
        TestJwkService.assertTestKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)EMPTY_KEYS));
        service.refreshKeys();
        TestJwkService.assertEmptyKeys(service);
    }

    @Test
    public void testTimedReload() throws InterruptedException {
        AtomicReference<Supplier<Response>> response = new AtomicReference<Supplier<Response>>(() -> TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)EMPTY_KEYS));
        JwkService service = new JwkService(URI.create("http://example.com"), (HttpClient)new TestingHttpClient(request -> (Response)((Supplier)response.get()).get()), new Duration(1.0, TimeUnit.MILLISECONDS));
        TestJwkService.assertEmptyKeys(service);
        try {
            response.set(() -> TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)EMPTY_KEYS));
            service.start();
            while (!service.getKeys().isEmpty()) {
                Thread.sleep(1000L);
            }
            response.set(() -> TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)TEST_JWK_RESPONSE));
            while (service.getKeys().isEmpty()) {
                Thread.sleep(1000L);
            }
            TestJwkService.assertTestKeys(service);
        }
        finally {
            service.stop();
        }
    }

    @Test
    public void testRequestFailure() {
        AtomicReference<Response> response = new AtomicReference<Response>(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)TEST_JWK_RESPONSE));
        JwkService service = new JwkService(URI.create("http://example.com"), (HttpClient)new TestingHttpClient(request -> {
            Response value = (Response)response.get();
            if (value == null) {
                throw new IllegalArgumentException("test");
            }
            return value;
        }), new Duration(1.0, TimeUnit.DAYS));
        TestJwkService.assertTestKeys(service);
        response.set(null);
        Assertions.assertThatThrownBy(() -> ((JwkService)service).refreshKeys()).hasMessage("Error reading JWK keys from http://example.com").isInstanceOf(RuntimeException.class);
        TestJwkService.assertTestKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)EMPTY_KEYS));
        service.refreshKeys();
        TestJwkService.assertEmptyKeys(service);
    }

    @Test
    public void testBadResponse() {
        AtomicReference<Response> response = new AtomicReference<Response>(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)TEST_JWK_RESPONSE));
        JwkService service = new JwkService(URI.create("http://example.com"), (HttpClient)new TestingHttpClient(request -> (Response)response.get()), new Duration(1.0, TimeUnit.DAYS));
        TestJwkService.assertTestKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.CREATED, (MediaType)MediaType.JSON_UTF_8, (String)""));
        Assertions.assertThatThrownBy(() -> ((JwkService)service).refreshKeys()).hasMessage("Unexpected response code 201 from JWK service at http://example.com").isInstanceOf(RuntimeException.class);
        TestJwkService.assertTestKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)""));
        Assertions.assertThatThrownBy(() -> ((JwkService)service).refreshKeys()).hasMessage("Unable to decode JWK response from http://example.com").isInstanceOf(RuntimeException.class);
        TestJwkService.assertTestKeys(service);
        response.set(TestingResponse.mockResponse((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON_UTF_8, (String)EMPTY_KEYS));
        service.refreshKeys();
        TestJwkService.assertEmptyKeys(service);
    }

    private static void assertEmptyKeys(JwkService service) {
        Assert.assertEquals((int)service.getKeys().size(), (int)0);
    }

    private static void assertTestKeys(JwkService service) {
        Map keys = service.getKeys();
        Assert.assertEquals((int)keys.size(), (int)2);
        Assert.assertTrue((boolean)keys.containsKey("test-rsa"));
        Assert.assertTrue((boolean)keys.containsKey("test-ec"));
    }
}

