/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security.jwt;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.prestosql.server.security.jwt.JwtAuthenticatorConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.testng.annotations.Test;

public class TestJwtAuthenticatorConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((JwtAuthenticatorConfig)ConfigAssertions.recordDefaults(JwtAuthenticatorConfig.class)).setKeyFile(null).setRequiredAudience(null).setRequiredIssuer(null).setUserMappingPattern(null).setUserMappingFile(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path jwtKeyFile = Files.createTempFile(null, null, new FileAttribute[0]);
        Path userMappingFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"http-server.authentication.jwt.key-file", (Object)jwtKeyFile.toString()).put((Object)"http-server.authentication.jwt.required-audience", (Object)"some-audience").put((Object)"http-server.authentication.jwt.required-issuer", (Object)"some-issuer").put((Object)"http-server.authentication.jwt.user-mapping.pattern", (Object)"(.*)@something").put((Object)"http-server.authentication.jwt.user-mapping.file", (Object)userMappingFile.toString()).build();
        JwtAuthenticatorConfig expected = new JwtAuthenticatorConfig().setKeyFile(jwtKeyFile.toString()).setRequiredAudience("some-audience").setRequiredIssuer("some-issuer").setUserMappingPattern("(.*)@something").setUserMappingFile(userMappingFile.toFile());
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

