/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security.oauth2;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.Duration;
import io.prestosql.server.security.oauth2.OAuth2Config;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.testng.annotations.Test;

public class TestOAuth2Config {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((OAuth2Config)ConfigAssertions.recordDefaults(OAuth2Config.class)).setStateKey(null).setAuthUrl(null).setTokenUrl(null).setJwksUrl(null).setClientId(null).setClientSecret(null).setChallengeTimeout(Duration.valueOf((String)"15m")).setUserMappingPattern(null).setUserMappingFile(null));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path userMappingFile = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"http-server.authentication.oauth2.state-key", (Object)"key-secret").put((Object)"http-server.authentication.oauth2.auth-url", (Object)"http://127.0.0.1:9000/oauth2/auth").put((Object)"http-server.authentication.oauth2.token-url", (Object)"http://127.0.0.1:9000/oauth2/token").put((Object)"http-server.authentication.oauth2.jwks-url", (Object)"http://127.0.0.1:9000/.well-known/jwks.json").put((Object)"http-server.authentication.oauth2.client-id", (Object)"another-consumer").put((Object)"http-server.authentication.oauth2.client-secret", (Object)"consumer-secret").put((Object)"http-server.authentication.oauth2.challenge-timeout", (Object)"90s").put((Object)"http-server.authentication.oauth2.user-mapping.pattern", (Object)"(.*)@something").put((Object)"http-server.authentication.oauth2.user-mapping.file", (Object)userMappingFile.toString()).build();
        OAuth2Config expected = new OAuth2Config().setStateKey("key-secret").setAuthUrl("http://127.0.0.1:9000/oauth2/auth").setTokenUrl("http://127.0.0.1:9000/oauth2/token").setJwksUrl("http://127.0.0.1:9000/.well-known/jwks.json").setClientId("another-consumer").setClientSecret("consumer-secret").setChallengeTimeout(Duration.valueOf((String)"90s")).setUserMappingPattern("(.*)@something").setUserMappingFile(userMappingFile.toFile());
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

