/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security.oauth2;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.inject.Module;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.log.Logging;
import io.airlift.testing.Closeables;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.impl.DefaultClaims;
import io.prestosql.client.OkHttpUtil;
import io.prestosql.server.security.jwt.JwkService;
import io.prestosql.server.security.jwt.JwkSigningKeyResolver;
import io.prestosql.server.security.jwt.JwtAuthenticatorConfig;
import io.prestosql.server.security.oauth2.TestingHydraService;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.server.ui.WebUiModule;
import io.prestosql.testng.services.Flaky;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.security.Key;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.testcontainers.Testcontainers;
import org.testcontainers.containers.BrowserWebDriverContainer;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestOAuth2WebUiAuthenticationFilter {
    private static final int HTTPS_PORT = TestOAuth2WebUiAuthenticationFilter.findAvailablePort();
    private final TestingHydraService testingHydraService = new TestingHydraService();
    private final OkHttpClient httpClient;
    private TestingPrestoServer server;
    private URI serverUri;

    public TestOAuth2WebUiAuthenticationFilter() {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        OkHttpUtil.setupInsecureSsl((OkHttpClient.Builder)httpClientBuilder);
        httpClientBuilder.followRedirects(false);
        this.httpClient = httpClientBuilder.build();
    }

    @BeforeClass
    public void setup() throws Exception {
        Logging.initialize();
        Testcontainers.exposeHostPorts((int[])new int[]{HTTPS_PORT});
        this.testingHydraService.start();
        this.testingHydraService.createConsumer(String.format("https://host.testcontainers.internal:%d/oauth2/callback", HTTPS_PORT));
        this.server = TestingPrestoServer.builder().setCoordinator(true).setAdditionalModule((Module)new WebUiModule()).setProperties((Map)ImmutableMap.builder().put((Object)"web-ui.enabled", (Object)"true").put((Object)"web-ui.authentication.type", (Object)"oauth2").put((Object)"http-server.https.port", (Object)Integer.toString(HTTPS_PORT)).put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.keystore.path", (Object)Resources.getResource((String)"cert/localhost.pem").getPath()).put((Object)"http-server.https.keystore.key", (Object)"").put((Object)"http-server.authentication.oauth2.auth-url", (Object)"http://hydra:4444/oauth2/auth").put((Object)"http-server.authentication.oauth2.token-url", (Object)String.format("http://localhost:%s/oauth2/token", this.testingHydraService.getHydraPort())).put((Object)"http-server.authentication.oauth2.jwks-url", (Object)String.format("http://localhost:%s/.well-known/jwks.json", this.testingHydraService.getHydraPort())).put((Object)"http-server.authentication.oauth2.client-id", (Object)"another-consumer").put((Object)"http-server.authentication.oauth2.client-secret", (Object)"consumer-secret").put((Object)"http-server.authentication.oauth2.user-mapping.pattern", (Object)"(.*)@.*").build()).build();
        this.server.waitForNodeRefresh(Duration.ofSeconds(10L));
        this.serverUri = this.server.getHttpsBaseUrl();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() throws Exception {
        Closeables.closeAll((AutoCloseable[])new AutoCloseable[]{this.server, this.testingHydraService});
    }

    @Test
    public void testUnauthorizedApiCall() throws IOException {
        try (Response response = this.httpClient.newCall(this.uiCall().build()).execute();){
            TestOAuth2WebUiAuthenticationFilter.assertUnauthorizedUICall(response);
        }
    }

    @Test
    public void testUnauthorizedUICall() throws IOException {
        try (Response response = this.httpClient.newCall(this.uiCall().build()).execute();){
            TestOAuth2WebUiAuthenticationFilter.assertUnauthorizedUICall(response);
        }
    }

    @Test
    public void testInvalidToken() throws NoSuchAlgorithmException, IOException {
        KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance("RSA");
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.RS256;
        keyGenerator.initialize(4096);
        String token = Jwts.builder().setHeaderParam("alg", (Object)"RS256").setHeaderParam("kid", (Object)"public:f467aa08-1c1b-4cde-ba45-84b0ef5d2ba8").setHeaderParam("typ", (Object)"JWT").setClaims((Claims)new DefaultClaims((Map)ImmutableMap.builder().put((Object)"aud", (Object)ImmutableList.of()).put((Object)"client_id", (Object)"another-consumer").put((Object)"exp", (Object)(System.currentTimeMillis() / 1000L + 60L)).put((Object)"iat", (Object)System.currentTimeMillis()).put((Object)"iss", (Object)"http://hydra:4444/").put((Object)"jti", (Object)UUID.randomUUID()).put((Object)"nbf", (Object)(System.currentTimeMillis() - 60L)).put((Object)"scp", (Object)ImmutableList.of((Object)"openid")).put((Object)"sub", (Object)"foo@bar.com").build())).signWith(signatureAlgorithm, (Key)keyGenerator.generateKeyPair().getPrivate()).compact();
        try (Response response = this.httpClient.newCall(this.uiCall().header("Authorization", "Bearer " + token).build()).execute();){
            TestOAuth2WebUiAuthenticationFilter.assertUnauthorizedUICall(response);
        }
    }

    @Test
    public void testSuccessfulFlow() throws Exception {
        this.withSuccessfulAuthentication((driver, wait) -> {
            Cookie cookie = driver.manage().getCookieNamed("Presto-OAuth2-Token");
            this.assertPrestoCookie(cookie);
            this.assertUICallWithCookie(cookie);
        });
    }

    @Test
    @Flaky(issue="https://github.com/prestosql/presto/issues/6223", match="Presto-OAuth2-Token is missing")
    public void testExpiredAccessToken() throws Exception {
        this.withSuccessfulAuthentication((driver, wait) -> {
            Cookie cookie = driver.manage().getCookieNamed("Presto-OAuth2-Token");
            ((ObjectAssert)Assertions.assertThat((Object)cookie).withFailMessage("Presto-OAuth2-Token is missing", new Object[0])).isNotNull();
            Thread.sleep(6000L);
            try (Response response = this.httpClient.newCall(this.uiCall().header("Authorization", "Bearer " + cookie.getValue()).build()).execute();){
                TestOAuth2WebUiAuthenticationFilter.assertUnauthorizedUICall(response);
            }
        });
    }

    private Request.Builder uiCall() {
        return new Request.Builder().url(this.serverUri.resolve("/ui/").toString()).get();
    }

    private void withSuccessfulAuthentication(AuthenticationAssertion assertion) throws Exception {
        try (BrowserWebDriverContainer<?> browser = this.createChromeContainer();){
            RemoteWebDriver driver = browser.getWebDriver();
            driver.get(String.format("https://host.testcontainers.internal:%d/ui/", HTTPS_PORT));
            WebDriverWait wait = new WebDriverWait((WebDriver)driver, 5L);
            this.submitCredentials((WebDriver)driver, "foo@bar.com", "foobar", wait);
            this.giveConsent((WebDriver)driver, wait);
            wait.until((Function)ExpectedConditions.urlMatches((String)String.format("https://host.testcontainers.internal:%d/ui/", HTTPS_PORT)));
            assertion.assertWith((WebDriver)driver, wait);
        }
    }

    private BrowserWebDriverContainer<?> createChromeContainer() {
        ChromeOptions options = new ChromeOptions();
        options.setAcceptInsecureCerts(true);
        BrowserWebDriverContainer chromeContainer = ((BrowserWebDriverContainer)new BrowserWebDriverContainer().withNetwork(this.testingHydraService.getNetwork())).withCapabilities((Capabilities)options);
        chromeContainer.start();
        return chromeContainer;
    }

    private void submitCredentials(WebDriver driver, String email, String password, WebDriverWait wait) {
        By emailElementLocator = By.id((String)"email");
        wait.until((Function)ExpectedConditions.elementToBeClickable((By)emailElementLocator));
        WebElement usernameElement = driver.findElement(emailElementLocator);
        usernameElement.sendKeys(new CharSequence[]{email});
        By passwordElementLocator = By.id((String)"password");
        wait.until((Function)ExpectedConditions.elementToBeClickable((By)passwordElementLocator));
        WebElement passwordElement = driver.findElement(passwordElementLocator);
        passwordElement.sendKeys(new CharSequence[]{password + "\n"});
    }

    private void giveConsent(WebDriver driver, WebDriverWait wait) {
        By openIdCheckboxLocator = By.id((String)"openid");
        wait.until((Function)ExpectedConditions.elementToBeClickable((By)openIdCheckboxLocator));
        WebElement openIdCheckbox = driver.findElement(openIdCheckboxLocator);
        openIdCheckbox.click();
        By acceptButtonLocator = By.id((String)"accept");
        wait.until((Function)ExpectedConditions.elementToBeClickable((By)acceptButtonLocator));
        WebElement acceptButton = driver.findElement(acceptButtonLocator);
        acceptButton.click();
    }

    private void assertPrestoCookie(Cookie cookie) {
        Assertions.assertThat((String)cookie.getName()).isEqualTo("Presto-OAuth2-Token");
        Assertions.assertThat((String)cookie.getDomain()).isEqualTo("host.testcontainers.internal");
        Assertions.assertThat((String)cookie.getPath()).isEqualTo("/ui/");
        Assertions.assertThat((boolean)cookie.isSecure()).isTrue();
        Assertions.assertThat((boolean)cookie.isHttpOnly()).isTrue();
        Assertions.assertThat((String)cookie.getValue()).isNotBlank();
        Jws jwt = Jwts.parser().setSigningKeyResolver((SigningKeyResolver)new JwkSigningKeyResolver(new JwkService(new JwtAuthenticatorConfig().setKeyFile("http://localhost:" + this.testingHydraService.getHydraPort() + "/.well-known/jwks.json"), (HttpClient)new JettyHttpClient()))).parseClaimsJws(cookie.getValue());
        io.airlift.testing.Assertions.assertLessThan((Comparable)Duration.between(cookie.getExpiry().toInstant(), ((Claims)jwt.getBody()).getExpiration().toInstant()), (Comparable)Duration.ofSeconds(5L));
        this.assertAccessToken((Jws<Claims>)jwt);
    }

    private void assertAccessToken(Jws<Claims> jwt) {
        Assertions.assertThat((String)((Claims)jwt.getBody()).getSubject()).isEqualTo("foo@bar.com");
        Assertions.assertThat((Object)((Claims)jwt.getBody()).get((Object)"client_id")).isEqualTo((Object)"another-consumer");
        Assertions.assertThat((String)((Claims)jwt.getBody()).getIssuer()).isEqualTo("http://hydra:4444/");
    }

    private void assertUICallWithCookie(final Cookie cookie) throws IOException {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        OkHttpUtil.setupInsecureSsl((OkHttpClient.Builder)httpClientBuilder);
        httpClientBuilder.followRedirects(false);
        httpClientBuilder.cookieJar(new CookieJar(){

            public void saveFromResponse(HttpUrl url, List<okhttp3.Cookie> cookies) {
            }

            public List<okhttp3.Cookie> loadForRequest(HttpUrl url) {
                return ImmutableList.of((Object)new Cookie.Builder().domain("localhost").path("/ui/").name("Presto-OAuth2-Token").value(cookie.getValue()).httpOnly().secure().build());
            }
        });
        Assertions.assertThat((int)httpClientBuilder.build().newCall(this.uiCall().build()).execute().code()).isEqualTo(Response.Status.OK.getStatusCode());
    }

    private static int findAvailablePort() {
        int n;
        ServerSocket tempSocket = new ServerSocket(0);
        try {
            n = tempSocket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    tempSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        tempSocket.close();
        return n;
    }

    private static void assertUnauthorizedUICall(Response response) throws MalformedURLException {
        Assertions.assertThat((int)response.code()).isEqualTo(Response.Status.SEE_OTHER.getStatusCode());
        TestOAuth2WebUiAuthenticationFilter.assertRedirectUrl(response.header("Location"));
    }

    private static void assertRedirectUrl(String redirectUrl) throws MalformedURLException {
        Assertions.assertThat((String)redirectUrl).isNotNull();
        URL location = new URL(redirectUrl);
        HttpUrl url = HttpUrl.parse((String)redirectUrl);
        Assertions.assertThat((Object)url).isNotNull();
        Assertions.assertThat((String)location.getProtocol()).isEqualTo("http");
        Assertions.assertThat((String)location.getHost()).isEqualTo("hydra");
        Assertions.assertThat((int)location.getPort()).isEqualTo(4444);
        Assertions.assertThat((String)location.getPath()).isEqualTo("/oauth2/auth");
        Assertions.assertThat((List)url.queryParameterValues("response_type")).isEqualTo((Object)ImmutableList.of((Object)"code"));
        Assertions.assertThat((List)url.queryParameterValues("scope")).isEqualTo((Object)ImmutableList.of((Object)"openid"));
        Assertions.assertThat((List)url.queryParameterValues("redirect_uri")).isEqualTo((Object)ImmutableList.of((Object)String.format("https://127.0.0.1:%s/oauth2/callback", HTTPS_PORT)));
        Assertions.assertThat((List)url.queryParameterValues("client_id")).isEqualTo((Object)ImmutableList.of((Object)"another-consumer"));
        Assertions.assertThat((List)url.queryParameterValues("state")).isNotNull();
    }

    private static interface AuthenticationAssertion {
        public void assertWith(WebDriver var1, WebDriverWait var2) throws Exception;
    }
}

