/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security.oauth2;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.inject.Module;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.server.ui.WebUiModule;
import io.prestosql.util.AutoCloseableCloser;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.Base64;
import java.util.Map;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.startupcheck.OneShotStartupCheckStrategy;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class TestingHydraService
implements AutoCloseable {
    static final int TTL_ACCESS_TOKEN_IN_SECONDS = 5;
    private static final String HYDRA_IMAGE = "oryd/hydra:v1.4.2";
    private static final String DSN = "postgres://hydra:mysecretpassword@database:5432/hydra?sslmode=disable";
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final Network network = Network.newNetwork();
    private final PostgreSQLContainer<?> databaseContainer = ((PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer().withNetwork(this.network)).withNetworkAliases(new String[]{"database"})).withUsername("hydra").withPassword("mysecretpassword").withDatabaseName("hydra");
    private final GenericContainer<?> migrationContainer = ((FixedHostPortGenericContainer)this.createHydraContainer().withCommand("migrate sql --yes postgres://hydra:mysecretpassword@database:5432/hydra?sslmode=disable")).withStartupCheckStrategy(new OneShotStartupCheckStrategy().withTimeout(Duration.ofMinutes(5L)));
    private final FixedHostPortGenericContainer<?> consentContainer = (FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)new FixedHostPortGenericContainer("oryd/hydra-login-consent-node:v1.4.2").withNetwork(this.network)).withNetworkAliases(new String[]{"consent"})).withExposedPorts(new Integer[]{3000})).withEnv("HYDRA_ADMIN_URL", "http://hydra:4445")).withEnv("NODE_TLS_REJECT_UNAUTHORIZED", "0")).waitingFor((WaitStrategy)Wait.forHttp((String)"/").forStatusCode(200));
    private final FixedHostPortGenericContainer<?> hydraContainer = (FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)this.createHydraContainer().withNetworkAliases(new String[]{"hydra"})).withExposedPorts(new Integer[]{4444, 4445})).withEnv("SECRETS_SYSTEM", TestingHydraService.generateSecret())).withEnv("DSN", "postgres://hydra:mysecretpassword@database:5432/hydra?sslmode=disable")).withEnv("URLS_SELF_ISSUER", "http://hydra:4444/")).withEnv("URLS_CONSENT", "http://consent:3000/consent")).withEnv("URLS_LOGIN", "http://consent:3000/login")).withEnv("OAUTH2_ACCESS_TOKEN_STRATEGY", "jwt")).withEnv("TTL_ACCESS_TOKEN", "5s")).withCommand("serve all --dangerous-force-http")).waitingFor((WaitStrategy)Wait.forHttp((String)"/health/ready").forPort(4444).forStatusCode(200));
    private final AutoCloseableCloser closer = AutoCloseableCloser.create();

    TestingHydraService() {
        this.closer.register((AutoCloseable)this.network);
        this.closer.register(this.databaseContainer);
        this.closer.register(this.migrationContainer);
        this.closer.register(this.consentContainer);
        this.closer.register(this.hydraContainer);
    }

    public void start() {
        this.databaseContainer.start();
        this.migrationContainer.start();
        this.consentContainer.start();
        this.hydraContainer.start();
    }

    public FixedHostPortGenericContainer<?> createHydraContainer() {
        return (FixedHostPortGenericContainer)new FixedHostPortGenericContainer(HYDRA_IMAGE).withNetwork(this.network);
    }

    public void createConsumer(String callback) {
        ((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)this.createHydraContainer().withCommand("clients create --endpoint http://hydra:4445 --id another-consumer --secret consumer-secret -g authorization_code,refresh_token -r token,code,id_token --scope openid,offline --callbacks " + callback)).withStartupCheckStrategy(new OneShotStartupCheckStrategy().withTimeout(Duration.ofSeconds(30L)))).start();
    }

    public Network getNetwork() {
        return this.network;
    }

    public int getHydraPort() {
        return this.hydraContainer.getMappedPort(4444);
    }

    @Override
    public void close() throws Exception {
        this.closer.close();
    }

    private static String generateSecret() {
        byte[] randomBytes = new byte[32];
        SECURE_RANDOM.nextBytes(randomBytes);
        return Base64.getEncoder().encodeToString(randomBytes);
    }

    public static void main(String[] args) throws Exception {
        try (TestingHydraService service = new TestingHydraService();){
            service.consentContainer.withFixedExposedPort(9020, 3000);
            ((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)service.hydraContainer.withFixedExposedPort(9001, 4444).withFixedExposedPort(9002, 4445).withEnv("URLS_SELF_ISSUER", "http://localhost:9001/")).withEnv("URLS_CONSENT", "http://localhost:9020/consent")).withEnv("URLS_LOGIN", "http://localhost:9020/login")).withEnv("TTL_ACCESS_TOKEN", "30m");
            service.start();
            service.createConsumer("https://localhost:8443/oauth2/callback");
            try (TestingPrestoServer ignored = TestingPrestoServer.builder().setCoordinator(true).setAdditionalModule((Module)new WebUiModule()).setProperties((Map)ImmutableMap.builder().put((Object)"web-ui.enabled", (Object)"true").put((Object)"web-ui.authentication.type", (Object)"oauth2").put((Object)"http-server.https.port", (Object)"8443").put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.keystore.path", (Object)Resources.getResource((String)"cert/localhost.pem").getPath()).put((Object)"http-server.https.keystore.key", (Object)"").put((Object)"http-server.authentication.oauth2.auth-url", (Object)"http://localhost:9001/oauth2/auth").put((Object)"http-server.authentication.oauth2.token-url", (Object)"http://localhost:9001/oauth2/token").put((Object)"http-server.authentication.oauth2.jwks-url", (Object)"http://localhost:9001/.well-known/jwks.json").put((Object)"http-server.authentication.oauth2.client-id", (Object)"another-consumer").put((Object)"http-server.authentication.oauth2.client-secret", (Object)"consumer-secret").put((Object)"http-server.authentication.oauth2.user-mapping.pattern", (Object)"(.*)@.*").build()).build();){
                Thread.sleep(Long.MAX_VALUE);
            }
        }
    }
}

