/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.ui;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.hash.Hashing;
import com.google.common.io.Resources;
import com.google.inject.Binder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.testing.TestingHttpServer;
import io.airlift.node.NodeInfo;
import io.airlift.security.pem.PemReader;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.prestosql.client.OkHttpUtil;
import io.prestosql.server.security.PasswordAuthenticatorManager;
import io.prestosql.server.security.oauth2.OAuth2Client;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.server.ui.FormAuthenticator;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.BasicPrincipal;
import io.prestosql.testing.assertions.Assert;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class TestWebUi {
    private static final String LOCALHOST_KEYSTORE = Resources.getResource((String)"cert/localhost.pem").getPath();
    private static final ImmutableMap<String, String> SECURE_PROPERTIES = ImmutableMap.builder().put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.keystore.path", (Object)LOCALHOST_KEYSTORE).put((Object)"http-server.https.keystore.key", (Object)"").put((Object)"http-server.process-forwarded", (Object)"true").put((Object)"http-server.authentication.allow-insecure-over-http", (Object)"true").build();
    private static final String TEST_USER = "test-user";
    private static final String TEST_PASSWORD = "test-password";
    private static final String HMAC_KEY = Resources.getResource((String)"hmac_key.txt").getPath();
    private static final PrivateKey JWK_PRIVATE_KEY;
    private OkHttpClient client;

    @BeforeClass
    public void setup() {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().followRedirects(false);
        OkHttpUtil.setupSsl((OkHttpClient.Builder)clientBuilder, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.empty());
        this.client = clientBuilder.build();
    }

    @Test
    public void testInsecureAuthenticator() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties(SECURE_PROPERTIES).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.testFormAuthentication(server, httpServerInfo, false);
        }
    }

    @Test
    public void testPasswordAuthenticator() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"password").build()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticator(TestWebUi::authenticate);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.testFormAuthentication(server, httpServerInfo, true);
        }
    }

    private void testFormAuthentication(TestingPrestoServer server, HttpServerInfo httpServerInfo, boolean sendPasswordForHttps) throws Exception {
        TestWebUi.testRootRedirect(httpServerInfo.getHttpUri(), this.client);
        TestWebUi.testRootRedirect(httpServerInfo.getHttpsUri(), this.client);
        String nodeId = ((NodeInfo)server.getInstance(com.google.inject.Key.get(NodeInfo.class))).getNodeId();
        this.testWorkerResource(nodeId, httpServerInfo.getHttpUri(), false);
        this.testWorkerResource(nodeId, httpServerInfo.getHttpsUri(), sendPasswordForHttps);
        this.testLoggedOut(httpServerInfo.getHttpUri());
        this.testLoggedOut(httpServerInfo.getHttpsUri());
        this.testLogIn(httpServerInfo.getHttpUri(), false);
        this.testLogIn(httpServerInfo.getHttpsUri(), sendPasswordForHttps);
        this.testFailedLogin(httpServerInfo.getHttpUri(), false);
        this.testFailedLogin(httpServerInfo.getHttpsUri(), sendPasswordForHttps);
    }

    private static void testRootRedirect(URI baseUri, OkHttpClient client) throws IOException {
        TestWebUi.assertRedirect(client, HttpUriBuilder.uriBuilderFrom((URI)baseUri).toString(), TestWebUi.getUiLocation(baseUri));
    }

    private void testLoggedOut(URI baseUri) throws IOException {
        TestWebUi.assertRedirect(this.client, TestWebUi.getUiLocation(baseUri), TestWebUi.getLoginHtmlLocation(baseUri));
        TestWebUi.assertRedirect(this.client, TestWebUi.getLocation(baseUri, "/ui/query.html", "abc123"), TestWebUi.getLocation(baseUri, "/ui/login.html", "/ui/query.html?abc123"), false);
        TestWebUi.assertResponseCode(this.client, TestWebUi.getValidApiLocation(baseUri), 401);
        TestWebUi.assertOk(this.client, TestWebUi.getValidAssetsLocation(baseUri));
        TestWebUi.assertOk(this.client, TestWebUi.getValidVendorLocation(baseUri));
    }

    private void testLogIn(URI baseUri, boolean sendPassword) throws Exception {
        CookieManager cookieManager = new CookieManager();
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).build();
        String body = TestWebUi.assertOk(client, TestWebUi.getLoginHtmlLocation(baseUri)).orElseThrow(() -> new AssertionError((Object)"No response body"));
        Assertions.assertThat((String)body).contains(new CharSequence[]{"action=\"/ui/login\""});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"method=\"post\""});
        Assertions.assertThat((String)body).doesNotContain(new CharSequence[]{"// This value will be replaced"});
        if (sendPassword) {
            Assertions.assertThat((String)body).contains(new CharSequence[]{"var hidePassword = false;"});
        } else {
            Assertions.assertThat((String)body).contains(new CharSequence[]{"var hidePassword = true;"});
        }
        TestWebUi.logIn(baseUri, client, sendPassword);
        HttpCookie cookie = (HttpCookie)Iterables.getOnlyElement(cookieManager.getCookieStore().getCookies());
        Assert.assertEquals((String)cookie.getPath(), (String)"/ui");
        Assert.assertEquals((String)cookie.getDomain(), (String)baseUri.getHost());
        Assert.assertEquals((long)cookie.getMaxAge(), (long)-1L);
        org.testng.Assert.assertTrue((boolean)cookie.isHttpOnly());
        TestWebUi.assertOk(client, TestWebUi.getUiLocation(baseUri));
        TestWebUi.assertOk(client, TestWebUi.getValidApiLocation(baseUri));
        TestWebUi.assertResponseCode(client, TestWebUi.getLocation(baseUri, "/ui/unknown"), 404);
        TestWebUi.assertResponseCode(client, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), 404);
        TestWebUi.assertRedirect(client, TestWebUi.getLogoutLocation(baseUri), TestWebUi.getLoginHtmlLocation(baseUri), false);
        Assertions.assertThat(cookieManager.getCookieStore().getCookies()).isEmpty();
    }

    private void testFailedLogin(URI uri, boolean passwordAllowed) throws IOException {
        this.testFailedLogin(uri, Optional.empty(), Optional.empty());
        this.testFailedLogin(uri, Optional.empty(), Optional.of(TEST_PASSWORD));
        this.testFailedLogin(uri, Optional.empty(), Optional.of("unknown"));
        if (passwordAllowed) {
            this.testFailedLogin(uri, Optional.of(TEST_USER), Optional.of("unknown"));
            this.testFailedLogin(uri, Optional.of("unknown"), Optional.of(TEST_PASSWORD));
            this.testFailedLogin(uri, Optional.of(TEST_USER), Optional.empty());
            this.testFailedLogin(uri, Optional.of("unknown"), Optional.empty());
        }
    }

    private void testFailedLogin(URI httpsUrl, Optional<String> username, Optional<String> password) throws IOException {
        CookieManager cookieManager = new CookieManager();
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).build();
        FormBody.Builder formData = new FormBody.Builder();
        username.ifPresent(value -> formData.add("username", value));
        password.ifPresent(value -> formData.add("password", value));
        Request request = new Request.Builder().url(TestWebUi.getLoginLocation(httpsUrl)).post((RequestBody)formData.build()).build();
        try (Response response = client.newCall(request).execute();){
            Assert.assertEquals((int)response.code(), (int)303);
            Assert.assertEquals((String)response.header("Location"), (String)TestWebUi.getLoginHtmlLocation(httpsUrl));
            org.testng.Assert.assertTrue((boolean)cookieManager.getCookieStore().getCookies().isEmpty());
        }
    }

    private void testWorkerResource(String nodeId, URI baseUri, boolean sendPassword) throws Exception {
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)new CookieManager())).build();
        TestWebUi.logIn(baseUri, client, sendPassword);
        TestWebUi.testWorkerResource(nodeId, baseUri, client);
    }

    private static void testWorkerResource(String nodeId, URI baseUri, OkHttpClient authorizedClient) throws IOException {
        TestWebUi.assertOk(authorizedClient, TestWebUi.getLocation(baseUri, "/ui/api/worker/" + nodeId + "/status"));
        TestWebUi.assertOk(authorizedClient, TestWebUi.getLocation(baseUri, "/ui/api/worker/" + nodeId + "/thread"));
    }

    private static void logIn(URI baseUri, OkHttpClient client, boolean sendPassword) throws IOException {
        FormBody.Builder formData = new FormBody.Builder().add("username", TEST_USER);
        if (sendPassword) {
            formData.add("password", TEST_PASSWORD);
        }
        Request request = new Request.Builder().url(TestWebUi.getLoginLocation(baseUri)).post((RequestBody)formData.build()).build();
        Response response = client.newCall(request).execute();
        Assert.assertEquals((int)response.code(), (int)303);
        Assert.assertEquals((String)response.header("Location"), (String)TestWebUi.getUiLocation(baseUri));
    }

    @Test
    public void testDisabled() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"web-ui.enabled", (Object)"false").build()).build();){
            ((PasswordAuthenticatorManager)server.getInstance(com.google.inject.Key.get(PasswordAuthenticatorManager.class))).setAuthenticator(TestWebUi::authenticate);
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.testDisabled(httpServerInfo.getHttpUri());
            this.testDisabled(httpServerInfo.getHttpsUri());
        }
    }

    private void testDisabled(URI baseUri) throws Exception {
        TestWebUi.assertRedirect(this.client, TestWebUi.getUiLocation(baseUri), TestWebUi.getDisabledLocation(baseUri));
        TestWebUi.assertRedirect(this.client, TestWebUi.getLocation(baseUri, "/ui/query.html", "abc123"), TestWebUi.getDisabledLocation(baseUri));
        TestWebUi.assertResponseCode(this.client, TestWebUi.getValidApiLocation(baseUri), 401);
        TestWebUi.assertRedirect(this.client, TestWebUi.getLoginLocation(baseUri), TestWebUi.getDisabledLocation(baseUri));
        TestWebUi.assertRedirect(this.client, TestWebUi.getLogoutLocation(baseUri), TestWebUi.getDisabledLocation(baseUri));
        TestWebUi.assertOk(this.client, TestWebUi.getValidAssetsLocation(baseUri));
        TestWebUi.assertOk(this.client, TestWebUi.getValidVendorLocation(baseUri));
    }

    @Test
    public void testNoPasswordAuthenticator() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"password").build()).build();){
            FormAuthenticator formAuthenticator = (FormAuthenticator)server.getInstance(com.google.inject.Key.get(FormAuthenticator.class));
            Assertions.assertThatThrownBy(() -> formAuthenticator.isValidCredential(TEST_USER, TEST_USER, true)).hasMessage("authenticator was not loaded").isInstanceOf(IllegalStateException.class);
            org.testng.Assert.assertTrue((boolean)formAuthenticator.isLoginEnabled(true));
        }
    }

    @Test
    public void testFixedAuthenticator() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"web-ui.authentication.type", (Object)"fixed").put((Object)"web-ui.user", (Object)TEST_USER).build()).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            String nodeId = ((NodeInfo)server.getInstance(com.google.inject.Key.get(NodeInfo.class))).getNodeId();
            TestWebUi.testAlwaysAuthorized(httpServerInfo.getHttpUri(), this.client, nodeId);
            TestWebUi.testAlwaysAuthorized(httpServerInfo.getHttpsUri(), this.client, nodeId);
            this.testFixedAuthenticator(httpServerInfo.getHttpUri());
            this.testFixedAuthenticator(httpServerInfo.getHttpsUri());
        }
    }

    private void testFixedAuthenticator(URI baseUri) throws Exception {
        TestWebUi.assertOk(this.client, TestWebUi.getUiLocation(baseUri));
        TestWebUi.assertOk(this.client, TestWebUi.getValidApiLocation(baseUri));
        TestWebUi.assertResponseCode(this.client, TestWebUi.getLocation(baseUri, "/ui/unknown"), 404);
        TestWebUi.assertResponseCode(this.client, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), 404);
    }

    @Test
    public void testCertAuthenticator() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"certificate").put((Object)"http-server.https.truststore.path", (Object)LOCALHOST_KEYSTORE).put((Object)"http-server.https.truststore.key", (Object)"").build()).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            String nodeId = ((NodeInfo)server.getInstance(com.google.inject.Key.get(NodeInfo.class))).getNodeId();
            this.testLogIn(httpServerInfo.getHttpUri(), false);
            TestWebUi.testNeverAuthorized(httpServerInfo.getHttpsUri(), this.client);
            OkHttpClient.Builder clientBuilder = this.client.newBuilder();
            OkHttpUtil.setupSsl((OkHttpClient.Builder)clientBuilder, Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.empty(), Optional.of(LOCALHOST_KEYSTORE), Optional.empty(), Optional.empty());
            OkHttpClient clientWithCert = clientBuilder.build();
            TestWebUi.testAlwaysAuthorized(httpServerInfo.getHttpsUri(), clientWithCert, nodeId);
        }
    }

    @Test
    public void testJwtAuthenticator() throws Exception {
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"jwt").put((Object)"http-server.authentication.jwt.key-file", (Object)HMAC_KEY).build()).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            String nodeId = ((NodeInfo)server.getInstance(com.google.inject.Key.get(NodeInfo.class))).getNodeId();
            this.testLogIn(httpServerInfo.getHttpUri(), false);
            TestWebUi.testNeverAuthorized(httpServerInfo.getHttpsUri(), this.client);
            String hmac = Files.readString(Paths.get(HMAC_KEY, new String[0]));
            String token = Jwts.builder().signWith(SignatureAlgorithm.HS256, hmac).setSubject(TEST_USER).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
            OkHttpClient clientWithJwt = this.client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + token).build()).build();
            TestWebUi.testAlwaysAuthorized(httpServerInfo.getHttpsUri(), clientWithJwt, nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJwtWithJwkAuthenticator() throws Exception {
        TestingHttpServer jwkServer = TestWebUi.createTestingJwkServer();
        jwkServer.start();
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"http-server.authentication.type", (Object)"jwt").put((Object)"http-server.authentication.jwt.key-file", (Object)jwkServer.getBaseUrl().toString()).build()).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            String nodeId = ((NodeInfo)server.getInstance(com.google.inject.Key.get(NodeInfo.class))).getNodeId();
            this.testLogIn(httpServerInfo.getHttpUri(), false);
            TestWebUi.testNeverAuthorized(httpServerInfo.getHttpsUri(), this.client);
            String token = Jwts.builder().signWith(SignatureAlgorithm.RS256, (Key)JWK_PRIVATE_KEY).setHeaderParam("kid", (Object)"test-rsa").setSubject(TEST_USER).setExpiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
            OkHttpClient clientWithJwt = this.client.newBuilder().authenticator((route, response) -> response.request().newBuilder().header("Authorization", "Bearer " + token).build()).build();
            TestWebUi.testAlwaysAuthorized(httpServerInfo.getHttpsUri(), clientWithJwt, nodeId);
        }
        finally {
            jwkServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOAuth2Authenticator() throws Exception {
        CookieManager cookieManager = new CookieManager();
        OkHttpClient client = this.client.newBuilder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)cookieManager)).build();
        String state = Jwts.builder().signWith(SignatureAlgorithm.HS256, Hashing.sha256().hashString((CharSequence)"test-state-key", StandardCharsets.UTF_8).asBytes()).setAudience("presto_oauth").setExpiration(Date.from(ZonedDateTime.now().plusMinutes(10L).toInstant())).compact();
        Date tokenExpiration = Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant());
        final String token = Jwts.builder().signWith(SignatureAlgorithm.RS256, (Key)JWK_PRIVATE_KEY).setHeaderParam("kid", (Object)"test-rsa").setSubject(TEST_USER).setExpiration(tokenExpiration).compact();
        TestingHttpServer jwkServer = TestWebUi.createTestingJwkServer();
        jwkServer.start();
        try (TestingPrestoServer server = TestingPrestoServer.builder().setProperties((Map)ImmutableMap.builder().putAll(SECURE_PROPERTIES).put((Object)"web-ui.authentication.type", (Object)"oauth2").put((Object)"http-server.authentication.oauth2.jwks-url", (Object)jwkServer.getBaseUrl().toString()).put((Object)"http-server.authentication.oauth2.state-key", (Object)"test-state-key").put((Object)"http-server.authentication.oauth2.auth-url", (Object)"http://example.com/").put((Object)"http-server.authentication.oauth2.token-url", (Object)"http://example.com/").put((Object)"http-server.authentication.oauth2.client-id", (Object)"client").put((Object)"http-server.authentication.oauth2.client-secret", (Object)"client-secret").build()).setAdditionalModule(binder -> OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setBinding().toInstance((Object)new OAuth2Client(){

            public URI getAuthorizationUri(String state, URI callbackUri) {
                return URI.create("http://example.com/authorize");
            }

            public OAuth2Client.AccessToken getAccessToken(String code, URI callbackUri) {
                if (!"TEST_CODE".equals(code)) {
                    throw new IllegalArgumentException("Expected TEST_CODE");
                }
                return new OAuth2Client.AccessToken(token, Optional.empty());
            }
        })).build();){
            HttpServerInfo httpServerInfo = (HttpServerInfo)server.getInstance(com.google.inject.Key.get(HttpServerInfo.class));
            this.testDisabled(httpServerInfo.getHttpUri());
            URI baseUri = httpServerInfo.getHttpsUri();
            TestWebUi.testRootRedirect(baseUri, client);
            TestWebUi.assertRedirect(client, TestWebUi.getUiLocation(baseUri), "http://example.com/authorize", false);
            TestWebUi.assertRedirect(client, TestWebUi.getValidApiLocation(baseUri), "http://example.com/authorize", false);
            TestWebUi.assertRedirect(client, TestWebUi.getLocation(baseUri, "/ui/unknown"), "http://example.com/authorize", false);
            TestWebUi.assertRedirect(client, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), "http://example.com/authorize", false);
            TestWebUi.assertRedirect(client, HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath("/oauth2/callback").addParameter("code", new String[]{"TEST_CODE"}).addParameter("state", new String[]{state}).toString(), TestWebUi.getUiLocation(baseUri), false);
            HttpCookie cookie = (HttpCookie)Iterables.getOnlyElement(cookieManager.getCookieStore().getCookies());
            Assert.assertEquals((String)cookie.getValue(), (String)token);
            Assert.assertEquals((String)cookie.getPath(), (String)"/ui/");
            Assert.assertEquals((String)cookie.getDomain(), (String)baseUri.getHost());
            org.testng.Assert.assertTrue((cookie.getMaxAge() > 0L && cookie.getMaxAge() < TimeUnit.MINUTES.toSeconds(5L) ? 1 : 0) != 0);
            org.testng.Assert.assertTrue((boolean)cookie.isHttpOnly());
            TestWebUi.testRootRedirect(baseUri, client);
            TestWebUi.assertOk(client, TestWebUi.getUiLocation(baseUri));
            TestWebUi.assertOk(client, TestWebUi.getUiLocation(baseUri));
            TestWebUi.assertOk(client, TestWebUi.getValidApiLocation(baseUri));
            TestWebUi.assertResponseCode(client, TestWebUi.getLocation(baseUri, "/ui/unknown"), 404);
            TestWebUi.assertResponseCode(client, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), 404);
            TestWebUi.assertRedirect(client, TestWebUi.getLogoutLocation(baseUri), TestWebUi.getUiLocation(baseUri), false);
            Assertions.assertThat(cookieManager.getCookieStore().getCookies()).isEmpty();
            TestWebUi.assertRedirect(client, TestWebUi.getUiLocation(baseUri), "http://example.com/authorize", false);
        }
        finally {
            jwkServer.stop();
        }
    }

    private static void testAlwaysAuthorized(URI baseUri, OkHttpClient authorizedClient, String nodeId) throws IOException {
        TestWebUi.testRootRedirect(baseUri, authorizedClient);
        TestWebUi.testWorkerResource(nodeId, baseUri, authorizedClient);
        TestWebUi.assertOk(authorizedClient, TestWebUi.getUiLocation(baseUri));
        TestWebUi.assertOk(authorizedClient, TestWebUi.getValidApiLocation(baseUri));
        TestWebUi.assertRedirect(authorizedClient, TestWebUi.getLoginHtmlLocation(baseUri), TestWebUi.getUiLocation(baseUri), false);
        TestWebUi.assertRedirect(authorizedClient, TestWebUi.getLoginLocation(baseUri), TestWebUi.getUiLocation(baseUri), false);
        TestWebUi.assertRedirect(authorizedClient, TestWebUi.getLogoutLocation(baseUri), TestWebUi.getUiLocation(baseUri), false);
        TestWebUi.assertResponseCode(authorizedClient, TestWebUi.getLocation(baseUri, "/ui/unknown"), 404);
        TestWebUi.assertResponseCode(authorizedClient, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), 404);
    }

    private static void testNeverAuthorized(URI baseUri, OkHttpClient notAuthorizedClient) throws IOException {
        TestWebUi.testRootRedirect(baseUri, notAuthorizedClient);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getUiLocation(baseUri), 401);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getValidApiLocation(baseUri), 401);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getLoginLocation(baseUri), 401, true);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getLogoutLocation(baseUri), 401);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getLocation(baseUri, "/ui/unknown"), 401);
        TestWebUi.assertResponseCode(notAuthorizedClient, TestWebUi.getLocation(baseUri, "/ui/api/unknown"), 401);
    }

    private static Optional<String> assertOk(OkHttpClient client, String url) throws IOException {
        return TestWebUi.assertResponseCode(client, url, 200);
    }

    private static void assertRedirect(OkHttpClient client, String url, String redirectLocation) throws IOException {
        TestWebUi.assertRedirect(client, url, redirectLocation, true);
    }

    private static void assertRedirect(OkHttpClient client, String url, String redirectLocation, boolean testProxy) throws IOException {
        Request request = new Request.Builder().url(url).build();
        if (url.endsWith("/ui/login")) {
            FormBody formBody = new FormBody.Builder().add("username", "test").add("password", "test").build();
            request = request.newBuilder().post((RequestBody)formBody).build();
        }
        try (Response response = client.newCall(request).execute();){
            Assert.assertEquals((int)response.code(), (int)303);
            Assert.assertEquals((String)response.header("Location"), (String)redirectLocation);
        }
        if (testProxy) {
            request = new Request.Builder().url(url).header("X-Forwarded-Proto", "test").header("X-Forwarded-Host", "my-load-balancer.local").header("X-Forwarded-Port", "123").build();
            response = client.newCall(request).execute();
            try {
                Assert.assertEquals((int)response.code(), (int)303);
                Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).scheme("test").host("my-load-balancer.local").port(123).toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Proto", "test").header("X-Forwarded-Host", "my-load-balancer.local:123").build();
            response = client.newCall(request).execute();
            try {
                Assert.assertEquals((int)response.code(), (int)303);
                Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).scheme("test").host("my-load-balancer.local").port(123).toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Proto", "test").header("X-Forwarded-Port", "123").build();
            response = client.newCall(request).execute();
            try {
                Assert.assertEquals((int)response.code(), (int)303);
                Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).scheme("test").port(123).toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Proto", "test").build();
            response = client.newCall(request).execute();
            try {
                Assert.assertEquals((int)response.code(), (int)303);
                Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).scheme("test").toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Host", "my-load-balancer.local").header("X-Forwarded-Port", "123").build();
            response = client.newCall(request).execute();
            try {
                Assert.assertEquals((int)response.code(), (int)303);
                Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).host("my-load-balancer.local").port(123).toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Host", "my-load-balancer.local:123").build();
            response = client.newCall(request).execute();
            try {
                Assert.assertEquals((int)response.code(), (int)303);
                Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).host("my-load-balancer.local").port(123).toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
            request = new Request.Builder().url(url).header("X-Forwarded-Host", "my-load-balancer.local").build();
            response = client.newCall(request).execute();
            try {
                Assert.assertEquals((int)response.code(), (int)303);
                Assert.assertEquals((String)response.header("Location"), (String)HttpUriBuilder.uriBuilderFrom((URI)URI.create(redirectLocation)).host("my-load-balancer.local").defaultPort().toString());
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
    }

    private static Optional<String> assertResponseCode(OkHttpClient client, String url, int expectedCode) throws IOException {
        return TestWebUi.assertResponseCode(client, url, expectedCode, false);
    }

    private static Optional<String> assertResponseCode(OkHttpClient client, String url, int expectedCode, boolean postLogin) throws IOException {
        Request request = new Request.Builder().url(url).build();
        if (postLogin) {
            FormBody formBody = new FormBody.Builder().add("username", "fake").add("password", "bad").build();
            request = request.newBuilder().post((RequestBody)formBody).build();
        }
        try (Response response = client.newCall(request).execute();){
            Assert.assertEquals((int)response.code(), (int)expectedCode, (String)url);
            Optional<String> optional = Optional.ofNullable(response.body()).map(responseBody -> {
                try {
                    return responseBody.string();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            return optional;
        }
    }

    private static Principal authenticate(String user, String password) {
        if (TEST_USER.equals(user) && TEST_PASSWORD.equals(password)) {
            return new BasicPrincipal(user);
        }
        throw new AccessDeniedException("Invalid credentials");
    }

    private static String getUiLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/");
    }

    private static String getLoginHtmlLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/login.html");
    }

    private static String getLoginLocation(URI httpsUrl) {
        return TestWebUi.getLocation(httpsUrl, "/ui/login");
    }

    private static String getLogoutLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/logout");
    }

    private static String getDisabledLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/disabled.html");
    }

    private static String getValidApiLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/api/cluster");
    }

    private static String getValidAssetsLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/assets/favicon.ico");
    }

    private static String getValidVendorLocation(URI baseUri) {
        return TestWebUi.getLocation(baseUri, "/ui/vendor/bootstrap/css/bootstrap.css");
    }

    private static String getLocation(URI baseUri, String path) {
        return HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath(path).toString();
    }

    private static String getLocation(URI baseUri, String path, String query) {
        return HttpUriBuilder.uriBuilderFrom((URI)baseUri).replacePath(path).replaceParameter(query, new String[0]).toString();
    }

    private static TestingHttpServer createTestingJwkServer() throws IOException {
        NodeInfo nodeInfo = new NodeInfo("test");
        HttpServerConfig config = new HttpServerConfig().setHttpPort(0);
        HttpServerInfo httpServerInfo = new HttpServerInfo(config, nodeInfo);
        return new TestingHttpServer(httpServerInfo, nodeInfo, config, (Servlet)new JwkServlet(), (Map)ImmutableMap.of());
    }

    static {
        try {
            JWK_PRIVATE_KEY = PemReader.loadPrivateKey((File)new File(Resources.getResource((String)"jwk/jwk-rsa-private.pem").getPath()), Optional.empty());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class JwkServlet
    extends HttpServlet {
        private JwkServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            String jwkKeys = Resources.toString((URL)Resources.getResource((String)"jwk/jwk-public.json"), (Charset)StandardCharsets.UTF_8);
            response.getWriter().println(jwkKeys);
        }
    }
}

