/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spiller;

import com.google.common.collect.ImmutableList;
import io.prestosql.execution.buffer.PagesSerde;
import io.prestosql.execution.buffer.SerializedPage;
import io.prestosql.execution.buffer.TestingPagesSerdeFactory;
import io.prestosql.operator.PageAssertions;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.spiller.AesSpillCipher;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSpillCipherPagesSerde {
    @Test
    public void test() {
        AesSpillCipher cipher = new AesSpillCipher();
        PagesSerde serde = new TestingPagesSerdeFactory().createPagesSerdeForSpill(Optional.of(cipher));
        ImmutableList types = ImmutableList.of((Object)VarcharType.VARCHAR);
        Page emptyPage = new Page(new Block[]{VarcharType.VARCHAR.createBlockBuilder(null, 0).build()});
        try (PagesSerde.PagesSerdeContext context = serde.newContext();){
            PageAssertions.assertPageEquals((List<? extends Type>)types, serde.deserialize(serde.serialize(context, emptyPage)), emptyPage);
            BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 2);
            VarcharType.VARCHAR.writeString(blockBuilder, "hello");
            VarcharType.VARCHAR.writeString(blockBuilder, "world");
            Page helloWorldPage = new Page(new Block[]{blockBuilder.build()});
            SerializedPage serialized = serde.serialize(context, helloWorldPage);
            PageAssertions.assertPageEquals((List<? extends Type>)types, serde.deserialize(serialized), helloWorldPage);
            Assert.assertTrue((boolean)serialized.isEncrypted(), (String)"page should be encrypted");
            cipher.close();
            TestSpillCipherPagesSerde.assertFailure(() -> serde.serialize(context, helloWorldPage), "Spill cipher already closed");
            TestSpillCipherPagesSerde.assertFailure(() -> serde.deserialize(context, serialized), "Spill cipher already closed");
        }
    }

    private static void assertFailure(Assert.ThrowingRunnable runnable, String expectedErrorMessage) {
        PrestoException exception = (PrestoException)Assert.expectThrows(PrestoException.class, (Assert.ThrowingRunnable)runnable);
        Assert.assertEquals((Object)exception.getErrorCode(), (Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
        Assert.assertEquals((String)exception.getMessage(), (String)expectedErrorMessage);
    }
}

