/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.split;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.prestosql.connector.CatalogName;
import io.prestosql.execution.Lifespan;
import io.prestosql.metadata.Split;
import io.prestosql.spi.HostAddress;
import io.prestosql.spi.connector.ConnectorPartitionHandle;
import io.prestosql.spi.connector.ConnectorSplit;
import io.prestosql.spi.connector.NotPartitionedPartitionHandle;
import io.prestosql.split.SplitSource;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MockSplitSource
implements SplitSource {
    private static final Split SPLIT = new Split(new CatalogName("test"), (ConnectorSplit)new MockConnectorSplit(), Lifespan.taskWide());
    private static final SettableFuture<List<Split>> COMPLETED_FUTURE = SettableFuture.create();
    private int batchSize;
    private int totalSplits;
    private Action atSplitDepletion = Action.DO_NOTHING;
    private int nextBatchInvocationCount;
    private int splitsProduced;
    private SettableFuture<List<Split>> nextBatchFuture = COMPLETED_FUTURE;
    private int nextBatchMaxSize;

    public MockSplitSource setBatchSize(int batchSize) {
        Preconditions.checkArgument((this.atSplitDepletion == Action.DO_NOTHING ? 1 : 0) != 0, (Object)"cannot modify batch size once split completion action is set");
        this.batchSize = batchSize;
        return this;
    }

    public MockSplitSource increaseAvailableSplits(int count) {
        Preconditions.checkArgument((this.atSplitDepletion == Action.DO_NOTHING ? 1 : 0) != 0, (Object)"cannot increase available splits once split completion action is set");
        this.totalSplits += count;
        this.doGetNextBatch();
        return this;
    }

    public MockSplitSource atSplitCompletion(Action action) {
        this.atSplitDepletion = action;
        this.doGetNextBatch();
        return this;
    }

    public CatalogName getCatalogName() {
        throw new UnsupportedOperationException();
    }

    private void doGetNextBatch() {
        int splits;
        Preconditions.checkState((this.splitsProduced <= this.totalSplits ? 1 : 0) != 0);
        if (this.splitsProduced == this.totalSplits) {
            switch (this.atSplitDepletion) {
                case FAIL: {
                    this.nextBatchFuture.setException((Throwable)new IllegalStateException("Mock failure"));
                    break;
                }
                case FINISH: {
                    this.nextBatchFuture.set((Object)ImmutableList.of());
                    break;
                }
                case DO_NOTHING: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        if ((splits = Math.min(Math.min(this.batchSize, this.nextBatchMaxSize), this.totalSplits - this.splitsProduced)) != 0) {
            this.splitsProduced += splits;
            this.nextBatchFuture.set(Collections.nCopies(splits, SPLIT));
        }
    }

    public ListenableFuture<SplitSource.SplitBatch> getNextBatch(ConnectorPartitionHandle partitionHandle, Lifespan lifespan, int maxSize) {
        if (partitionHandle != NotPartitionedPartitionHandle.NOT_PARTITIONED) {
            throw new UnsupportedOperationException();
        }
        Preconditions.checkArgument((boolean)Lifespan.taskWide().equals((Object)lifespan));
        Preconditions.checkState((boolean)this.nextBatchFuture.isDone(), (Object)"concurrent getNextBatch invocation");
        this.nextBatchFuture = SettableFuture.create();
        this.nextBatchMaxSize = maxSize;
        ++this.nextBatchInvocationCount;
        this.doGetNextBatch();
        return Futures.transform(this.nextBatchFuture, splits -> new SplitSource.SplitBatch(splits, this.isFinished()), (Executor)MoreExecutors.directExecutor());
    }

    public void close() {
    }

    public boolean isFinished() {
        return this.splitsProduced == this.totalSplits && this.atSplitDepletion == Action.FINISH;
    }

    public Optional<Integer> getMinScheduleSplitBatchSize() {
        return Optional.empty();
    }

    public int getNextBatchInvocationCount() {
        return this.nextBatchInvocationCount;
    }

    static {
        COMPLETED_FUTURE.set(null);
    }

    public static enum Action {
        DO_NOTHING,
        FAIL,
        FINISH;

    }

    public static class MockConnectorSplit
    implements ConnectorSplit {
        public boolean isRemotelyAccessible() {
            return false;
        }

        public List<HostAddress> getAddresses() {
            return ImmutableList.of();
        }

        public Object getInfo() {
            return "A mock split";
        }
    }
}

