/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.analyzer;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.analyzer.RegexLibrary;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestFeaturesConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FeaturesConfig)ConfigAssertions.recordDefaults(FeaturesConfig.class)).setCpuCostWeight(75.0).setMemoryCostWeight(10.0).setNetworkCostWeight(15.0).setDistributedIndexJoinsEnabled(false).setJoinMaxBroadcastTableSize(DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setJoinDistributionType(FeaturesConfig.JoinDistributionType.AUTOMATIC).setGroupedExecutionEnabled(false).setDynamicScheduleForGroupedExecutionEnabled(false).setConcurrentLifespansPerTask(0).setColocatedJoinsEnabled(false).setSpatialJoinsEnabled(true).setJoinReorderingStrategy(FeaturesConfig.JoinReorderingStrategy.AUTOMATIC).setMaxReorderedJoins(9).setRedistributeWrites(true).setUsePreferredWritePartitioning(false).setScaleWriters(false).setWriterMinSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setOptimizeMetadataQueries(false).setOptimizeHashGeneration(true).setPushTableWriteThroughUnion(true).setDictionaryAggregation(false).setRegexLibrary(RegexLibrary.JONI).setRe2JDfaStatesLimit(Integer.MAX_VALUE).setRe2JDfaRetries(5).setSpillEnabled(false).setSpillOrderBy(true).setSpillWindowOperator(true).setAggregationOperatorUnspillMemoryLimit(DataSize.valueOf((String)"4MB")).setSpillerSpillPaths("").setSpillerThreads(4).setSpillMaxUsedSpaceThreshold(0.9).setMemoryRevokingThreshold(0.9).setMemoryRevokingTarget(0.5).setOptimizeMixedDistinctAggregations(false).setUnwrapCasts(true).setIterativeOptimizerTimeout(new Duration(3.0, TimeUnit.MINUTES)).setEnableStatsCalculator(true).setCollectPlanStatisticsForAllQueries(false).setIgnoreStatsCalculatorFailures(true).setDefaultFilterFactorEnabled(false).setEnableForcedExchangeBelowGroupId(true).setExchangeCompressionEnabled(false).setExchangeDataIntegrityVerification(FeaturesConfig.DataIntegrityVerification.ABORT).setEnableIntermediateAggregations(false).setPushAggregationThroughOuterJoin(true).setPushPartialAggregationThoughJoin(false).setParseDecimalLiteralsAsDouble(false).setForceSingleNodeOutput(true).setPagesIndexEagerCompactionEnabled(false).setFilterAndProjectMinOutputPageSize(DataSize.of((long)500L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setFilterAndProjectMinOutputPageRowCount(256).setUseMarkDistinct(true).setPreferPartialAggregation(true).setOptimizeTopNRowNumber(true).setDistributedSortEnabled(true).setMaxRecursionDepth(10).setMaxGroupingSets(2048).setLateMaterializationEnabled(false).setSkipRedundantSort(true).setPredicatePushdownUseTableProperties(true).setIgnoreDownstreamPreferences(false).setOmitDateTimeTypePrecision(false).setIterativeRuleBasedColumnPruning(true).setRewriteFilteringSemiJoinToInnerJoin(true));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"cpu-cost-weight", (Object)"0.4").put((Object)"memory-cost-weight", (Object)"0.3").put((Object)"network-cost-weight", (Object)"0.2").put((Object)"iterative-optimizer-timeout", (Object)"10s").put((Object)"enable-stats-calculator", (Object)"false").put((Object)"collect-plan-statistics-for-all-queries", (Object)"true").put((Object)"optimizer.ignore-stats-calculator-failures", (Object)"false").put((Object)"optimizer.default-filter-factor-enabled", (Object)"true").put((Object)"enable-forced-exchange-below-group-id", (Object)"false").put((Object)"distributed-index-joins-enabled", (Object)"true").put((Object)"join-distribution-type", (Object)"BROADCAST").put((Object)"join-max-broadcast-table-size", (Object)"42GB").put((Object)"grouped-execution-enabled", (Object)"true").put((Object)"dynamic-schedule-for-grouped-execution", (Object)"true").put((Object)"concurrent-lifespans-per-task", (Object)"1").put((Object)"colocated-joins-enabled", (Object)"true").put((Object)"spatial-joins-enabled", (Object)"false").put((Object)"optimizer.join-reordering-strategy", (Object)"NONE").put((Object)"optimizer.max-reordered-joins", (Object)"5").put((Object)"redistribute-writes", (Object)"false").put((Object)"use-preferred-write-partitioning", (Object)"true").put((Object)"scale-writers", (Object)"true").put((Object)"writer-min-size", (Object)"42GB").put((Object)"optimizer.optimize-metadata-queries", (Object)"true").put((Object)"optimizer.optimize-hash-generation", (Object)"false").put((Object)"optimizer.optimize-mixed-distinct-aggregations", (Object)"true").put((Object)"optimizer.unwrap-casts", (Object)"false").put((Object)"optimizer.push-table-write-through-union", (Object)"false").put((Object)"optimizer.dictionary-aggregation", (Object)"true").put((Object)"optimizer.push-aggregation-through-outer-join", (Object)"false").put((Object)"optimizer.push-partial-aggregation-through-join", (Object)"true").put((Object)"regex-library", (Object)"RE2J").put((Object)"re2j.dfa-states-limit", (Object)"42").put((Object)"re2j.dfa-retries", (Object)"42").put((Object)"spill-enabled", (Object)"true").put((Object)"spill-order-by", (Object)"false").put((Object)"spill-window-operator", (Object)"false").put((Object)"aggregation-operator-unspill-memory-limit", (Object)"100MB").put((Object)"spiller-spill-path", (Object)"/tmp/custom/spill/path1,/tmp/custom/spill/path2").put((Object)"spiller-threads", (Object)"42").put((Object)"spiller-max-used-space-threshold", (Object)"0.8").put((Object)"memory-revoking-threshold", (Object)"0.2").put((Object)"memory-revoking-target", (Object)"0.8").put((Object)"exchange.compression-enabled", (Object)"true").put((Object)"exchange.data-integrity-verification", (Object)"RETRY").put((Object)"optimizer.enable-intermediate-aggregations", (Object)"true").put((Object)"parse-decimal-literals-as-double", (Object)"true").put((Object)"optimizer.force-single-node-output", (Object)"false").put((Object)"pages-index.eager-compaction-enabled", (Object)"true").put((Object)"filter-and-project-min-output-page-size", (Object)"1MB").put((Object)"filter-and-project-min-output-page-row-count", (Object)"2048").put((Object)"optimizer.use-mark-distinct", (Object)"false").put((Object)"optimizer.prefer-partial-aggregation", (Object)"false").put((Object)"optimizer.optimize-top-n-row-number", (Object)"false").put((Object)"distributed-sort", (Object)"false").put((Object)"max-recursion-depth", (Object)"8").put((Object)"analyzer.max-grouping-sets", (Object)"2047").put((Object)"experimental.late-materialization.enabled", (Object)"true").put((Object)"optimizer.skip-redundant-sort", (Object)"false").put((Object)"optimizer.predicate-pushdown-use-table-properties", (Object)"false").put((Object)"optimizer.ignore-downstream-preferences", (Object)"true").put((Object)"deprecated.omit-datetime-type-precision", (Object)"true").put((Object)"optimizer.iterative-rule-based-column-pruning", (Object)"false").put((Object)"optimizer.rewrite-filtering-semi-join-to-inner-join", (Object)"false").build();
        FeaturesConfig expected = new FeaturesConfig().setCpuCostWeight(0.4).setMemoryCostWeight(0.3).setNetworkCostWeight(0.2).setIterativeOptimizerTimeout(new Duration(10.0, TimeUnit.SECONDS)).setEnableStatsCalculator(false).setCollectPlanStatisticsForAllQueries(true).setIgnoreStatsCalculatorFailures(false).setEnableForcedExchangeBelowGroupId(false).setDistributedIndexJoinsEnabled(true).setJoinDistributionType(FeaturesConfig.JoinDistributionType.BROADCAST).setJoinMaxBroadcastTableSize(DataSize.of((long)42L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setGroupedExecutionEnabled(true).setDynamicScheduleForGroupedExecutionEnabled(true).setConcurrentLifespansPerTask(1).setColocatedJoinsEnabled(true).setSpatialJoinsEnabled(false).setJoinReorderingStrategy(FeaturesConfig.JoinReorderingStrategy.NONE).setMaxReorderedJoins(5).setRedistributeWrites(false).setUsePreferredWritePartitioning(true).setScaleWriters(true).setWriterMinSize(DataSize.of((long)42L, (DataSize.Unit)DataSize.Unit.GIGABYTE)).setOptimizeMetadataQueries(true).setOptimizeHashGeneration(false).setOptimizeMixedDistinctAggregations(true).setUnwrapCasts(false).setPushTableWriteThroughUnion(false).setDictionaryAggregation(true).setPushAggregationThroughOuterJoin(false).setPushPartialAggregationThoughJoin(true).setRegexLibrary(RegexLibrary.RE2J).setRe2JDfaStatesLimit(42).setRe2JDfaRetries(42).setSpillEnabled(true).setSpillOrderBy(false).setSpillWindowOperator(false).setAggregationOperatorUnspillMemoryLimit(DataSize.valueOf((String)"100MB")).setSpillerSpillPaths("/tmp/custom/spill/path1,/tmp/custom/spill/path2").setSpillerThreads(42).setSpillMaxUsedSpaceThreshold(0.8).setMemoryRevokingThreshold(0.2).setMemoryRevokingTarget(0.8).setExchangeCompressionEnabled(true).setExchangeDataIntegrityVerification(FeaturesConfig.DataIntegrityVerification.RETRY).setEnableIntermediateAggregations(true).setParseDecimalLiteralsAsDouble(true).setForceSingleNodeOutput(false).setPagesIndexEagerCompactionEnabled(true).setFilterAndProjectMinOutputPageSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).setFilterAndProjectMinOutputPageRowCount(2048).setUseMarkDistinct(false).setPreferPartialAggregation(false).setOptimizeTopNRowNumber(false).setDistributedSortEnabled(false).setMaxRecursionDepth(8).setMaxGroupingSets(2047).setDefaultFilterFactorEnabled(true).setLateMaterializationEnabled(true).setSkipRedundantSort(false).setPredicatePushdownUseTableProperties(false).setIgnoreDownstreamPreferences(true).setOmitDateTimeTypePrecision(true).setIterativeRuleBasedColumnPruning(false).setRewriteFilteringSemiJoinToInnerJoin(false);
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

