/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.gen;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.operator.DriverYieldSignal;
import io.prestosql.operator.Work;
import io.prestosql.operator.project.PageProjection;
import io.prestosql.operator.project.SelectedPositions;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.PageFunctionCompiler;
import io.prestosql.sql.relational.CallExpression;
import io.prestosql.sql.relational.Expressions;
import io.prestosql.sql.relational.RowExpression;
import io.prestosql.testing.TestingConnectorSession;
import io.prestosql.testing.assertions.PrestoExceptionAssert;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPageFunctionCompiler {
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final CallExpression ADD_10_EXPRESSION = Expressions.call((ResolvedFunction)METADATA.resolveOperator(OperatorType.ADD, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});

    @Test
    public void testFailureDoesNotCorruptFutureResults() {
        PageFunctionCompiler functionCompiler = new PageFunctionCompiler(METADATA, 0);
        Supplier projectionSupplier = functionCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty());
        PageProjection projection = (PageProjection)projectionSupplier.get();
        Page goodPage = TestPageFunctionCompiler.createLongBlockPage(0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        Block goodResult = this.project(projection, goodPage, SelectedPositions.positionsRange((int)0, (int)goodPage.getPositionCount()));
        Assert.assertEquals((int)goodPage.getPositionCount(), (int)goodResult.getPositionCount());
        Page badPage = TestPageFunctionCompiler.createLongBlockPage(0L, 1L, 2L, 3L, 4L, Long.MAX_VALUE);
        PrestoExceptionAssert.assertPrestoExceptionThrownBy(() -> this.project(projection, badPage, SelectedPositions.positionsRange((int)0, (int)100))).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE);
        goodResult = this.project(projection, goodPage, SelectedPositions.positionsRange((int)0, (int)goodPage.getPositionCount()));
        Assert.assertEquals((int)goodPage.getPositionCount(), (int)goodResult.getPositionCount());
    }

    @Test
    public void testGeneratedClassName() {
        PageFunctionCompiler functionCompiler = new PageFunctionCompiler(METADATA, 0);
        String planNodeId = "7";
        String stageId = "20170707_223500_67496_zguwn.2";
        String classSuffix = stageId + "_" + planNodeId;
        Supplier projectionSupplier = functionCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of(classSuffix));
        PageProjection projection = (PageProjection)projectionSupplier.get();
        Work work = projection.project(TestingConnectorSession.SESSION, new DriverYieldSignal(), TestPageFunctionCompiler.createLongBlockPage(0L), SelectedPositions.positionsRange((int)0, (int)1));
        Assert.assertTrue((boolean)work.getClass().getSimpleName().startsWith("PageProjectionWork_" + stageId.replace('.', '_') + "_" + planNodeId));
    }

    @Test
    public void testCache() {
        PageFunctionCompiler cacheCompiler = new PageFunctionCompiler(METADATA, 100);
        Assert.assertSame((Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()));
        Assert.assertSame((Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")));
        Assert.assertSame((Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
        Assert.assertSame((Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)cacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
        PageFunctionCompiler noCacheCompiler = new PageFunctionCompiler(METADATA, 0);
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()));
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")));
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint")), (Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
        Assert.assertNotSame((Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.empty()), (Object)noCacheCompiler.compileProjection((RowExpression)ADD_10_EXPRESSION, Optional.of("hint2")));
    }

    private Block project(PageProjection projection, Page page, SelectedPositions selectedPositions) {
        Work work = projection.project(TestingConnectorSession.SESSION, new DriverYieldSignal(), page, selectedPositions);
        Assert.assertTrue((boolean)work.process());
        return (Block)work.getResult();
    }

    private static Page createLongBlockPage(long ... values) {
        BlockBuilder builder = BigintType.BIGINT.createFixedSizeBlockBuilder(values.length);
        for (long value : values) {
            BigintType.BIGINT.writeLong(builder, value);
        }
        return new Page(new Block[]{builder.build()});
    }
}

