/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.SessionTestUtils;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataManager;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.ValueSet;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.DecimalType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RealType;
import io.prestosql.spi.type.SmallintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeOperators;
import io.prestosql.sql.planner.DomainCoercer;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDomainCoercer {
    private Metadata metadata;
    private TypeOperators typeOperators;

    @BeforeClass
    public void setup() {
        this.metadata = MetadataManager.createTestMetadataManager();
        this.typeOperators = new TypeOperators();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.metadata = null;
    }

    @Test
    public void testNone() {
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.none((Type)BigintType.BIGINT), (Type)IntegerType.INTEGER), (Object)Domain.none((Type)IntegerType.INTEGER));
    }

    @Test
    public void testAll() {
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.all((Type)BigintType.BIGINT), (Type)IntegerType.INTEGER), (Object)Domain.all((Type)IntegerType.INTEGER));
    }

    @Test
    public void testOnlyNull() {
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.onlyNull((Type)BigintType.BIGINT), (Type)IntegerType.INTEGER), (Object)Domain.onlyNull((Type)IntegerType.INTEGER));
    }

    @Test
    public void testCoercedValueSameAsOriginal() {
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)10000L, (Object)-2000L)), (Type)SmallintType.SMALLINT), (Object)Domain.multipleValues((Type)SmallintType.SMALLINT, (List)ImmutableList.of((Object)1L, (Object)10000L, (Object)-2000L)));
        Domain original = Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)DoubleType.DOUBLE, (Object)0.0), (Range[])new Range[]{Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)false, (Object)1.0, (boolean)false), Range.range((Type)DoubleType.DOUBLE, (Object)2.0, (boolean)true, (Object)3.0, (boolean)true), Range.greaterThan((Type)DoubleType.DOUBLE, (Object)4.0)}), (boolean)true);
        Assert.assertEquals((Object)this.applySaturatedCasts(original, (Type)RealType.REAL), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThan((Type)RealType.REAL, (Object)Float.floatToIntBits(0.0f)), (Range[])new Range[]{Range.range((Type)RealType.REAL, (Object)Float.floatToIntBits(0.0f), (boolean)false, (Object)Float.floatToIntBits(1.0f), (boolean)false), Range.range((Type)RealType.REAL, (Object)Float.floatToIntBits(2.0f), (boolean)true, (Object)Float.floatToIntBits(3.0f), (boolean)true), Range.greaterThan((Type)RealType.REAL, (Object)Float.floatToIntBits(4.0f))}), (boolean)true));
    }

    @Test
    public void testOutsideTargetTypeRange() {
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)10000000000L, (Object)-2000L)), (Type)SmallintType.SMALLINT), (Object)Domain.multipleValues((Type)SmallintType.SMALLINT, (List)ImmutableList.of((Object)1L, (Object)-2000L)));
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)true, (Object)3.4028234663852886E39, (boolean)true), (Range[])new Range[0]), (boolean)true), (Type)RealType.REAL), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)RealType.REAL, (Object)Float.floatToIntBits(0.0f), (boolean)true, (Object)Float.floatToIntBits(Float.MAX_VALUE), (boolean)true), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)-6.805646932770577E38, (boolean)true, (Object)3.4028234663852886E39, (boolean)true), (Range[])new Range[0]), (boolean)true), (Type)RealType.REAL), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)RealType.REAL, (Object)Float.floatToIntBits(Float.MAX_VALUE)), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)Double.NEGATIVE_INFINITY, (boolean)true, (Object)Double.POSITIVE_INFINITY, (boolean)true), (Range[])new Range[0]), (boolean)true), (Type)RealType.REAL), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)RealType.REAL, (Object)Float.floatToIntBits(Float.MAX_VALUE)), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)-4294967294L, (boolean)false, (Object)0x4FFFFFFF6L, (boolean)false), (Range[])new Range[0]), (boolean)true), (Type)IntegerType.INTEGER), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)Integer.MAX_VALUE), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)Double.NEGATIVE_INFINITY, (boolean)true, (Object)Double.POSITIVE_INFINITY, (boolean)true), (Range[])new Range[0]), (boolean)true), (Type)IntegerType.INTEGER), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)IntegerType.INTEGER, (Object)Integer.MAX_VALUE), (Range[])new Range[0]), (boolean)true));
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)-8589934588L, (boolean)false, (Object)-4294967294L, (boolean)false), (Range[])new Range[0]), (boolean)false), (Type)IntegerType.INTEGER), (Object)Domain.none((Type)IntegerType.INTEGER));
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)-1.3611293865541154E39, (boolean)true, (Object)-6.805646932770577E38, (boolean)true), (Range[])new Range[0]), (boolean)true), (Type)RealType.REAL), (Object)Domain.onlyNull((Type)RealType.REAL));
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0xFFFFFFFEL, (boolean)false, (Object)0x1FFFFFFFCL, (boolean)false), (Range[])new Range[0]), (boolean)false), (Type)IntegerType.INTEGER), (Object)Domain.none((Type)IntegerType.INTEGER));
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)6.805646932770577E38, (boolean)true, (Object)1.3611293865541154E39, (boolean)true), (Range[])new Range[0]), (boolean)true), (Type)RealType.REAL), (Object)Domain.onlyNull((Type)RealType.REAL));
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)DoubleType.DOUBLE, (Object)-1.3611293865541154E39), (Range[])new Range[]{Range.range((Type)DoubleType.DOUBLE, (Object)0.0, (boolean)true, (Object)1.0, (boolean)true)}), (boolean)true), (Type)RealType.REAL), (Object)Domain.all((Type)RealType.REAL));
    }

    @Test
    public void testTruncatedCoercedValue() {
        Assert.assertEquals((Object)this.applySaturatedCasts(Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DecimalType.createDecimalType((int)6, (int)3), (Object)123456L, (boolean)true, (Object)234567L, (boolean)false), (Range[])new Range[0]), (boolean)true), (Type)DecimalType.createDecimalType((int)6, (int)1)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DecimalType.createDecimalType((int)6, (int)1), (Object)1234L, (boolean)false, (Object)2345L, (boolean)true), (Range[])new Range[0]), (boolean)true));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testUnsupportedCast() {
        this.applySaturatedCasts(Domain.singleValue((Type)IntegerType.INTEGER, (Object)10L), (Type)BigintType.BIGINT);
    }

    private Domain applySaturatedCasts(Domain domain, Type coercedValueType) {
        return DomainCoercer.applySaturatedCasts((Metadata)this.metadata, (TypeOperators)this.typeOperators, (Session)SessionTestUtils.TEST_SESSION, (Domain)domain, (Type)coercedValueType);
    }
}

