/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.connector.MockConnectorFactory;
import io.prestosql.connector.MockConnectorTableHandle;
import io.prestosql.plugin.tpch.TpchPartitioningHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorNewTableLayout;
import io.prestosql.spi.connector.ConnectorPartitioningHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.planner.assertions.BasePlanTest;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.plan.ExchangeNode;
import io.prestosql.sql.planner.plan.TableWriterNode;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.Test;

public class TestInsert
extends BasePlanTest {
    @Override
    protected LocalQueryRunner createLocalQueryRunner() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("mock").setSchema("schema");
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)sessionBuilder.build());
        queryRunner.createCatalog("mock", (ConnectorFactory)MockConnectorFactory.builder().withGetTableHandle((session, schemaTableName) -> {
            if (schemaTableName.getTableName().equals("test_table_preferred_partitioning")) {
                return new MockConnectorTableHandle((SchemaTableName)schemaTableName);
            }
            return null;
        }).withGetColumns(name -> ImmutableList.of((Object)new ColumnMetadata("column1", (Type)IntegerType.INTEGER), (Object)new ColumnMetadata("column2", (Type)IntegerType.INTEGER))).withGetInsertLayout((session, tableName) -> {
            if (tableName.getTableName().equals("test_table_preferred_partitioning")) {
                return Optional.of(new ConnectorNewTableLayout((List)ImmutableList.of((Object)"column1")));
            }
            return Optional.empty();
        }).withGetNewTableLayout((session, tableMetadata) -> {
            if (tableMetadata.getTable().getTableName().equals("new_test_table_preferred_partitioning")) {
                return Optional.of(new ConnectorNewTableLayout((List)ImmutableList.of((Object)"column1")));
            }
            if (tableMetadata.getTable().getTableName().equals("new_test_table_required_partitioning")) {
                return Optional.of(new ConnectorNewTableLayout((ConnectorPartitioningHandle)new TpchPartitioningHandle("orders", 10L), (List)ImmutableList.of((Object)"column1")));
            }
            if (tableMetadata.getTable().getTableName().equals("new_test_table_unpartitioned")) {
                return Optional.empty();
            }
            return Optional.empty();
        }).build(), (Map)ImmutableMap.of());
        return queryRunner;
    }

    @Test
    public void testInsertWithPreferredPartitioning() {
        this.assertDistributedPlan("INSERT into test_table_preferred_partitioning VALUES (1, 2)", this.withPreferredPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"column1"), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"column1"), PlanMatchPattern.anyTree(PlanMatchPattern.values("column1", "column2"))))))));
    }

    @Test
    public void testInsertWithoutPreferredPartitioningEnabled() {
        this.assertDistributedPlan("INSERT into test_table_preferred_partitioning VALUES (1, 2)", this.withoutPreferredPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), PlanMatchPattern.values("column1", "column2")))));
    }

    @Test
    public void testCreateTableAsSelectWithPreferredPartitioning() {
        this.assertDistributedPlan("CREATE TABLE new_test_table_preferred_partitioning (column1, column2) AS SELECT * FROM (VALUES (1, 2)) t(column1, column2)", this.withPreferredPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"column1"), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"column1"), PlanMatchPattern.anyTree(PlanMatchPattern.values("column1", "column2"))))))));
    }

    @Test
    public void testCreateTableAsSelectWithPreferredPartitioningAndNoPartitioningColumns() {
        this.assertDistributedPlan("CREATE TABLE new_test_table_preferred_partitioning (column2) AS SELECT * FROM (VALUES 2) t(column2)", this.withPreferredPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), PlanMatchPattern.values("column2")))));
    }

    @Test
    public void testCreateTableAsSelectWithoutPreferredPartitioningEnabled() {
        this.assertDistributedPlan("CREATE TABLE new_test_table_preferred_partitioning (column1, column2) AS SELECT * FROM (VALUES (1, 2)) t(column1, column2)", this.withoutPreferredPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), PlanMatchPattern.values("column1", "column2")))));
    }

    @Test
    public void testCreateTableAsSelectWithRequiredPartitioning() {
        this.assertDistributedPlan("CREATE TABLE new_test_table_required_partitioning (column1, column2) AS SELECT * FROM (VALUES (1, 2)) t(column1, column2)", this.withPreferredPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"column1"), PlanMatchPattern.values("column1", "column2"))))));
    }

    @Test
    public void testCreateTableAsSelectUnpartitioned() {
        this.assertDistributedPlan("CREATE TABLE new_test_table_unpartitioned (column1, column2) AS SELECT * FROM (VALUES (1, 2)) t(column1, column2)", this.withoutPreferredPartitioning(), PlanMatchPattern.anyTree(PlanMatchPattern.node(TableWriterNode.class, PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of(), PlanMatchPattern.values("column1", "column2")))));
    }

    private Session withPreferredPartitioning() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("use_preferred_write_partitioning", "true").setSystemProperty("redistribute_writes", "false").setSystemProperty("task_writer_count", "16").build();
    }

    private Session withoutPreferredPartitioning() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("use_preferred_write_partitioning", "false").setSystemProperty("redistribute_writes", "false").setSystemProperty("task_writer_count", "16").build();
    }
}

