/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.prestosql.sql.planner.assertions.BasePlanTest;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.plan.AggregationNode;
import io.prestosql.sql.planner.plan.JoinNode;
import io.prestosql.sql.planner.plan.ValuesNode;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestQuantifiedComparison
extends BasePlanTest {
    @Test
    public void testQuantifiedComparisonEqualsAny() {
        String query = "SELECT orderkey, custkey FROM orders WHERE orderkey = ANY (VALUES ROW(CAST(5 as BIGINT)), ROW(CAST(3 as BIGINT)))";
        this.assertPlan(query, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("Y", "X")), PlanMatchPattern.anyTree(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"Y", (Object)0))), PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))))));
    }

    @Test
    public void testQuantifiedComparisonNotEqualsAll() {
        String query = "SELECT orderkey, custkey FROM orders WHERE orderkey <> ALL (VALUES ROW(CAST(5 as BIGINT)), ROW(CAST(3 as BIGINT)))";
        this.assertPlan(query, PlanMatchPattern.anyTree(PlanMatchPattern.filter("NOT S", PlanMatchPattern.project(PlanMatchPattern.semiJoin("X", "Y", "S", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("orders", (Map<String, String>)ImmutableMap.of((Object)"X", (Object)"orderkey"))), PlanMatchPattern.anyTree(PlanMatchPattern.values((Map<String, Integer>)ImmutableMap.of((Object)"Y", (Object)0))))))));
    }

    @Test
    public void testQuantifiedComparisonLessAll() {
        this.assertQuantifiedComparison("SELECT orderkey, custkey FROM orders WHERE orderkey < ALL (VALUES CAST(5 as BIGINT), CAST(3 as BIGINT))");
    }

    @Test
    public void testQuantifiedComparisonGreaterEqualAll() {
        this.assertQuantifiedComparison("SELECT orderkey, custkey FROM orders WHERE orderkey >= ALL (VALUES CAST(5 as BIGINT), CAST(3 as BIGINT))");
    }

    @Test
    public void testQuantifiedComparisonLessSome() {
        this.assertQuantifiedComparison("SELECT orderkey, custkey FROM orders WHERE orderkey < SOME (VALUES CAST(5 as BIGINT), CAST(3 as BIGINT))");
    }

    @Test
    public void testQuantifiedComparisonGreaterEqualAny() {
        this.assertQuantifiedComparison("SELECT orderkey, custkey FROM orders WHERE orderkey >= ANY (VALUES CAST(5 as BIGINT), CAST(3 as BIGINT))");
    }

    @Test
    public void testQuantifiedComparisonEqualAll() {
        this.assertQuantifiedComparison("SELECT orderkey, custkey FROM orders WHERE orderkey = ALL (VALUES CAST(5 as BIGINT), CAST(3 as BIGINT))");
    }

    @Test
    public void testQuantifiedComparisonNotEqualAny() {
        this.assertQuantifiedComparison("SELECT orderkey, custkey FROM orders WHERE orderkey <> SOME (VALUES CAST(5 as BIGINT), CAST(3 as BIGINT))");
    }

    private void assertQuantifiedComparison(String query) {
        this.assertPlan(query, PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.tableScan("orders"), PlanMatchPattern.node(AggregationNode.class, PlanMatchPattern.node(ValuesNode.class, new PlanMatchPattern[0])))));
    }
}

