/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.connector.MockConnectorColumnHandle;
import io.prestosql.connector.MockConnectorFactory;
import io.prestosql.connector.MockConnectorTableHandle;
import io.prestosql.execution.warnings.WarningCollector;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.connector.Assignment;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.ProjectionApplicationResult;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.TableScanRedirectApplicationResult;
import io.prestosql.spi.expression.ConnectorExpression;
import io.prestosql.spi.expression.Variable;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.sql.planner.LogicalPlanner;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.planner.assertions.PlanAssert;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.testing.LocalQueryRunner;
import io.prestosql.testing.TestingSession;
import io.prestosql.transaction.TransactionBuilder;
import io.prestosql.transaction.TransactionManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

public class TestTableScanRedirectionWithPushdown {
    private static final String MOCK_CATALOG = "mock_catalog";
    private static final String TEST_SCHEMA = "test_schema";
    private static final String TEST_TABLE = "test_table";
    private static final SchemaTableName sourceTable = new SchemaTableName("test_schema", "test_table");
    private static final Session MOCK_SESSION = TestingSession.testSessionBuilder().setCatalog("mock_catalog").setSchema("test_schema").build();
    private static final String sourceColumnNameA = "source_col_a";
    private static final ColumnHandle sourceColumnHandleA = new MockConnectorColumnHandle("source_col_a", (Type)IntegerType.INTEGER);
    private static final String sourceColumnNameB = "source_col_b";
    private static final ColumnHandle sourceColumnHandleB = new MockConnectorColumnHandle("source_col_b", (Type)IntegerType.INTEGER);
    private static final String sourceColumnNameC = "source_col_c";
    private static final ColumnHandle sourceColumnHandleC = new MockConnectorColumnHandle("source_col_c", (Type)VarcharType.VARCHAR);
    private static final SchemaTableName destinationTable = new SchemaTableName("target_schema", "target_table");
    private static final String destinationColumnNameA = "destination_col_a";
    private static final ColumnHandle destinationColumnHandleA = new MockConnectorColumnHandle("destination_col_a", (Type)IntegerType.INTEGER);
    private static final String destinationColumnNameB = "destination_col_b";
    private static final ColumnHandle destinationColumnHandleB = new MockConnectorColumnHandle("destination_col_b", (Type)IntegerType.INTEGER);
    private static final Map<ColumnHandle, String> redirectionMappingA = ImmutableMap.of((Object)sourceColumnHandleA, (Object)"destination_col_a");
    private static final Map<ColumnHandle, String> redirectionMappingAB = ImmutableMap.of((Object)sourceColumnHandleA, (Object)"destination_col_a", (Object)sourceColumnHandleB, (Object)"destination_col_b");
    private static final Map<ColumnHandle, String> typeMismatchedRedirectionMappingBC = ImmutableMap.of((Object)sourceColumnHandleB, (Object)"destination_col_b", (Object)sourceColumnHandleC, (Object)"destination_col_a");

    @Test
    public void testRedirectionAfterProjectionPushdown() {
        try (LocalQueryRunner queryRunner = this.createLocalQueryRunner(this::mockApplyRedirectAfterProjectionPushdown, Optional.of(this::mockApplyProjection), Optional.empty());){
            this.assertPlan(queryRunner, "SELECT source_col_a FROM test_table", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"DEST_COL"), PlanMatchPattern.tableScan("target_table", (Map<String, String>)ImmutableMap.of((Object)"DEST_COL", (Object)destinationColumnNameA))));
            this.assertPlan(queryRunner, "SELECT source_col_a, source_col_b FROM test_table", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"SOURCE_COLA", (Object)"SOURCE_COLB"), PlanMatchPattern.tableScan(TEST_TABLE, (Map<String, String>)ImmutableMap.of((Object)"SOURCE_COLA", (Object)sourceColumnNameA, (Object)"SOURCE_COLB", (Object)sourceColumnNameB))));
            this.assertPlan(queryRunner, "SELECT source_col_a FROM test_table WHERE source_col_a > 0", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"DEST_COL"), PlanMatchPattern.filter("DEST_COL > 0", PlanMatchPattern.tableScan((Predicate<ConnectorTableHandle>)Predicates.equalTo((Object)new MockConnectorTableHandle(destinationTable)), (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL", (Object)Predicates.equalTo((Object)destinationColumnHandleA))))));
        }
    }

    @Test
    public void testRedirectionAfterPredicatePushdownIntoTableScan() {
        try (LocalQueryRunner queryRunner = this.createLocalQueryRunner(this.getMockApplyRedirectAfterPredicatePushdown(redirectionMappingA, Optional.empty()), Optional.empty(), Optional.of(this.getMockApplyFilter((Set<ColumnHandle>)ImmutableSet.of((Object)sourceColumnHandleA, (Object)destinationColumnHandleA))));){
            this.assertPlan(queryRunner, "SELECT source_col_a FROM test_table WHERE source_col_a = 1", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"DEST_COL"), PlanMatchPattern.tableScan((Predicate<ConnectorTableHandle>)Predicates.equalTo((Object)new MockConnectorTableHandle(destinationTable)), (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)Predicates.equalTo((Object)destinationColumnHandleA), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)1L))), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL", (Object)Predicates.equalTo((Object)destinationColumnHandleA)))));
            this.assertPlan(queryRunner, "SELECT source_col_a FROM test_table", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"SOURCE_COL"), PlanMatchPattern.tableScan(TEST_TABLE, (Map<String, String>)ImmutableMap.of((Object)"SOURCE_COL", (Object)sourceColumnNameA))));
        }
    }

    @Test
    public void testPredicatePushdownAfterRedirect() {
        try (LocalQueryRunner queryRunner = this.createLocalQueryRunner(this.getMockApplyRedirectAfterPredicatePushdown(redirectionMappingAB, Optional.empty()), Optional.empty(), Optional.of(this.getMockApplyFilter((Set<ColumnHandle>)ImmutableSet.of((Object)sourceColumnHandleA, (Object)destinationColumnHandleB))));){
            this.assertPlan(queryRunner, "SELECT source_col_a, source_col_b FROM test_table WHERE source_col_a = 1 AND source_col_b = 2", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"DEST_COL_A", (Object)"DEST_COL_B"), PlanMatchPattern.filter("DEST_COL_A = 1", PlanMatchPattern.tableScan((Predicate<ConnectorTableHandle>)Predicates.equalTo((Object)new MockConnectorTableHandle(destinationTable)), (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)Predicates.equalTo((Object)destinationColumnHandleB), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)2L))), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL_A", (Object)Predicates.equalTo((Object)destinationColumnHandleA), (Object)"DEST_COL_B", (Object)Predicates.equalTo((Object)destinationColumnHandleB))))));
        }
    }

    @Test
    public void testRedirectAfterColumnPruningOnPushedDownPredicate() {
        try (LocalQueryRunner queryRunner = this.createLocalQueryRunner(this.getMockApplyRedirectAfterPredicatePushdown(redirectionMappingAB, Optional.of(ImmutableSet.of((Object)sourceColumnHandleB))), Optional.of(this::mockApplyProjection), Optional.of(this.getMockApplyFilter((Set<ColumnHandle>)ImmutableSet.of((Object)sourceColumnHandleA, (Object)destinationColumnHandleA))));){
            this.assertPlan(queryRunner, "SELECT source_col_b FROM test_table WHERE source_col_a = 1", PlanMatchPattern.output((List<String>)ImmutableList.of((Object)"DEST_COL_B"), PlanMatchPattern.tableScan((Predicate<ConnectorTableHandle>)Predicates.equalTo((Object)new MockConnectorTableHandle(destinationTable)), (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)"DEST_COL_B", (Object)Predicates.equalTo((Object)destinationColumnHandleB)))));
        }
    }

    @Test
    public void testPredicateTypeMismatch() {
        try (LocalQueryRunner queryRunner = this.createLocalQueryRunner(this.getMockApplyRedirectAfterPredicatePushdown(typeMismatchedRedirectionMappingBC, Optional.of(ImmutableSet.of((Object)sourceColumnHandleB))), Optional.of(this::mockApplyProjection), Optional.of(this.getMockApplyFilter((Set<ColumnHandle>)ImmutableSet.of((Object)sourceColumnHandleC))));){
            TransactionBuilder.transaction((TransactionManager)queryRunner.getTransactionManager(), (AccessControl)queryRunner.getAccessControl()).execute(MOCK_SESSION, session -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> queryRunner.createPlan(session, "SELECT source_col_b FROM test_table WHERE source_col_c = 'foo'", WarningCollector.NOOP)).isInstanceOf(PrestoException.class)).hasMessageMatching("Redirected column mock_catalog.target_schema.target_table.destination_col_a has type integer, different from source column .*MockConnectorTableHandle.*source_col_c.* type: varchar"));
        }
    }

    private LocalQueryRunner createLocalQueryRunner(MockConnectorFactory.ApplyTableScanRedirect applyTableScanRedirect, Optional<MockConnectorFactory.ApplyProjection> applyProjection, Optional<MockConnectorFactory.ApplyFilter> applyFilter) {
        LocalQueryRunner queryRunner = LocalQueryRunner.create((Session)MOCK_SESSION);
        MockConnectorFactory.Builder builder = MockConnectorFactory.builder().withGetTableHandle((session, schemaTableName) -> new MockConnectorTableHandle((SchemaTableName)schemaTableName)).withGetColumns(name -> {
            if (name.equals((Object)sourceTable)) {
                return ImmutableList.of((Object)new ColumnMetadata(sourceColumnNameA, (Type)IntegerType.INTEGER), (Object)new ColumnMetadata(sourceColumnNameB, (Type)IntegerType.INTEGER), (Object)new ColumnMetadata(sourceColumnNameC, (Type)VarcharType.VARCHAR));
            }
            if (name.equals((Object)destinationTable)) {
                return ImmutableList.of((Object)new ColumnMetadata(destinationColumnNameA, (Type)IntegerType.INTEGER), (Object)new ColumnMetadata(destinationColumnNameB, (Type)IntegerType.INTEGER));
            }
            throw new IllegalArgumentException();
        }).withApplyTableScanRedirect(applyTableScanRedirect);
        applyProjection.ifPresent(builder::withApplyProjection);
        applyFilter.ifPresent(builder::withApplyFilter);
        queryRunner.createCatalog(MOCK_CATALOG, (ConnectorFactory)builder.build(), (Map)ImmutableMap.of());
        return queryRunner;
    }

    private Optional<ProjectionApplicationResult<ConnectorTableHandle>> mockApplyProjection(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        MockConnectorTableHandle handle = (MockConnectorTableHandle)tableHandle;
        List variables = (List)projections.stream().map(Variable.class::cast).collect(ImmutableList.toImmutableList());
        List newColumns = (List)variables.stream().map(variable -> (ColumnHandle)assignments.get(variable.getName())).collect(ImmutableList.toImmutableList());
        if (handle.getColumns().isPresent() && newColumns.equals(handle.getColumns().get())) {
            return Optional.empty();
        }
        return Optional.of(new ProjectionApplicationResult((Object)new MockConnectorTableHandle(handle.getTableName(), handle.getConstraint(), Optional.of(newColumns)), projections, (List)variables.stream().map(variable -> new Assignment(variable.getName(), (ColumnHandle)assignments.get(variable.getName()), ((MockConnectorColumnHandle)assignments.get(variable.getName())).getType())).collect(ImmutableList.toImmutableList())));
    }

    private Optional<TableScanRedirectApplicationResult> mockApplyRedirectAfterProjectionPushdown(ConnectorSession session, ConnectorTableHandle handle) {
        MockConnectorTableHandle mockConnectorTable = (MockConnectorTableHandle)handle;
        Optional<List<ColumnHandle>> projectedColumns = mockConnectorTable.getColumns();
        if (projectedColumns.isEmpty()) {
            return Optional.empty();
        }
        List projectedColumnNames = (List)projectedColumns.get().stream().map(MockConnectorColumnHandle.class::cast).map(MockConnectorColumnHandle::getName).collect(ImmutableList.toImmutableList());
        if (!projectedColumnNames.equals(ImmutableList.of((Object)sourceColumnNameA))) {
            return Optional.empty();
        }
        return Optional.of(new TableScanRedirectApplicationResult(new CatalogSchemaTableName(MOCK_CATALOG, destinationTable), redirectionMappingA, mockConnectorTable.getConstraint().transform(MockConnectorColumnHandle.class::cast).transform(MockConnectorColumnHandle::getName)));
    }

    private MockConnectorFactory.ApplyFilter getMockApplyFilter(Set<ColumnHandle> pushdownColumns) {
        return (session, table, constraint) -> {
            TupleDomain newDomain;
            MockConnectorTableHandle handle = (MockConnectorTableHandle)table;
            TupleDomain<ColumnHandle> oldDomain = handle.getConstraint();
            if (oldDomain.equals((Object)(newDomain = oldDomain.intersect(constraint.getSummary().filter((columnHandle, domain) -> pushdownColumns.contains(columnHandle)))))) {
                return Optional.empty();
            }
            return Optional.of(new ConstraintApplicationResult((Object)new MockConnectorTableHandle(handle.getTableName(), (TupleDomain<ColumnHandle>)newDomain, Optional.empty()), constraint.getSummary().filter((columnHandle, domain) -> !pushdownColumns.contains(columnHandle))));
        };
    }

    private MockConnectorFactory.ApplyTableScanRedirect getMockApplyRedirectAfterPredicatePushdown(Map<ColumnHandle, String> redirectionMapping, Optional<Set<ColumnHandle>> requiredProjections) {
        return (session, handle) -> {
            MockConnectorTableHandle mockConnectorTable = (MockConnectorTableHandle)handle;
            if (mockConnectorTable.getConstraint().isAll()) {
                return Optional.empty();
            }
            Optional<List<ColumnHandle>> projectedColumns = mockConnectorTable.getColumns();
            if (requiredProjections.isPresent() && (projectedColumns.isEmpty() || !((Set)requiredProjections.get()).equals(ImmutableSet.copyOf((Collection)projectedColumns.get())))) {
                return Optional.empty();
            }
            return Optional.of(new TableScanRedirectApplicationResult(new CatalogSchemaTableName(MOCK_CATALOG, destinationTable), redirectionMapping, mockConnectorTable.getConstraint().transform(MockConnectorColumnHandle.class::cast).transform(redirectionMapping::get)));
        };
    }

    void assertPlan(LocalQueryRunner queryRunner, @Language(value="SQL") String sql, PlanMatchPattern pattern) {
        List optimizers = queryRunner.getPlanOptimizers(true);
        queryRunner.inTransaction(transactionSession -> {
            Plan actualPlan = queryRunner.createPlan(transactionSession, sql, optimizers, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, WarningCollector.NOOP);
            PlanAssert.assertPlan(transactionSession, queryRunner.getMetadata(), queryRunner.getStatsCalculator(), actualPlan, pattern);
            return null;
        });
    }
}

