/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.Preconditions;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.assertions.Util;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.TableScanNode;
import java.util.Objects;
import java.util.function.Predicate;

public class ConnectorAwareTableScanMatcher
implements Matcher {
    private final Predicate<ConnectorTableHandle> expectedTable;
    private final TupleDomain<Predicate<ColumnHandle>> expectedEnforcedConstraint;

    public ConnectorAwareTableScanMatcher(Predicate<ConnectorTableHandle> expectedTable, TupleDomain<Predicate<ColumnHandle>> expectedEnforcedConstraint) {
        this.expectedTable = Objects.requireNonNull(expectedTable, "expectedTable is null");
        this.expectedEnforcedConstraint = Objects.requireNonNull(expectedEnforcedConstraint, "expectedEnforcedConstraint is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof TableScanNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        TableScanNode tableScanNode = (TableScanNode)node;
        TupleDomain actual = tableScanNode.getEnforcedConstraint();
        boolean tableMatches = this.expectedTable.test(tableScanNode.getTable().getConnectorHandle());
        return new MatchResult(tableMatches && Util.domainsMatch(this.expectedEnforcedConstraint, (TupleDomain<ColumnHandle>)actual));
    }

    public static PlanMatchPattern create(Predicate<ConnectorTableHandle> table, TupleDomain<Predicate<ColumnHandle>> constraints) {
        return PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0]).with(new ConnectorAwareTableScanMatcher(table, constraints));
    }
}

