/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.Preconditions;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.tree.ArithmeticBinaryExpression;
import io.prestosql.sql.tree.ArithmeticUnaryExpression;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.BetweenPredicate;
import io.prestosql.sql.tree.BooleanLiteral;
import io.prestosql.sql.tree.Cast;
import io.prestosql.sql.tree.CoalesceExpression;
import io.prestosql.sql.tree.ComparisonExpression;
import io.prestosql.sql.tree.DecimalLiteral;
import io.prestosql.sql.tree.DereferenceExpression;
import io.prestosql.sql.tree.DoubleLiteral;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.FunctionCall;
import io.prestosql.sql.tree.GenericLiteral;
import io.prestosql.sql.tree.IfExpression;
import io.prestosql.sql.tree.InListExpression;
import io.prestosql.sql.tree.InPredicate;
import io.prestosql.sql.tree.IsNotNullPredicate;
import io.prestosql.sql.tree.IsNullPredicate;
import io.prestosql.sql.tree.LambdaExpression;
import io.prestosql.sql.tree.LikePredicate;
import io.prestosql.sql.tree.LogicalBinaryExpression;
import io.prestosql.sql.tree.LongLiteral;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NotExpression;
import io.prestosql.sql.tree.NullLiteral;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Row;
import io.prestosql.sql.tree.SearchedCaseExpression;
import io.prestosql.sql.tree.SimpleCaseExpression;
import io.prestosql.sql.tree.StringLiteral;
import io.prestosql.sql.tree.SubscriptExpression;
import io.prestosql.sql.tree.SymbolReference;
import io.prestosql.sql.tree.TimestampLiteral;
import io.prestosql.sql.tree.TryExpression;
import io.prestosql.sql.tree.WhenClause;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ExpressionVerifier
extends AstVisitor<Boolean, Node> {
    private final SymbolAliases symbolAliases;

    public ExpressionVerifier(SymbolAliases symbolAliases) {
        this.symbolAliases = Objects.requireNonNull(symbolAliases, "symbolAliases is null");
    }

    protected Boolean visitNode(Node node, Node expectedExpression) {
        throw new IllegalStateException(String.format("Node %s is not supported", node.getClass().getSimpleName()));
    }

    protected Boolean visitGenericLiteral(GenericLiteral actual, Node expectedExpression) {
        if (!(expectedExpression instanceof GenericLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression)) && actual.getType().equals(((GenericLiteral)expectedExpression).getType());
    }

    protected Boolean visitStringLiteral(StringLiteral actual, Node expectedExpression) {
        if (!(expectedExpression instanceof StringLiteral)) {
            return false;
        }
        StringLiteral expected = (StringLiteral)expectedExpression;
        return actual.getValue().equals(expected.getValue());
    }

    protected Boolean visitLongLiteral(LongLiteral actual, Node expectedExpression) {
        if (!(expectedExpression instanceof LongLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitDoubleLiteral(DoubleLiteral actual, Node expectedExpression) {
        if (!(expectedExpression instanceof DoubleLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitDecimalLiteral(DecimalLiteral actual, Node expectedExpression) {
        if (!(expectedExpression instanceof DecimalLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitTimestampLiteral(TimestampLiteral actual, Node expectedExpression) {
        if (!(expectedExpression instanceof TimestampLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitBooleanLiteral(BooleanLiteral actual, Node expectedExpression) {
        if (!(expectedExpression instanceof BooleanLiteral)) {
            return false;
        }
        return ExpressionVerifier.getValueFromLiteral((Node)actual).equals(ExpressionVerifier.getValueFromLiteral(expectedExpression));
    }

    protected Boolean visitNullLiteral(NullLiteral node, Node expectedExpression) {
        return expectedExpression instanceof NullLiteral;
    }

    private static String getValueFromLiteral(Node expression) {
        if (expression instanceof LongLiteral) {
            return String.valueOf(((LongLiteral)expression).getValue());
        }
        if (expression instanceof BooleanLiteral) {
            return String.valueOf(((BooleanLiteral)expression).getValue());
        }
        if (expression instanceof DoubleLiteral) {
            return String.valueOf(((DoubleLiteral)expression).getValue());
        }
        if (expression instanceof DecimalLiteral) {
            return String.valueOf(((DecimalLiteral)expression).getValue());
        }
        if (expression instanceof TimestampLiteral) {
            return ((TimestampLiteral)expression).getValue();
        }
        if (expression instanceof GenericLiteral) {
            return ((GenericLiteral)expression).getValue();
        }
        throw new IllegalArgumentException("Unsupported literal expression type: " + expression.getClass().getName());
    }

    protected Boolean visitSymbolReference(SymbolReference actual, Node expectedExpression) {
        if (!(expectedExpression instanceof SymbolReference)) {
            return false;
        }
        SymbolReference expected = (SymbolReference)expectedExpression;
        return this.symbolAliases.get(expected.getName()).equals((Object)actual);
    }

    protected Boolean visitDereferenceExpression(DereferenceExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof DereferenceExpression)) {
            return false;
        }
        DereferenceExpression expected = (DereferenceExpression)expectedExpression;
        return actual.getField().equals((Object)expected.getField()) && (Boolean)this.process((Node)actual.getBase(), expected.getBase()) != false;
    }

    protected Boolean visitIfExpression(IfExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof IfExpression)) {
            return false;
        }
        IfExpression expected = (IfExpression)expectedExpression;
        return (Boolean)this.process((Node)actual.getCondition(), expected.getCondition()) != false && (Boolean)this.process((Node)actual.getTrueValue(), expected.getTrueValue()) != false && this.process(actual.getFalseValue(), expected.getFalseValue());
    }

    protected Boolean visitCast(Cast actual, Node expectedExpression) {
        if (!(expectedExpression instanceof Cast)) {
            return false;
        }
        Cast expected = (Cast)expectedExpression;
        if (!actual.getType().toString().equalsIgnoreCase(expected.getType().toString())) {
            return false;
        }
        return (Boolean)this.process((Node)actual.getExpression(), expected.getExpression());
    }

    protected Boolean visitIsNullPredicate(IsNullPredicate actual, Node expectedExpression) {
        if (!(expectedExpression instanceof IsNullPredicate)) {
            return false;
        }
        IsNullPredicate expected = (IsNullPredicate)expectedExpression;
        return (Boolean)this.process((Node)actual.getValue(), expected.getValue());
    }

    protected Boolean visitIsNotNullPredicate(IsNotNullPredicate actual, Node expectedExpression) {
        if (!(expectedExpression instanceof IsNotNullPredicate)) {
            return false;
        }
        IsNotNullPredicate expected = (IsNotNullPredicate)expectedExpression;
        return (Boolean)this.process((Node)actual.getValue(), expected.getValue());
    }

    protected Boolean visitInPredicate(InPredicate actual, Node expectedExpression) {
        if (!(expectedExpression instanceof InPredicate)) {
            return false;
        }
        InPredicate expected = (InPredicate)expectedExpression;
        if (actual.getValueList() instanceof InListExpression || !(expected.getValueList() instanceof InListExpression)) {
            return (Boolean)this.process((Node)actual.getValue(), expected.getValue()) != false && (Boolean)this.process((Node)actual.getValueList(), expected.getValueList()) != false;
        }
        List values = ((InListExpression)expected.getValueList()).getValues();
        Preconditions.checkState((values.size() == 1 ? 1 : 0) != 0, (String)"Multiple expressions in expected value list %s, but actual value is not a list", (Object)values, (Object)actual.getValue());
        Expression onlyExpectedExpression = (Expression)values.get(0);
        return (Boolean)this.process((Node)actual.getValue(), expected.getValue()) != false && (Boolean)this.process((Node)actual.getValueList(), onlyExpectedExpression) != false;
    }

    protected Boolean visitInListExpression(InListExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof InListExpression)) {
            return false;
        }
        InListExpression expected = (InListExpression)expectedExpression;
        return this.process(actual.getValues(), expected.getValues());
    }

    protected Boolean visitComparisonExpression(ComparisonExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof ComparisonExpression)) {
            return false;
        }
        ComparisonExpression expected = (ComparisonExpression)expectedExpression;
        if (actual.getOperator() == expected.getOperator() && ((Boolean)this.process((Node)actual.getLeft(), expected.getLeft())).booleanValue() && ((Boolean)this.process((Node)actual.getRight(), expected.getRight())).booleanValue()) {
            return true;
        }
        return actual.getOperator() == expected.getOperator().flip() && (Boolean)this.process((Node)actual.getLeft(), expected.getRight()) != false && (Boolean)this.process((Node)actual.getRight(), expected.getLeft()) != false;
    }

    protected Boolean visitBetweenPredicate(BetweenPredicate actual, Node expectedExpression) {
        if (!(expectedExpression instanceof BetweenPredicate)) {
            return false;
        }
        BetweenPredicate expected = (BetweenPredicate)expectedExpression;
        return (Boolean)this.process((Node)actual.getValue(), expected.getValue()) != false && (Boolean)this.process((Node)actual.getMin(), expected.getMin()) != false && (Boolean)this.process((Node)actual.getMax(), expected.getMax()) != false;
    }

    protected Boolean visitArithmeticUnary(ArithmeticUnaryExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof ArithmeticUnaryExpression)) {
            return false;
        }
        ArithmeticUnaryExpression expected = (ArithmeticUnaryExpression)expectedExpression;
        return actual.getSign() == expected.getSign() && (Boolean)this.process((Node)actual.getValue(), expected.getValue()) != false;
    }

    protected Boolean visitArithmeticBinary(ArithmeticBinaryExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof ArithmeticBinaryExpression)) {
            return false;
        }
        ArithmeticBinaryExpression expected = (ArithmeticBinaryExpression)expectedExpression;
        return actual.getOperator() == expected.getOperator() && (Boolean)this.process((Node)actual.getLeft(), expected.getLeft()) != false && (Boolean)this.process((Node)actual.getRight(), expected.getRight()) != false;
    }

    protected Boolean visitNotExpression(NotExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof NotExpression)) {
            return false;
        }
        NotExpression expected = (NotExpression)expectedExpression;
        return (Boolean)this.process((Node)actual.getValue(), expected.getValue());
    }

    protected Boolean visitLogicalBinaryExpression(LogicalBinaryExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof LogicalBinaryExpression)) {
            return false;
        }
        LogicalBinaryExpression expected = (LogicalBinaryExpression)expectedExpression;
        return actual.getOperator() == expected.getOperator() && (Boolean)this.process((Node)actual.getLeft(), expected.getLeft()) != false && (Boolean)this.process((Node)actual.getRight(), expected.getRight()) != false;
    }

    protected Boolean visitCoalesceExpression(CoalesceExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof CoalesceExpression)) {
            return false;
        }
        CoalesceExpression expected = (CoalesceExpression)expectedExpression;
        if (actual.getOperands().size() != expected.getOperands().size()) {
            return false;
        }
        for (int i = 0; i < actual.getOperands().size(); ++i) {
            if (((Boolean)this.process((Node)actual.getOperands().get(i), (Node)expected.getOperands().get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    protected Boolean visitSimpleCaseExpression(SimpleCaseExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof SimpleCaseExpression)) {
            return false;
        }
        SimpleCaseExpression expected = (SimpleCaseExpression)expectedExpression;
        return (Boolean)this.process((Node)actual.getOperand(), expected.getOperand()) != false && this.process(actual.getWhenClauses(), expected.getWhenClauses()) && this.process(actual.getDefaultValue(), expected.getDefaultValue());
    }

    protected Boolean visitSearchedCaseExpression(SearchedCaseExpression actual, Node expected) {
        if (!(expected instanceof SearchedCaseExpression)) {
            return false;
        }
        SearchedCaseExpression expectedCase = (SearchedCaseExpression)expected;
        if (!this.process(actual.getWhenClauses(), expectedCase.getWhenClauses())) {
            return false;
        }
        if (actual.getDefaultValue().isPresent() != expectedCase.getDefaultValue().isPresent()) {
            return false;
        }
        return this.process(actual.getDefaultValue(), expectedCase.getDefaultValue());
    }

    protected Boolean visitWhenClause(WhenClause actual, Node expectedExpression) {
        if (!(expectedExpression instanceof WhenClause)) {
            return false;
        }
        WhenClause expected = (WhenClause)expectedExpression;
        return (Boolean)this.process((Node)actual.getOperand(), expected.getOperand()) != false && (Boolean)this.process((Node)actual.getResult(), expected.getResult()) != false;
    }

    protected Boolean visitFunctionCall(FunctionCall actual, Node expectedExpression) {
        if (!(expectedExpression instanceof FunctionCall)) {
            return false;
        }
        FunctionCall expected = (FunctionCall)expectedExpression;
        return actual.isDistinct() == expected.isDistinct() && ResolvedFunction.extractFunctionName((QualifiedName)actual.getName()).equals(ResolvedFunction.extractFunctionName((QualifiedName)expected.getName())) && this.process(actual.getArguments(), expected.getArguments()) && this.process(actual.getFilter(), expected.getFilter()) && this.process(actual.getWindow(), expected.getWindow());
    }

    protected Boolean visitLambdaExpression(LambdaExpression actual, Node expected) {
        if (!(expected instanceof LambdaExpression)) {
            return false;
        }
        LambdaExpression lambdaExpression = (LambdaExpression)expected;
        if (!actual.getArguments().equals(lambdaExpression.getArguments())) {
            return false;
        }
        return (Boolean)this.process((Node)actual.getBody(), lambdaExpression.getBody());
    }

    protected Boolean visitRow(Row actual, Node expectedExpression) {
        if (!(expectedExpression instanceof Row)) {
            return false;
        }
        Row expected = (Row)expectedExpression;
        return this.process(actual.getItems(), expected.getItems());
    }

    protected Boolean visitTryExpression(TryExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof TryExpression)) {
            return false;
        }
        TryExpression expected = (TryExpression)expectedExpression;
        return (Boolean)this.process((Node)actual.getInnerExpression(), expected.getInnerExpression());
    }

    protected Boolean visitLikePredicate(LikePredicate actual, Node expectedExpression) {
        if (!(expectedExpression instanceof LikePredicate)) {
            return false;
        }
        LikePredicate expected = (LikePredicate)expectedExpression;
        return (Boolean)this.process((Node)actual.getValue(), expected.getValue()) != false && (Boolean)this.process((Node)actual.getPattern(), expected.getPattern()) != false && this.process(actual.getEscape(), expected.getEscape());
    }

    protected Boolean visitSubscriptExpression(SubscriptExpression actual, Node expectedExpression) {
        if (!(expectedExpression instanceof SubscriptExpression)) {
            return false;
        }
        SubscriptExpression expected = (SubscriptExpression)expectedExpression;
        return (Boolean)this.process((Node)actual.getBase(), expected.getBase()) != false && (Boolean)this.process((Node)actual.getIndex(), expected.getIndex()) != false;
    }

    private <T extends Node> boolean process(List<T> actuals, List<T> expecteds) {
        if (actuals.size() != expecteds.size()) {
            return false;
        }
        for (int i = 0; i < actuals.size(); ++i) {
            if (((Boolean)this.process((Node)actuals.get(i), (Node)expecteds.get(i))).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private <T extends Node> boolean process(Optional<T> actual, Optional<T> expected) {
        if (actual.isPresent() != expected.isPresent()) {
            return false;
        }
        if (actual.isPresent()) {
            return (Boolean)this.process((Node)actual.get(), (Node)expected.get());
        }
        return true;
    }
}

