/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.assertions.ExpectedValueProvider;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.PlanTestSymbol;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.plan.IndexJoinNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

final class IndexJoinMatcher
implements Matcher {
    private final IndexJoinNode.Type type;
    private final List<ExpectedValueProvider<IndexJoinNode.EquiJoinClause>> criteria;
    private final Optional<PlanTestSymbol> probeHashSymbol;
    private final Optional<PlanTestSymbol> indexHashSymbol;

    IndexJoinMatcher(IndexJoinNode.Type type, List<ExpectedValueProvider<IndexJoinNode.EquiJoinClause>> criteria, Optional<PlanTestSymbol> probeHashSymbol, Optional<PlanTestSymbol> indexHashSymbol) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.criteria = Objects.requireNonNull(criteria, "criteria is null");
        this.probeHashSymbol = Objects.requireNonNull(probeHashSymbol, "probeHashSymbol is null");
        this.indexHashSymbol = Objects.requireNonNull(indexHashSymbol, "indexHashSymbol is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof IndexJoinNode)) {
            return false;
        }
        IndexJoinNode indexJoinNode = (IndexJoinNode)node;
        return indexJoinNode.getType() == this.type;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        IndexJoinNode indexJoinNode = (IndexJoinNode)node;
        if (indexJoinNode.getCriteria().size() != this.criteria.size()) {
            return MatchResult.NO_MATCH;
        }
        ImmutableSet actualCriteria = ImmutableSet.copyOf((Collection)indexJoinNode.getCriteria());
        Set expectedCriteria = (Set)this.criteria.stream().map(equiClause -> (IndexJoinNode.EquiJoinClause)equiClause.getExpectedValue(symbolAliases)).collect(ImmutableSet.toImmutableSet());
        if (!expectedCriteria.equals(actualCriteria)) {
            return MatchResult.NO_MATCH;
        }
        if (!indexJoinNode.getProbeHashSymbol().equals(this.probeHashSymbol.map(alias -> alias.toSymbol(symbolAliases)))) {
            return MatchResult.NO_MATCH;
        }
        if (!indexJoinNode.getIndexHashSymbol().equals(this.indexHashSymbol.map(alias -> alias.toSymbol(symbolAliases)))) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("type", (Object)this.type).add("criteria", this.criteria).add("probeHashSymbol", this.probeHashSymbol.orElse(null)).add("indexHashSymbol", this.indexHashSymbol.orElse(null)).toString();
    }
}

