/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.OrderingScheme;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.Matcher;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.SymbolAliases;
import io.prestosql.sql.planner.assertions.Util;
import io.prestosql.sql.planner.plan.LimitNode;
import io.prestosql.sql.planner.plan.PlanNode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class LimitMatcher
implements Matcher {
    private final long limit;
    private final List<PlanMatchPattern.Ordering> tiesResolvers;
    private final boolean partial;

    public LimitMatcher(long limit, List<PlanMatchPattern.Ordering> tiesResolvers, boolean partial) {
        this.limit = limit;
        this.tiesResolvers = ImmutableList.copyOf((Collection)Objects.requireNonNull(tiesResolvers, "tiesResolvers is null"));
        this.partial = partial;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        if (!(node instanceof LimitNode)) {
            return false;
        }
        LimitNode limitNode = (LimitNode)node;
        return limitNode.getCount() == this.limit && limitNode.isWithTies() == !this.tiesResolvers.isEmpty() && limitNode.isPartial() == this.partial;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node));
        if (!((LimitNode)node).isWithTies()) {
            return MatchResult.match();
        }
        OrderingScheme tiesResolvingScheme = (OrderingScheme)((LimitNode)node).getTiesResolvingScheme().get();
        if (Util.orderingSchemeMatches(this.tiesResolvers, tiesResolvingScheme, symbolAliases)) {
            return MatchResult.match();
        }
        return MatchResult.NO_MATCH;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("limit", this.limit).add("tiesResolvers", this.tiesResolvers).add("partial", this.partial).toString();
    }
}

