/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.planner.assertions;

import io.prestosql.Session;
import io.prestosql.cost.CachingStatsProvider;
import io.prestosql.cost.StatsAndCosts;
import io.prestosql.cost.StatsCalculator;
import io.prestosql.cost.StatsProvider;
import io.prestosql.metadata.Metadata;
import io.prestosql.sql.planner.Plan;
import io.prestosql.sql.planner.TypeProvider;
import io.prestosql.sql.planner.assertions.MatchResult;
import io.prestosql.sql.planner.assertions.PlanMatchPattern;
import io.prestosql.sql.planner.assertions.PlanMatchingVisitor;
import io.prestosql.sql.planner.iterative.Lookup;
import io.prestosql.sql.planner.iterative.Plans;
import io.prestosql.sql.planner.plan.PlanNode;
import io.prestosql.sql.planner.plan.PlanVisitor;
import io.prestosql.sql.planner.planprinter.PlanPrinter;

public final class PlanAssert {
    private PlanAssert() {
    }

    public static void assertPlan(Session session, Metadata metadata, StatsCalculator statsCalculator, Plan actual, PlanMatchPattern pattern) {
        PlanAssert.assertPlan(session, metadata, statsCalculator, actual, Lookup.noLookup(), pattern);
    }

    public static void assertPlan(Session session, Metadata metadata, StatsCalculator statsCalculator, Plan actual, Lookup lookup, PlanMatchPattern pattern) {
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, session, actual.getTypes());
        PlanAssert.assertPlan(session, metadata, (StatsProvider)statsProvider, actual, lookup, pattern);
    }

    public static void assertPlan(Session session, Metadata metadata, StatsProvider statsProvider, Plan actual, Lookup lookup, PlanMatchPattern pattern) {
        MatchResult matches = (MatchResult)actual.getRoot().accept((PlanVisitor)new PlanMatchingVisitor(session, metadata, statsProvider, lookup), (Object)pattern);
        if (!matches.isMatch()) {
            String formattedPlan = PlanPrinter.textLogicalPlan((PlanNode)actual.getRoot(), (TypeProvider)actual.getTypes(), (Metadata)metadata, (StatsAndCosts)StatsAndCosts.empty(), (Session)session, (int)0, (boolean)false);
            PlanNode resolvedPlan = Plans.resolveGroupReferences((PlanNode)actual.getRoot(), (Lookup)lookup);
            String resolvedFormattedPlan = PlanPrinter.textLogicalPlan((PlanNode)resolvedPlan, (TypeProvider)actual.getTypes(), (Metadata)metadata, (StatsAndCosts)StatsAndCosts.empty(), (Session)session, (int)0, (boolean)false);
            throw new AssertionError((Object)String.format("Plan does not match, expected [\n\n%s\n] but found [\n\n%s\n] which resolves to [\n\n%s\n]", pattern, formattedPlan, resolvedFormattedPlan));
        }
    }
}

